<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(
        array $section = [],
        array $items = [],
        array $company = [],
        array $social = [],
        array $services = [],
        bool $isWhiteBackground = false,
        ?int $paddingTop = null,
        ?int $paddingBottom = null
    ) {
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        // Default partner logos (using placeholder company logos)
        $defaultItems = [
            ['name' => 'TechCorp', 'logo' => 'https://cdn.jsdelivr.net/gh/devicons/devicon/icons/google/google-original.svg'],
            ['name' => 'InnovateCo', 'logo' => 'https://cdn.jsdelivr.net/gh/devicons/devicon/icons/apple/apple-original.svg'],
            ['name' => 'GlobalTech', 'logo' => 'https://cdn.jsdelivr.net/gh/devicons/devicon/icons/microsoft/microsoft-original.svg'],
            ['name' => 'FutureLabs', 'logo' => 'https://cdn.jsdelivr.net/gh/devicons/devicon/icons/amazonwebservices/amazonwebservices-original-wordmark.svg'],
            ['name' => 'SmartSolutions', 'logo' => 'https://cdn.jsdelivr.net/gh/devicons/devicon/icons/slack/slack-original.svg'],
            ['name' => 'NextGen', 'logo' => 'https://cdn.jsdelivr.net/gh/devicons/devicon/icons/github/github-original.svg'],
        ];

        $this->items = !empty($items) ? $items : $defaultItems;

        $this->section = array_merge([
            'badge' => 'Our Partners',
            'title' => 'Trusted by Industry Leaders',
            'subtitle' => 'We collaborate with the best companies to deliver exceptional results.',
            'grayscale' => false, // Default: logos in full color
            'show_title' => false, // Default: hide partner names
        ], $section);
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>

<div>
<section id="partners" class="section {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {{-- Section Header --}}
        <div class="text-center mb-16">
            <span class="badge badge-primary mb-4">{{ $section['badge'] }}</span>
            <h2 class="section-title">{{ $section['title'] }}</h2>
            <p class="section-subtitle">{{ $section['subtitle'] }}</p>
        </div>

        {{-- Partners Logos - Infinite Scroll --}}
        @if(count($items) > 0)
        <div class="relative overflow-hidden scroll-animate" data-animation="fade-up">
            <div class="partners-track flex items-center gap-16" style="width: max-content;">
                {{-- First set of logos --}}
                @foreach($items as $partner)
                <div class="partner-logo {{ ($section['grayscale'] ?? false) ? 'grayscale-mode' : '' }} flex-shrink-0 px-4 {{ ($section['show_title'] ?? false) ? 'flex flex-col items-center' : 'h-12' }}">
                    @if(!empty($partner['logo_url']) || !empty($partner['logo']))
                    <img src="{{ $partner['logo_url'] ?? $partner['logo'] }}" alt="{{ $partner['name'] ?? '' }}" class="{{ ($section['show_title'] ?? false) ? 'h-12' : 'h-full' }} w-auto object-contain">
                    @if(($section['show_title'] ?? false) && !empty($partner['name']))
                    <span class="partner-title whitespace-nowrap">{{ $partner['name'] }}</span>
                    @endif
                    @elseif(!empty($partner['name']))
                    <span class="text-2xl font-bold text-gray-400 dark:text-gray-500 whitespace-nowrap">{{ $partner['name'] }}</span>
                    @endif
                </div>
                @endforeach
                {{-- Duplicate for seamless loop --}}
                @foreach($items as $partner)
                <div class="partner-logo {{ ($section['grayscale'] ?? false) ? 'grayscale-mode' : '' }} flex-shrink-0 px-4 {{ ($section['show_title'] ?? false) ? 'flex flex-col items-center' : 'h-12' }}">
                    @if(!empty($partner['logo_url']) || !empty($partner['logo']))
                    <img src="{{ $partner['logo_url'] ?? $partner['logo'] }}" alt="{{ $partner['name'] ?? '' }}" class="{{ ($section['show_title'] ?? false) ? 'h-12' : 'h-full' }} w-auto object-contain">
                    @if(($section['show_title'] ?? false) && !empty($partner['name']))
                    <span class="partner-title whitespace-nowrap">{{ $partner['name'] }}</span>
                    @endif
                    @elseif(!empty($partner['name']))
                    <span class="text-2xl font-bold text-gray-400 dark:text-gray-500 whitespace-nowrap">{{ $partner['name'] }}</span>
                    @endif
                </div>
                @endforeach
            </div>
        </div>

        {{-- Static Grid (shown below infinite scroll) --}}
        <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-6 gap-8 items-center mt-12">
            @foreach($items as $index => $partner)
            <div class="partner-logo {{ ($section['grayscale'] ?? false) ? 'grayscale-mode' : '' }} flex flex-col items-center justify-center {{ ($section['show_title'] ?? false) ? 'h-auto py-4' : 'h-20' }} p-4 bg-white dark:bg-gray-800 rounded-xl shadow-lg border border-gray-100 dark:border-gray-700 scroll-animate" data-animation="fade-up" style="animation-delay: {{ $index * 100 }}ms">
                @if(!empty($partner['logo_url']) || !empty($partner['logo']))
                <img src="{{ $partner['logo_url'] ?? $partner['logo'] }}" alt="{{ $partner['name'] ?? '' }}" class="max-h-full max-w-full object-contain {{ ($section['show_title'] ?? false) ? 'h-16' : '' }}">
                @if(($section['show_title'] ?? false) && !empty($partner['name']))
                <span class="partner-title">{{ $partner['name'] }}</span>
                @endif
                @elseif(!empty($partner['name']))
                <span class="text-lg font-bold text-gray-400 dark:text-gray-500">{{ $partner['name'] }}</span>
                @endif
            </div>
            @endforeach
        </div>
        @endif
    </div>
</section>

<style>
    .partners-track {
        animation: scroll-partners 30s linear infinite;
    }
    .partners-track:hover {
        animation-play-state: paused;
    }
    @keyframes scroll-partners {
        0% {
            transform: translateX(0);
        }
        100% {
            transform: translateX(-50%);
        }
    }
    [dir="rtl"] .partners-track {
        animation-name: scroll-partners-rtl;
    }
    @keyframes scroll-partners-rtl {
        0% {
            transform: translateX(0);
        }
        100% {
            transform: translateX(50%);
        }
    }
    .partner-logo {
        transition: all 0.3s ease;
    }

    /* Grayscale mode - logos appear gray and become colorful on hover */
    .partner-logo.grayscale-mode img {
        filter: grayscale(100%);
        opacity: 0.6;
        transition: all 0.3s ease;
    }
    .partner-logo.grayscale-mode:hover img {
        filter: grayscale(0%);
        opacity: 1;
        transform: scale(1.05);
    }

    /* Color mode - logos appear in full color with subtle zoom on hover */
    .partner-logo:not(.grayscale-mode) img {
        filter: grayscale(0%);
        opacity: 1;
        transition: all 0.3s ease;
    }
    .partner-logo:not(.grayscale-mode):hover img {
        transform: scale(1.05);
    }

    /* Partner title styling */
    .partner-title {
        margin-top: 0.5rem;
        font-size: 0.875rem;
        font-weight: 500;
        text-align: center;
        color: #6b7280;
    }
    .dark .partner-title {
        color: #9ca3af;
    }
</style>
</div>
