<?php
use Livewire\Component;
new class extends Component {
    public array $section = [];
    public array $items = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(array $section = [], array $items = [], array $company = [], array $social = [], array $services = [], bool $isWhiteBackground = false, ?int $paddingTop = null, ?int $paddingBottom = null)
    {
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        $this->items = !empty($items)
            ? $items
            : [
                ['name' => 'Basic', 'price' => '29', 'period' => 'per month', 'description' => 'Perfect for individuals', 'features' => [['icon' => 'lucide:scale', 'text' => '15 lbs of laundry', 'is_included' => true], ['icon' => 'lucide:sparkles', 'text' => 'Wash & fold service', 'is_included' => true], ['icon' => 'lucide:truck', 'text' => 'Free pickup & delivery', 'is_included' => true], ['icon' => 'lucide:clock', 'text' => '48-hour turnaround', 'is_included' => true], ['icon' => 'lucide:leaf', 'text' => 'Premium eco detergents', 'is_included' => false]], 'popular' => false],
                ['name' => 'Family', 'price' => '79', 'period' => 'per month', 'description' => 'Best for families', 'features' => [['icon' => 'lucide:scale', 'text' => '50 lbs of laundry', 'is_included' => true], ['icon' => 'lucide:sparkles', 'text' => 'Wash, fold & iron', 'is_included' => true], ['icon' => 'lucide:truck', 'text' => 'Free pickup & delivery', 'is_included' => true], ['icon' => 'lucide:clock', 'text' => '24-hour turnaround', 'is_included' => true], ['icon' => 'lucide:leaf', 'text' => 'Premium eco detergents', 'is_included' => true]], 'popular' => true],
                ['name' => 'Business', 'price' => '199', 'period' => 'per month', 'description' => 'For businesses & hotels', 'features' => [['icon' => 'lucide:infinity', 'text' => 'Unlimited laundry', 'is_included' => true], ['icon' => 'lucide:badge-check', 'text' => 'All services included', 'is_included' => true], ['icon' => 'lucide:zap', 'text' => 'Same-day turnaround', 'is_included' => true], ['icon' => 'lucide:user-circle', 'text' => 'Dedicated account manager', 'is_included' => true], ['icon' => 'lucide:phone', 'text' => 'Priority support', 'is_included' => true]], 'popular' => false],
            ];

        $this->section = array_merge(['badge' => 'Pricing Plans', 'title' => 'Compare Our Plans', 'subtitle' => 'Find the perfect plan for your needs', 'currency_symbol' => '$', 'popular_badge' => 'Most Popular', 'cta_button' => 'Get Started', 'cta_button_url' => '#contact'], $section);
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>
<section
    class="pricing-comparison-section {{ $isWhiteBackground ? 'pricing-comparison-white' : 'pricing-comparison-gray' }}"
    @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    <div class="pricing-comparison-bg"></div>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative">
        <div class="text-center mb-12">
            <span class="pricing-comparison-badge">{{ $section['badge'] }}</span>
            <h2 class="pricing-comparison-title">{{ $section['title'] }}</h2>
            <p class="pricing-comparison-subtitle">{{ $section['subtitle'] }}</p>
        </div>
        <div class="pricing-comparison-table-container">
            <table class="pricing-comparison-table">
                <thead>
                    <tr>
                        <th class="pricing-comparison-th-feature">Features</th>
                        @foreach ($items as $plan)
                            <th
                                class="pricing-comparison-th-plan {{ $plan['popular'] ? 'pricing-comparison-popular' : '' }}">
                                @if ($plan['popular'])
                                    <div class="pricing-comparison-popular-tag">{{ $section['popular_badge'] }}</div>
                                @endif
                                <div class="pricing-comparison-plan-name">{{ $plan['name'] }}</div>
                                <div class="pricing-comparison-price">
                                    {{ $section['currency_symbol'] }}{{ $plan['price'] }}</div>
                                <div class="pricing-comparison-period">/{{ $plan['period'] }}</div>
                                <a href="{{ $section['cta_button_url'] ?? '#contact' }}"
                                    class="pricing-comparison-btn">{{ $section['cta_button'] }}</a>
                            </th>
                        @endforeach
                    </tr>
                </thead>
                <tbody>
                    @php
                        $allFeatures = [];
                        foreach ($items as $p) {
                            foreach ($p['features'] ?? [] as $f) {
                                $allFeatures[$f['text']] = true;
                            }
                        }
                    @endphp
                    @foreach (array_keys($allFeatures) as $featureText)
                        <tr class="pricing-comparison-row">
                            <td class="pricing-comparison-feature-name">{{ $featureText }}</td>
                            @php $featureIncludedInPreviousPlan = false; @endphp
                            @foreach ($items as $planIndex => $plan)
                                @php
                                    $feature = collect($plan['features'] ?? [])->firstWhere('text', $featureText);
                                    $isExplicitlyIncluded = $feature ? $feature['is_included'] ?? false : false;
                                    // If feature was included in previous plan, it's included in current plan too
                                    $isIncluded = $isExplicitlyIncluded || $featureIncludedInPreviousPlan;
                                    // Update for next iteration
                                    if ($isIncluded) {
                                        $featureIncludedInPreviousPlan = true;
                                    }
                                @endphp
                                <td class="pricing-comparison-cell">
                                    @if ($isIncluded)
                                        <x-icon icon="lucide:check-circle" class="pricing-comparison-check" />
                                    @else
                                        <x-icon icon="lucide:minus" class="pricing-comparison-minus" />
                                    @endif
                                </td>
                            @endforeach
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</section>
<style>
    .pricing-comparison-section {
        position: relative;
        padding: 6rem 0;
        overflow: hidden
    }

    .pricing-comparison-white {
        background: #fff
    }

    .pricing-comparison-gray {
        background: linear-gradient(to bottom, #f8fafc, #fff)
    }

    .dark .pricing-comparison-white {
        background: var(--color-bg-secondary)
    }

    .dark .pricing-comparison-gray {
        background: linear-gradient(to bottom, var(--color-bg-primary), var(--color-bg-secondary))
    }

    .pricing-comparison-bg {
        position: absolute;
        inset: 0;
        background-image: radial-gradient(circle at 2px 2px, var(--color-gray-200) 1px, transparent 0);
        background-size: 32px 32px;
        opacity: .3;
        pointer-events: none
    }

    .dark .pricing-comparison-bg {
        background-image: radial-gradient(circle at 2px 2px, var(--color-gray-800) 1px, transparent 0);
        opacity: .2
    }

    .pricing-comparison-badge {
        display: inline-block;
        padding: .5rem 1.25rem;
        background: var(--color-primary-50);
        color: var(--color-primary-600);
        font-size: .875rem;
        font-weight: 600;
        border-radius: 9999px;
        margin-bottom: 1rem
    }

    .dark .pricing-comparison-badge {
        background: rgba(var(--color-primary-rgb, 37, 99, 235), .15);
        color: var(--color-primary-400)
    }

    .pricing-comparison-title {
        font-family: var(--font-heading);
        font-size: 2.5rem;
        font-weight: 800;
        color: var(--color-gray-900);
        margin-bottom: 1rem
    }

    .dark .pricing-comparison-title {
        color: var(--color-text-primary)
    }

    .pricing-comparison-subtitle {
        font-size: 1.125rem;
        color: var(--color-gray-600)
    }

    .dark .pricing-comparison-subtitle {
        color: var(--color-text-tertiary)
    }

    .pricing-comparison-table-container {
        overflow-x: auto;
        background: white;
        border-radius: 1rem;
        box-shadow: 0 10px 40px -10px rgba(0, 0, 0, .1)
    }

    .dark .pricing-comparison-table-container {
        background: var(--color-card-bg);
        box-shadow: 0 10px 40px -10px rgba(0, 0, 0, .4)
    }

    .pricing-comparison-table {
        width: 100%;
        border-collapse: separate;
        border-spacing: 0
    }

    .pricing-comparison-th-feature {
        position: sticky;
        left: 0;
        background: white;
        padding: 2rem 1.5rem;
        text-align: left;
        font-family: var(--font-heading);
        font-size: 1rem;
        font-weight: 700;
        color: var(--color-gray-900);
        border-bottom: 2px solid var(--color-gray-200);
        z-index: 10
    }

    .dark .pricing-comparison-th-feature {
        background: var(--color-card-bg);
        color: var(--color-text-primary);
        border-bottom-color: var(--color-border)
    }

    .pricing-comparison-th-plan {
        position: relative;
        padding: 3rem 1.5rem 2rem;
        text-align: center;
        border-bottom: 2px solid var(--color-gray-200);
        background: var(--color-gray-50)
    }

    .dark .pricing-comparison-th-plan {
        background: var(--color-bg-tertiary);
        border-bottom-color: var(--color-border)
    }

    .pricing-comparison-th-plan.pricing-comparison-popular {
        background: linear-gradient(135deg, var(--color-primary-500), var(--color-secondary-500));
        color: white
    }

    .pricing-comparison-popular-tag {
        position: absolute;
        top: 0.75rem;
        left: 50%;
        transform: translateX(-50%);
        padding: .375rem 1rem;
        background: var(--color-secondary-600);
        color: white;
        font-size: .75rem;
        font-weight: 700;
        border-radius: 9999px;
        white-space: nowrap;
        text-transform: uppercase;
        letter-spacing: .5px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, .15)
    }

    .dark .pricing-comparison-popular-tag {
        background: var(--color-secondary-500)
    }

    .pricing-comparison-plan-name {
        font-family: var(--font-heading);
        font-size: 1.25rem;
        font-weight: 700;
        margin-bottom: .5rem;
        color: var(--color-gray-900)
    }

    .pricing-comparison-th-plan.pricing-comparison-popular .pricing-comparison-plan-name {
        color: white
    }

    .dark .pricing-comparison-plan-name {
        color: var(--color-text-primary)
    }

    .pricing-comparison-price {
        font-family: var(--font-heading);
        font-size: 2.5rem;
        font-weight: 800;
        color: var(--color-gray-900);
        line-height: 1
    }

    .pricing-comparison-th-plan.pricing-comparison-popular .pricing-comparison-price {
        color: white
    }

    .dark .pricing-comparison-price {
        color: var(--color-text-primary)
    }

    .pricing-comparison-period {
        font-size: .875rem;
        color: var(--color-gray-600);
        margin-bottom: 1.5rem
    }

    .pricing-comparison-th-plan.pricing-comparison-popular .pricing-comparison-period {
        color: rgba(255, 255, 255, .8)
    }

    .dark .pricing-comparison-period {
        color: var(--color-text-tertiary)
    }

    .pricing-comparison-btn {
        display: inline-block;
        padding: .75rem 2rem;
        background: var(--color-primary-600);
        color: white;
        font-weight: 600;
        border-radius: .5rem;
        transition: all .3s ease
    }

    .pricing-comparison-th-plan.pricing-comparison-popular .pricing-comparison-btn {
        background: white;
        color: var(--color-primary-600)
    }

    .pricing-comparison-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 10px 25px -5px rgba(0, 0, 0, .2)
    }

    .pricing-comparison-row {
        transition: background .2s ease
    }

    .pricing-comparison-row:hover {
        background: var(--color-gray-50)
    }

    .dark .pricing-comparison-row:hover {
        background: var(--color-bg-tertiary)
    }

    .pricing-comparison-feature-name {
        position: sticky;
        left: 0;
        background: white;
        padding: 1.25rem 1.5rem;
        font-size: .9375rem;
        color: var(--color-gray-700);
        border-bottom: 1px solid var(--color-gray-100)
    }

    .dark .pricing-comparison-feature-name {
        background: var(--color-card-bg);
        color: var(--color-text-secondary);
        border-bottom-color: var(--color-border)
    }

    .pricing-comparison-cell {
        padding: 1.25rem 1.5rem;
        text-align: center;
        border-bottom: 1px solid var(--color-gray-100)
    }

    .dark .pricing-comparison-cell {
        border-bottom-color: var(--color-border)
    }

    .pricing-comparison-check {
        width: 1.5rem;
        height: 1.5rem;
        color: var(--color-primary-600)
    }

    .dark .pricing-comparison-check {
        color: var(--color-primary-400)
    }

    .pricing-comparison-minus {
        width: 1.5rem;
        height: 1.5rem;
        color: var(--color-gray-400)
    }

    .dark .pricing-comparison-minus {
        color: var(--color-gray-600)
    }

    [dir=rtl] .pricing-comparison-section {
        direction: rtl
    }

    [dir=rtl] .pricing-comparison-th-feature {
        text-align: right
    }

    @media (max-width:768px) {
        .pricing-comparison-section {
            padding: 4rem 0
        }

        .pricing-comparison-title {
            font-size: 2rem
        }

        .pricing-comparison-th-plan {
            padding: 2.5rem 1rem 1.5rem
        }

        .pricing-comparison-price {
            font-size: 2rem
        }
    }
</style>
</div>
