<?php
use Livewire\Component;
new class extends Component {
    public array $section = [];
    public array $items = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(array $section = [], array $items = [], array $company = [], array $social = [], array $services = [], bool $isWhiteBackground = false, ?int $paddingTop = null, ?int $paddingBottom = null)
    {
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        $this->items = !empty($items)
            ? $items
            : [
                ['name' => 'Basic', 'price' => '29', 'period' => 'per month', 'description' => 'Perfect for individuals', 'features' => [['icon' => 'lucide:scale', 'text' => '15 lbs of laundry', 'is_included' => true], ['icon' => 'lucide:sparkles', 'text' => 'Wash & fold service', 'is_included' => true], ['icon' => 'lucide:truck', 'text' => 'Free pickup & delivery', 'is_included' => true], ['icon' => 'lucide:clock', 'text' => '48-hour turnaround', 'is_included' => true], ['icon' => 'lucide:leaf', 'text' => 'Premium eco detergents', 'is_included' => false]], 'popular' => false],
                ['name' => 'Family', 'price' => '79', 'period' => 'per month', 'description' => 'Best for families', 'features' => [['icon' => 'lucide:scale', 'text' => '50 lbs of laundry', 'is_included' => true], ['icon' => 'lucide:sparkles', 'text' => 'Wash, fold & iron', 'is_included' => true], ['icon' => 'lucide:truck', 'text' => 'Free pickup & delivery', 'is_included' => true], ['icon' => 'lucide:clock', 'text' => '24-hour turnaround', 'is_included' => true], ['icon' => 'lucide:leaf', 'text' => 'Premium eco detergents', 'is_included' => true]], 'popular' => true],
                ['name' => 'Business', 'price' => '199', 'period' => 'per month', 'description' => 'For businesses & hotels', 'features' => [['icon' => 'lucide:infinity', 'text' => 'Unlimited laundry', 'is_included' => true], ['icon' => 'lucide:badge-check', 'text' => 'All services included', 'is_included' => true], ['icon' => 'lucide:zap', 'text' => 'Same-day turnaround', 'is_included' => true], ['icon' => 'lucide:user-circle', 'text' => 'Dedicated account manager', 'is_included' => true], ['icon' => 'lucide:phone', 'text' => 'Priority support', 'is_included' => true]], 'popular' => false],
            ];

        $this->section = array_merge(['badge' => 'Pricing Plans', 'title' => 'Creative Pricing Options', 'subtitle' => 'Choose the plan that fits your needs perfectly', 'currency_symbol' => '$', 'popular_badge' => 'Most Popular', 'cta_button' => 'Get Started', 'cta_button_url' => '#contact'], $section);
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>
<section class="pricing-creative-section {{ $isWhiteBackground ? 'pricing-creative-white' : 'pricing-creative-gray' }}"
    @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    <div class="pricing-creative-bg">
        <svg class="pricing-creative-blob pricing-creative-blob-1" viewBox="0 0 200 200"
            xmlns="http://www.w3.org/2000/svg">
            <path
                d="M47.1,-57.8C59.9,-49.1,68.4,-33.3,71.8,-16.2C75.2,0.9,73.5,19.3,65.3,34.2C57.1,49.1,42.4,60.5,26.2,65.4C10,70.3,-7.7,68.7,-24.3,63.4C-40.9,58.1,-56.4,49.1,-65.7,35.5C-75,21.9,-78.1,3.7,-74.8,-12.9C-71.5,-29.5,-61.8,-44.5,-48.5,-53.1C-35.2,-61.7,-17.6,-63.9,-0.3,-63.5C17,-63.1,34.3,-66.5,47.1,-57.8Z"
                transform="translate(100 100)" />
        </svg>
        <svg class="pricing-creative-blob pricing-creative-blob-2" viewBox="0 0 200 200"
            xmlns="http://www.w3.org/2000/svg">
            <path
                d="M41.3,-54.7C51.6,-44.3,56.5,-28.9,60.4,-12.4C64.3,4.1,67.2,21.6,61.1,35.4C55,49.2,39.9,59.3,23.8,64.8C7.7,70.3,-9.4,71.2,-25.3,66.8C-41.2,62.4,-55.9,52.7,-64.3,38.8C-72.7,24.9,-74.8,6.8,-71.3,-10.1C-67.8,-27,-58.7,-42.7,-45.9,-52.8C-33.1,-62.9,-16.6,-67.4,-0.4,-66.9C15.8,-66.4,31.1,-65.1,41.3,-54.7Z"
                transform="translate(100 100)" />
        </svg>
        <div class="pricing-creative-circle pricing-creative-circle-1"></div>
        <div class="pricing-creative-circle pricing-creative-circle-2"></div>
    </div>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative">
        <div class="text-center mb-12">
            <span class="pricing-creative-badge">{{ $section['badge'] }}</span>
            <h2 class="pricing-creative-title">{{ $section['title'] }}</h2>
            <p class="pricing-creative-subtitle">{{ $section['subtitle'] }}</p>
        </div>
        <div class="pricing-creative-grid">
            @foreach ($items as $index => $plan)
                <div class="pricing-creative-card {{ $plan['popular'] ? 'pricing-creative-card-popular' : '' }}"
                    style="--card-index: {{ $index }}">
                    <div class="pricing-creative-shape-bg"></div>
                    @if ($plan['popular'])
                        <div class="pricing-creative-popular-star">
                            <x-icon icon="lucide:star" class="w-5 h-5" />
                        </div>
                    @endif
                    <div class="pricing-creative-card-inner">
                        <div class="pricing-creative-header">
                            <div class="pricing-creative-icon-shape">
                                <div class="pricing-creative-icon-wrapper">
                                    <x-icon
                                        icon="{{ $index === 0 ? 'lucide:zap' : ($index === 1 ? 'lucide:rocket' : 'lucide:crown') }}"
                                        class="w-7 h-7" />
                                </div>
                            </div>
                            <h3 class="pricing-creative-name">{{ $plan['name'] }}</h3>
                            <p class="pricing-creative-desc">{{ $plan['description'] }}</p>
                        </div>
                        <div class="pricing-creative-price-section">
                            <div class="pricing-creative-price-line">
                                <span class="pricing-creative-currency">{{ $section['currency_symbol'] }}</span>
                                <span class="pricing-creative-price">{{ $plan['price'] }}</span>
                            </div>
                            <span class="pricing-creative-period">{{ $plan['period'] }}</span>
                        </div>
                        <div class="pricing-creative-wave-divider">
                            <svg viewBox="0 0 200 20" preserveAspectRatio="none">
                                <path d="M0,10 Q50,0 100,10 T200,10 L200,20 L0,20 Z" />
                            </svg>
                        </div>
                        <ul class="pricing-creative-features">
                            @foreach ($plan['features'] as $feature)
                                <li
                                    class="pricing-creative-feature {{ $feature['is_included'] ? '' : 'pricing-creative-feature-not-included' }}">
                                    <div class="pricing-creative-feature-icon-wrapper">
                                        <x-icon icon="{{ $feature['icon'] ?? 'lucide:check' }}" class="pricing-creative-feature-icon" />
                                    </div>
                                    <span>{{ $feature['text'] }}</span>
                                </li>
                            @endforeach
                        </ul>
                        <a href="{{ $section['cta_button_url'] ?? '#contact' }}" class="pricing-creative-btn">
                            <span>{{ $section['cta_button'] }}</span>
                            <x-icon icon="lucide:arrow-right" class="pricing-creative-arrow" />
                        </a>
                    </div>
                    <div class="pricing-creative-corner-shapes">
                        <div class="pricing-creative-corner pricing-creative-corner-tl"></div>
                        <div class="pricing-creative-corner pricing-creative-corner-br"></div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>
<style>
        .pricing-creative-section {
            position: relative;
            padding: 6rem 0;
            overflow: hidden
        }

        .pricing-creative-white {
            background: #fff
        }

        .pricing-creative-gray {
            background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 50%, #e2e8f0 100%)
        }

        .dark .pricing-creative-white {
            background: var(--color-bg-secondary)
        }

        .dark .pricing-creative-gray {
            background: linear-gradient(135deg, var(--color-bg-secondary) 0%, var(--color-bg-primary) 50%, var(--color-bg-secondary) 100%)
        }

        .pricing-creative-bg {
            position: absolute;
            inset: 0;
            pointer-events: none;
            overflow: hidden
        }

        .pricing-creative-blob {
            position: absolute;
            width: 400px;
            height: 400px;
            opacity: .08;
            animation: pricing-creative-float 20s ease-in-out infinite
        }

        .pricing-creative-blob-1 {
            top: -100px;
            left: 5%;
            fill: var(--color-primary-500);
            animation-delay: 0s
        }

        .pricing-creative-blob-2 {
            bottom: -150px;
            right: 10%;
            fill: var(--color-secondary-500);
            animation-delay: -10s
        }

        .dark .pricing-creative-blob {
            opacity: .05
        }

        @keyframes pricing-creative-float {

            0%,
            100% {
                transform: translate(0, 0) rotate(0deg)
            }

            25% {
                transform: translate(30px, -30px) rotate(5deg)
            }

            50% {
                transform: translate(0, -50px) rotate(-5deg)
            }

            75% {
                transform: translate(-30px, -30px) rotate(5deg)
            }
        }

        .pricing-creative-circle {
            position: absolute;
            border-radius: 50%;
            border: 2px solid var(--color-primary-300);
            opacity: .15
        }

        .pricing-creative-circle-1 {
            width: 300px;
            height: 300px;
            top: 10%;
            right: 15%;
            animation: pricing-creative-pulse 8s ease-in-out infinite
        }

        .pricing-creative-circle-2 {
            width: 200px;
            height: 200px;
            bottom: 20%;
            left: 10%;
            animation: pricing-creative-pulse 8s ease-in-out infinite;
            animation-delay: 4s
        }

        .dark .pricing-creative-circle {
            border-color: var(--color-primary-800)
        }

        @keyframes pricing-creative-pulse {

            0%,
            100% {
                transform: scale(1);
                opacity: .15
            }

            50% {
                transform: scale(1.1);
                opacity: .25
            }
        }

        .pricing-creative-badge {
            display: inline-block;
            padding: .5rem 1.5rem;
            background: linear-gradient(135deg, var(--color-primary-500), var(--color-secondary-500));
            color: white;
            font-size: .875rem;
            font-weight: 700;
            border-radius: 9999px;
            margin-bottom: 1rem;
            letter-spacing: .5px;
            box-shadow: 0 4px 12px rgba(var(--color-primary-rgb, 37, 99, 235), .3)
        }

        .pricing-creative-title {
            font-family: var(--font-heading);
            font-size: 2.75rem;
            font-weight: 800;
            color: var(--color-gray-900);
            margin-bottom: 1rem
        }

        .dark .pricing-creative-title {
            color: var(--color-text-primary)
        }

        .pricing-creative-subtitle {
            font-size: 1.125rem;
            color: var(--color-gray-600)
        }

        .dark .pricing-creative-subtitle {
            color: var(--color-text-tertiary)
        }

        .pricing-creative-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 2.5rem;
            margin-top: 3rem
        }

        .pricing-creative-card {
            position: relative;
            animation: pricing-creative-slide-up .6s ease-out forwards;
            animation-delay: calc(var(--card-index) * 100ms);
            opacity: 0
        }

        @keyframes pricing-creative-slide-up {
            to {
                opacity: 1;
                transform: translateY(0)
            }
        }

        .pricing-creative-card-inner {
            position: relative;
            background: white;
            border-radius: 2rem;
            padding: 2.5rem;
            transition: all .4s cubic-bezier(.4, 0, .2, 1);
            overflow: hidden;
            z-index: 1
        }

        .pricing-creative-card:hover .pricing-creative-card-inner {
            transform: translateY(-8px);
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, .15)
        }

        .dark .pricing-creative-card-inner {
            background: var(--color-card-bg)
        }

        .dark .pricing-creative-card:hover .pricing-creative-card-inner {
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, .5)
        }

        .pricing-creative-shape-bg {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 200px;
            background: linear-gradient(135deg, var(--color-primary-100), var(--color-secondary-100));
            clip-path: polygon(0 0, 100% 0, 100% 70%, 0 100%);
            opacity: .3;
            transition: all .4s ease
        }

        .pricing-creative-card:hover .pricing-creative-shape-bg {
            clip-path: polygon(0 0, 100% 0, 100% 80%, 0 90%);
            opacity: .5
        }

        .dark .pricing-creative-shape-bg {
            background: linear-gradient(135deg, var(--color-primary-900), var(--color-secondary-900));
            opacity: .2
        }

        .pricing-creative-card-popular .pricing-creative-shape-bg {
            background: linear-gradient(135deg, var(--color-primary-500), var(--color-secondary-500));
            opacity: .15
        }

        .dark .pricing-creative-card-popular .pricing-creative-shape-bg {
            opacity: .1
        }

        .pricing-creative-popular-star {
            position: absolute;
            top: 1.5rem;
            right: 1.5rem;
            width: 3rem;
            height: 3rem;
            display: flex;
            align-items: center;
            justify-content: center;
            background: linear-gradient(135deg, var(--color-secondary-500), var(--color-primary-500));
            color: white;
            border-radius: 50%;
            z-index: 2;
            animation: pricing-creative-star-spin 20s linear infinite;
            box-shadow: 0 4px 12px rgba(var(--color-primary-rgb, 37, 99, 235), .4)
        }

        @keyframes pricing-creative-star-spin {
            to {
                transform: rotate(360deg)
            }
        }

        .pricing-creative-header {
            margin-bottom: 2rem;
            text-align: center
        }

        .pricing-creative-icon-shape {
            position: relative;
            display: inline-flex;
            margin-bottom: 1.5rem
        }

        .pricing-creative-icon-wrapper {
            width: 4rem;
            height: 4rem;
            display: flex;
            align-items: center;
            justify-content: center;
            background: linear-gradient(135deg, var(--color-primary-500), var(--color-secondary-500));
            color: white;
            clip-path: polygon(50% 0%, 100% 38%, 82% 100%, 18% 100%, 0% 38%);
            transition: all .4s ease
        }

        .pricing-creative-card:hover .pricing-creative-icon-wrapper {
            transform: scale(1.1) rotate(72deg);
            clip-path: polygon(50% 0%, 61% 35%, 98% 35%, 68% 57%, 79% 91%, 50% 70%, 21% 91%, 32% 57%, 2% 35%, 39% 35%)
        }

        .pricing-creative-name {
            font-family: var(--font-heading);
            font-size: 1.75rem;
            font-weight: 700;
            color: var(--color-gray-900);
            margin-bottom: .5rem
        }

        .dark .pricing-creative-name {
            color: var(--color-text-primary)
        }

        .pricing-creative-desc {
            font-size: .9375rem;
            color: var(--color-gray-600)
        }

        .dark .pricing-creative-desc {
            color: var(--color-text-tertiary)
        }

        .pricing-creative-price-section {
            text-align: center;
            margin-bottom: 1.5rem
        }

        .pricing-creative-price-line {
            display: flex;
            align-items: baseline;
            justify-content: center;
            gap: .25rem;
            margin-bottom: .5rem
        }

        .pricing-creative-currency {
            font-family: var(--font-heading);
            font-size: 1.5rem;
            font-weight: 700;
            color: var(--color-gray-700)
        }

        .dark .pricing-creative-currency {
            color: var(--color-text-secondary)
        }

        .pricing-creative-price {
            font-family: var(--font-heading);
            font-size: 3.5rem;
            font-weight: 800;
            color: var(--color-gray-900);
            line-height: 1;
            letter-spacing: -2px
        }

        .dark .pricing-creative-price {
            color: var(--color-text-primary)
        }

        .pricing-creative-period {
            font-size: .875rem;
            color: var(--color-gray-600)
        }

        .dark .pricing-creative-period {
            color: var(--color-text-tertiary)
        }

        .pricing-creative-wave-divider {
            position: relative;
            height: 20px;
            margin: 0 -2.5rem 2rem;
            overflow: hidden
        }

        .pricing-creative-wave-divider svg {
            width: 100%;
            height: 100%;
            fill: var(--color-primary-200)
        }

        .dark .pricing-creative-wave-divider svg {
            fill: var(--color-primary-900);
            opacity: .3
        }

        .pricing-creative-features {
            list-style: none;
            padding: 0;
            margin: 0 0 2rem 0
        }

        .pricing-creative-feature {
            display: flex;
            align-items: flex-start;
            gap: .75rem;
            padding: .625rem 0;
            font-size: .9375rem;
            color: var(--color-gray-700)
        }

        .dark .pricing-creative-feature {
            color: var(--color-text-secondary)
        }

        .pricing-creative-feature-not-included {
            color: var(--color-gray-400);
            opacity: .5
        }

        .dark .pricing-creative-feature-not-included {
            color: var(--color-text-quaternary)
        }

        .pricing-creative-feature-icon-wrapper {
            width: 1.25rem;
            height: 1.25rem;
            flex-shrink: 0;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-top: .125rem;
            position: relative
        }

        .pricing-creative-feature-icon {
            width: .875rem;
            height: .875rem;
            color: var(--color-primary-600);
            z-index: 1
        }

        .dark .pricing-creative-feature-icon {
            color: var(--color-primary-400)
        }

        .pricing-creative-feature-not-included .pricing-creative-feature-icon {
            color: var(--color-gray-400)
        }

        .dark .pricing-creative-feature-not-included .pricing-creative-feature-icon {
            color: var(--color-gray-600)
        }

        .pricing-creative-btn {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: .5rem;
            width: 100%;
            padding: 1rem 1.5rem;
            background: linear-gradient(135deg, var(--color-primary-600), var(--color-secondary-600));
            color: white;
            font-weight: 600;
            border-radius: 1rem;
            transition: all .3s ease;
            box-shadow: 0 4px 12px rgba(var(--color-primary-rgb, 37, 99, 235), .3)
        }

        .pricing-creative-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(var(--color-primary-rgb, 37, 99, 235), .4)
        }

        .pricing-creative-btn:hover .pricing-creative-arrow {
            transform: translateX(4px)
        }

        .pricing-creative-arrow {
            width: 1.25rem;
            height: 1.25rem;
            transition: transform .3s ease
        }

        .pricing-creative-corner-shapes {
            position: absolute;
            inset: 0;
            pointer-events: none;
            border-radius: 2rem;
            overflow: hidden
        }

        .pricing-creative-corner {
            position: absolute;
            width: 80px;
            height: 80px;
            opacity: .1;
            transition: all .4s ease
        }

        .pricing-creative-corner-tl {
            top: 0;
            left: 0;
            background: linear-gradient(135deg, var(--color-primary-500), transparent);
            clip-path: polygon(0 0, 100% 0, 0 100%)
        }

        .pricing-creative-corner-br {
            bottom: 0;
            right: 0;
            background: linear-gradient(-45deg, var(--color-secondary-500), transparent);
            clip-path: polygon(100% 0, 100% 100%, 0 100%)
        }

        .pricing-creative-card:hover .pricing-creative-corner {
            opacity: .2;
            transform: scale(1.2)
        }

        [dir=rtl] .pricing-creative-section {
            direction: rtl
        }

        [dir=rtl] .pricing-creative-blob-1 {
            left: auto;
            right: 5%
        }

        [dir=rtl] .pricing-creative-blob-2 {
            right: auto;
            left: 10%
        }

        [dir=rtl] .pricing-creative-circle-1 {
            right: auto;
            left: 15%
        }

        [dir=rtl] .pricing-creative-circle-2 {
            left: auto;
            right: 10%
        }

        [dir=rtl] .pricing-creative-popular-star {
            right: auto;
            left: 1.5rem
        }

        [dir=rtl] .pricing-creative-corner-tl {
            left: auto;
            right: 0
        }

        [dir=rtl] .pricing-creative-corner-br {
            right: auto;
            left: 0
        }

        [dir=rtl] .pricing-creative-btn:hover .pricing-creative-arrow {
            transform: translateX(-4px)
        }

        @media (max-width:768px) {
            .pricing-creative-section {
                padding: 4rem 0
            }

            .pricing-creative-title {
                font-size: 2rem
            }

            .pricing-creative-grid {
                grid-template-columns: 1fr;
                gap: 2rem
            }

            .pricing-creative-card-inner {
                padding: 2rem
            }

            .pricing-creative-price {
                font-size: 2.75rem
            }
        }
    </style>
</div>
