<?php
use Livewire\Component;
new class extends Component {
    public array $section = [];
    public array $items = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(array $section = [], array $items = [], array $company = [], array $social = [], array $services = [], bool $isWhiteBackground = false, ?int $paddingTop = null, ?int $paddingBottom = null) {
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        $this->items = !empty($items) ? $items : [
            ['name' => 'Basic', 'price' => '29', 'period' => 'per month', 'description' => 'Perfect for individuals', 'features' => [['icon' => 'lucide:scale', 'text' => '15 lbs of laundry', 'is_included' => true], ['icon' => 'lucide:sparkles', 'text' => 'Wash & fold service', 'is_included' => true], ['icon' => 'lucide:truck', 'text' => 'Free pickup & delivery', 'is_included' => true], ['icon' => 'lucide:clock', 'text' => '48-hour turnaround', 'is_included' => true], ['icon' => 'lucide:leaf', 'text' => 'Premium eco detergents', 'is_included' => false]], 'popular' => false],
            ['name' => 'Family', 'price' => '79', 'period' => 'per month', 'description' => 'Best for families', 'features' => [['icon' => 'lucide:scale', 'text' => '50 lbs of laundry', 'is_included' => true], ['icon' => 'lucide:sparkles', 'text' => 'Wash, fold & iron', 'is_included' => true], ['icon' => 'lucide:truck', 'text' => 'Free pickup & delivery', 'is_included' => true], ['icon' => 'lucide:clock', 'text' => '24-hour turnaround', 'is_included' => true], ['icon' => 'lucide:leaf', 'text' => 'Premium eco detergents', 'is_included' => true]], 'popular' => true],
            ['name' => 'Business', 'price' => '199', 'period' => 'per month', 'description' => 'For businesses & hotels', 'features' => [['icon' => 'lucide:infinity', 'text' => 'Unlimited laundry', 'is_included' => true], ['icon' => 'lucide:badge-check', 'text' => 'All services included', 'is_included' => true], ['icon' => 'lucide:zap', 'text' => 'Same-day turnaround', 'is_included' => true], ['icon' => 'lucide:user-circle', 'text' => 'Dedicated account manager', 'is_included' => true], ['icon' => 'lucide:phone', 'text' => 'Priority support', 'is_included' => true]], 'popular' => false],
        ];

        $this->section = array_merge(['badge' => 'Pricing Plans', 'title' => 'Choose Your Plan', 'subtitle' => 'Select the perfect plan for your needs', 'currency_symbol' => '$', 'popular_badge' => 'Most Popular', 'cta_button' => 'Get Started', 'cta_button_url' => '#contact'], $section);
    }

    public function getCustomPaddingStyle(): string {
        $styles = [];
        if ($this->paddingTop !== null) $styles[] = "padding-top: {$this->paddingTop}px";
        if ($this->paddingBottom !== null) $styles[] = "padding-bottom: {$this->paddingBottom}px";
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>
<section class="pricing-gradient-section {{ $isWhiteBackground ? 'pricing-gradient-white' : 'pricing-gradient-gray' }}" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    <div class="pricing-gradient-bg-shapes">
        <div class="pricing-gradient-shape pricing-gradient-shape-1"></div>
        <div class="pricing-gradient-shape pricing-gradient-shape-2"></div>
    </div>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative">
        <div class="text-center mb-12">
            <span class="pricing-gradient-badge">{{ $section['badge'] }}</span>
            <h2 class="pricing-gradient-title">{{ $section['title'] }}</h2>
            <p class="pricing-gradient-subtitle">{{ $section['subtitle'] }}</p>
        </div>
        <div class="pricing-gradient-grid">
            @foreach ($items as $index => $plan)
                <div class="pricing-gradient-card {{ $plan['popular'] ? 'pricing-gradient-card-popular' : '' }}" style="animation-delay: {{ $index * 100 }}ms">
                    @if ($plan['popular'])
                        <div class="pricing-gradient-popular-ribbon">{{ $section['popular_badge'] }}</div>
                    @endif
                    <div class="pricing-gradient-card-header">
                        <h3 class="pricing-gradient-plan-name">{{ $plan['name'] }}</h3>
                        <p class="pricing-gradient-plan-desc">{{ $plan['description'] }}</p>
                    </div>
                    <div class="pricing-gradient-price-container">
                        <div class="pricing-gradient-price-wrapper">
                            <span class="pricing-gradient-currency">{{ $section['currency_symbol'] }}</span>
                            <span class="pricing-gradient-amount">{{ $plan['price'] }}</span>
                        </div>
                        <span class="pricing-gradient-period">/{{ $plan['period'] }}</span>
                    </div>
                    <ul class="pricing-gradient-features">
                        @foreach ($plan['features'] as $feature)
                            <li class="pricing-gradient-feature {{ $feature['is_included'] ? 'pricing-gradient-feature-included' : 'pricing-gradient-feature-excluded' }}">
                                <x-icon icon="{{ $feature['icon'] ?? 'lucide:check' }}" class="pricing-gradient-feature-icon" />
                                <span>{{ $feature['text'] }}</span>
                            </li>
                        @endforeach
                    </ul>
                    <a href="{{ $section['cta_button_url'] ?? '#contact' }}" class="pricing-gradient-btn">{{ $section['cta_button'] }}</a>
                </div>
            @endforeach
        </div>
    </div>
</section>
<style>
.pricing-gradient-section{position:relative;padding:6rem 0;overflow:hidden}.pricing-gradient-white{background:#fff}.pricing-gradient-gray{background:linear-gradient(to bottom,#f8fafc,#e2e8f0)}.dark .pricing-gradient-white{background:var(--color-bg-secondary)}.dark .pricing-gradient-gray{background:linear-gradient(to bottom,var(--color-bg-primary),var(--color-bg-secondary))}.pricing-gradient-bg-shapes{position:absolute;inset:0;pointer-events:none;overflow:hidden}.pricing-gradient-shape{position:absolute;border-radius:50%;filter:blur(100px);opacity:.2}.pricing-gradient-shape-1{width:500px;height:500px;background:linear-gradient(135deg,var(--color-primary-400),var(--color-secondary-400));top:-100px;right:10%}.pricing-gradient-shape-2{width:400px;height:400px;background:linear-gradient(-45deg,var(--color-primary-500),var(--color-secondary-500));bottom:-50px;left:5%}.dark .pricing-gradient-shape{opacity:.1}.pricing-gradient-badge{display:inline-block;padding:.5rem 1.25rem;background:var(--color-primary-50);color:var(--color-primary-600);font-size:.875rem;font-weight:600;border-radius:9999px;margin-bottom:1rem}.dark .pricing-gradient-badge{background:rgba(var(--color-primary-rgb,37,99,235),.15);color:var(--color-primary-400)}.pricing-gradient-title{font-family:var(--font-heading);font-size:2.5rem;font-weight:800;color:var(--color-gray-900);margin-bottom:1rem}.dark .pricing-gradient-title{color:var(--color-text-primary)}.pricing-gradient-subtitle{font-size:1.125rem;color:var(--color-gray-600);margin-bottom:2rem}.dark .pricing-gradient-subtitle{color:var(--color-text-tertiary)}.pricing-gradient-grid{display:grid;grid-template-columns:repeat(auto-fit,minmax(300px,1fr));gap:2rem;margin-top:3rem}.pricing-gradient-card{position:relative;background:white;border:2px solid var(--color-gray-200);border-radius:1.5rem;padding:2.5rem;transition:all .4s cubic-bezier(.4,0,.2,1);animation:pricing-gradient-fade-in .6s ease-out forwards;opacity:0}.pricing-gradient-card:hover{transform:translateY(-10px);border-color:var(--color-primary-500);box-shadow:0 20px 60px -10px rgba(0,0,0,.15)}.dark .pricing-gradient-card{background:var(--color-card-bg);border-color:var(--color-border)}.dark .pricing-gradient-card:hover{border-color:var(--color-primary-500);box-shadow:0 20px 60px -10px rgba(0,0,0,.5)}@keyframes pricing-gradient-fade-in{to{opacity:1;transform:translateY(0)}}.pricing-gradient-card-popular{border-color:var(--color-primary-500);box-shadow:0 15px 50px -10px rgba(var(--color-primary-rgb,37,99,235),.3)}.pricing-gradient-card-popular::before{content:'';position:absolute;top:-2px;left:-2px;right:-2px;bottom:-2px;background:linear-gradient(135deg,var(--color-primary-500),var(--color-secondary-500));border-radius:1.5rem;z-index:-1;opacity:.1}.pricing-gradient-popular-ribbon{position:absolute;top:1.5rem;right:-0.5rem;background:linear-gradient(135deg,var(--color-primary-600),var(--color-secondary-600));color:white;padding:.5rem 1.5rem;font-size:.875rem;font-weight:700;border-radius:.5rem 0 0 .5rem;box-shadow:-4px 4px 12px rgba(0,0,0,.15)}.pricing-gradient-popular-ribbon::after{content:'';position:absolute;right:0;bottom:-8px;width:0;height:0;border-style:solid;border-width:0 8px 8px 0;border-color:transparent var(--color-primary-800) transparent transparent}.dark .pricing-gradient-popular-ribbon::after{border-color:transparent var(--color-primary-900) transparent transparent}.pricing-gradient-card-header{margin-bottom:2rem}.pricing-gradient-plan-name{font-family:var(--font-heading);font-size:1.75rem;font-weight:700;color:var(--color-gray-900);margin-bottom:.5rem}.dark .pricing-gradient-plan-name{color:var(--color-text-primary)}.pricing-gradient-plan-desc{font-size:.9375rem;color:var(--color-gray-600)}.dark .pricing-gradient-plan-desc{color:var(--color-text-tertiary)}.pricing-gradient-price-container{display:flex;align-items:baseline;gap:.5rem;margin-bottom:2rem;padding-bottom:2rem;border-bottom:2px solid var(--color-gray-100)}.dark .pricing-gradient-price-container{border-bottom-color:var(--color-border)}.pricing-gradient-price-wrapper{display:flex;align-items:baseline}.pricing-gradient-currency{font-family:var(--font-heading);font-size:1.5rem;font-weight:700;color:var(--color-gray-700)}.dark .pricing-gradient-currency{color:var(--color-text-secondary)}.pricing-gradient-amount{font-family:var(--font-heading);font-size:3.5rem;font-weight:800;color:var(--color-gray-900);line-height:1}.dark .pricing-gradient-amount{color:var(--color-text-primary)}.pricing-gradient-period{font-size:1rem;color:var(--color-gray-600)}.dark .pricing-gradient-period{color:var(--color-text-tertiary)}.pricing-gradient-features{list-style:none;padding:0;margin:0 0 2rem 0}.pricing-gradient-feature{display:flex;align-items:center;gap:.75rem;padding:.75rem 0;font-size:.9375rem}.pricing-gradient-feature-icon{width:1.25rem;height:1.25rem;flex-shrink:0}.pricing-gradient-feature-included{color:var(--color-gray-700)}.pricing-gradient-feature-included .pricing-gradient-feature-icon{color:var(--color-primary-600)}.dark .pricing-gradient-feature-included{color:var(--color-text-secondary)}.dark .pricing-gradient-feature-included .pricing-gradient-feature-icon{color:var(--color-primary-400)}.pricing-gradient-feature-excluded{color:var(--color-gray-400);opacity:.6}.pricing-gradient-feature-excluded .pricing-gradient-feature-icon{color:var(--color-gray-400)}.dark .pricing-gradient-feature-excluded{color:var(--color-text-quaternary)}.dark .pricing-gradient-feature-excluded .pricing-gradient-feature-icon{color:var(--color-gray-500)}.pricing-gradient-btn{display:block;width:100%;padding:1rem;background:linear-gradient(135deg,var(--color-primary-600),var(--color-secondary-600));color:white;font-weight:600;text-align:center;border-radius:.75rem;transition:all .3s ease;box-shadow:0 4px 12px rgba(var(--color-primary-rgb,37,99,235),.3)}.pricing-gradient-btn:hover{transform:translateY(-2px);box-shadow:0 8px 20px rgba(var(--color-primary-rgb,37,99,235),.4)}.pricing-gradient-card-popular .pricing-gradient-btn{background:linear-gradient(135deg,var(--color-secondary-600),var(--color-primary-600));box-shadow:0 6px 16px rgba(var(--color-primary-rgb,37,99,235),.4)}[dir=rtl] .pricing-gradient-section{direction:rtl}[dir=rtl] .pricing-gradient-popular-ribbon{right:auto;left:-0.5rem;border-radius:0 .5rem .5rem 0}[dir=rtl] .pricing-gradient-popular-ribbon::after{right:auto;left:0;border-width:0 0 8px 8px;border-color:transparent transparent transparent var(--color-primary-800)}[dir=rtl] .dark .pricing-gradient-popular-ribbon::after{border-color:transparent transparent transparent var(--color-primary-900)}[dir=rtl] .pricing-gradient-shape-1{right:auto;left:10%}[dir=rtl] .pricing-gradient-shape-2{left:auto;right:5%}@media (max-width:768px){.pricing-gradient-section{padding:4rem 0}.pricing-gradient-title{font-size:2rem}.pricing-gradient-grid{grid-template-columns:1fr;gap:1.5rem}.pricing-gradient-card{padding:2rem}.pricing-gradient-amount{font-size:2.5rem}}
</style>
</div>
