<?php
use Livewire\Component;
new class extends Component {
    public array $section = [];
    public array $items = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(array $section = [], array $items = [], array $company = [], array $social = [], array $services = [], bool $isWhiteBackground = false, ?int $paddingTop = null, ?int $paddingBottom = null) {
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        $this->items = !empty($items) ? $items : [
            ['name' => 'Basic', 'price' => '29', 'period' => 'per month', 'description' => 'Perfect for individuals', 'features' => [['icon' => 'lucide:scale', 'text' => '15 lbs of laundry', 'is_included' => true], ['icon' => 'lucide:sparkles', 'text' => 'Wash & fold service', 'is_included' => true], ['icon' => 'lucide:truck', 'text' => 'Free pickup & delivery', 'is_included' => true], ['icon' => 'lucide:clock', 'text' => '48-hour turnaround', 'is_included' => true], ['icon' => 'lucide:leaf', 'text' => 'Premium eco detergents', 'is_included' => false]], 'popular' => false],
            ['name' => 'Family', 'price' => '79', 'period' => 'per month', 'description' => 'Best for families', 'features' => [['icon' => 'lucide:scale', 'text' => '50 lbs of laundry', 'is_included' => true], ['icon' => 'lucide:sparkles', 'text' => 'Wash, fold & iron', 'is_included' => true], ['icon' => 'lucide:truck', 'text' => 'Free pickup & delivery', 'is_included' => true], ['icon' => 'lucide:clock', 'text' => '24-hour turnaround', 'is_included' => true], ['icon' => 'lucide:leaf', 'text' => 'Premium eco detergents', 'is_included' => true]], 'popular' => true],
            ['name' => 'Business', 'price' => '199', 'period' => 'per month', 'description' => 'For businesses & hotels', 'features' => [['icon' => 'lucide:infinity', 'text' => 'Unlimited laundry', 'is_included' => true], ['icon' => 'lucide:badge-check', 'text' => 'All services included', 'is_included' => true], ['icon' => 'lucide:zap', 'text' => 'Same-day turnaround', 'is_included' => true], ['icon' => 'lucide:user-circle', 'text' => 'Dedicated account manager', 'is_included' => true], ['icon' => 'lucide:phone', 'text' => 'Priority support', 'is_included' => true]], 'popular' => false],
        ];

        $this->section = array_merge(['badge' => 'Pricing', 'title' => 'Simple Pricing', 'subtitle' => 'No hidden fees. No surprises.', 'currency_symbol' => '$', 'popular_badge' => 'Popular', 'cta_button' => 'Get Started', 'cta_button_url' => '#contact'], $section);
    }

    public function getCustomPaddingStyle(): string {
        $styles = [];
        if ($this->paddingTop !== null) $styles[] = "padding-top: {$this->paddingTop}px";
        if ($this->paddingBottom !== null) $styles[] = "padding-bottom: {$this->paddingBottom}px";
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>
<section class="pricing-minimal-section {{ $isWhiteBackground ? 'pricing-minimal-white' : 'pricing-minimal-gray' }}" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <span class="pricing-minimal-badge">{{ $section['badge'] }}</span>
            <h2 class="pricing-minimal-title">{{ $section['title'] }}</h2>
            <p class="pricing-minimal-subtitle">{{ $section['subtitle'] }}</p>
        </div>
        <div class="pricing-minimal-grid">
            @foreach ($items as $index => $plan)
                <div class="pricing-minimal-card {{ $plan['popular'] ? 'pricing-minimal-card-popular' : '' }}">
                    @if ($plan['popular'])
                        <div class="pricing-minimal-popular-badge">{{ $section['popular_badge'] }}</div>
                    @endif
                    <div class="pricing-minimal-header">
                        <h3 class="pricing-minimal-name">{{ $plan['name'] }}</h3>
                        <p class="pricing-minimal-desc">{{ $plan['description'] }}</p>
                    </div>
                    <div class="pricing-minimal-price-box">
                        <span class="pricing-minimal-currency">{{ $section['currency_symbol'] }}</span>
                        <span class="pricing-minimal-price">{{ $plan['price'] }}</span>
                        <span class="pricing-minimal-period">/{{ $plan['period'] }}</span>
                    </div>
                    <div class="pricing-minimal-divider"></div>
                    <ul class="pricing-minimal-features">
                        @foreach ($plan['features'] as $feature)
                            <li class="pricing-minimal-feature {{ $feature['is_included'] ? '' : 'pricing-minimal-feature-disabled' }}">
                                <div class="pricing-minimal-check">
                                    <x-icon icon="{{ $feature['icon'] ?? 'lucide:check' }}" class="pricing-minimal-check-icon" />
                                </div>
                                <span>{{ $feature['text'] }}</span>
                            </li>
                        @endforeach
                    </ul>
                    <a href="{{ $section['cta_button_url'] ?? '#contact' }}" class="pricing-minimal-btn">{{ $section['cta_button'] }}</a>
                </div>
            @endforeach
        </div>
    </div>
</section>
<style>
.pricing-minimal-section{position:relative;padding:6rem 0}.pricing-minimal-white{background:#fff}.pricing-minimal-gray{background:#fafafa}.dark .pricing-minimal-white{background:var(--color-bg-secondary)}.dark .pricing-minimal-gray{background:var(--color-bg-primary)}.pricing-minimal-badge{display:inline-block;padding:.375rem 1rem;background:transparent;color:var(--color-primary-600);font-size:.875rem;font-weight:600;border:1px solid var(--color-primary-600);border-radius:9999px;margin-bottom:1rem;letter-spacing:.5px}.dark .pricing-minimal-badge{color:var(--color-primary-400);border-color:var(--color-primary-400)}.pricing-minimal-title{font-family:var(--font-heading);font-size:2.75rem;font-weight:700;color:var(--color-gray-900);margin-bottom:1rem;letter-spacing:-1px}.dark .pricing-minimal-title{color:var(--color-text-primary)}.pricing-minimal-subtitle{font-size:1.125rem;color:var(--color-gray-600);font-weight:400}.dark .pricing-minimal-subtitle{color:var(--color-text-tertiary)}.pricing-minimal-grid{display:grid;grid-template-columns:repeat(auto-fit,minmax(280px,1fr));gap:2rem;max-width:1200px;margin:0 auto}.pricing-minimal-card{position:relative;background:white;border:1px solid var(--color-gray-200);border-radius:.5rem;padding:2.5rem 2rem;transition:all .3s ease}.pricing-minimal-card:hover{transform:translateY(-4px);box-shadow:0 12px 24px -8px rgba(0,0,0,.08);border-color:var(--color-gray-300)}.dark .pricing-minimal-card{background:var(--color-card-bg);border-color:var(--color-border)}.dark .pricing-minimal-card:hover{box-shadow:0 12px 24px -8px rgba(0,0,0,.4);border-color:var(--color-gray-700)}.pricing-minimal-card-popular{border-color:var(--color-primary-600);border-width:2px}.pricing-minimal-card-popular:hover{border-color:var(--color-primary-700);box-shadow:0 12px 24px -8px rgba(var(--color-primary-rgb,37,99,235),.2)}.dark .pricing-minimal-card-popular{border-color:var(--color-primary-500)}.dark .pricing-minimal-card-popular:hover{border-color:var(--color-primary-400);box-shadow:0 12px 24px -8px rgba(var(--color-primary-rgb,37,99,235),.3)}.pricing-minimal-popular-badge{position:absolute;top:-12px;left:50%;transform:translateX(-50%);padding:.375rem 1rem;background:var(--color-primary-600);color:white;font-size:.75rem;font-weight:700;letter-spacing:.5px;text-transform:uppercase;border-radius:9999px}.dark .pricing-minimal-popular-badge{background:var(--color-primary-500)}.pricing-minimal-header{margin-bottom:2rem}.pricing-minimal-name{font-family:var(--font-heading);font-size:1.5rem;font-weight:700;color:var(--color-gray-900);margin-bottom:.5rem}.dark .pricing-minimal-name{color:var(--color-text-primary)}.pricing-minimal-desc{font-size:.875rem;color:var(--color-gray-600);font-weight:400}.dark .pricing-minimal-desc{color:var(--color-text-tertiary)}.pricing-minimal-price-box{display:flex;align-items:baseline;gap:.25rem;margin-bottom:2rem}.pricing-minimal-currency{font-family:var(--font-heading);font-size:1.25rem;font-weight:600;color:var(--color-gray-700)}.dark .pricing-minimal-currency{color:var(--color-text-secondary)}.pricing-minimal-price{font-family:var(--font-heading);font-size:3rem;font-weight:700;color:var(--color-gray-900);line-height:1;letter-spacing:-2px}.dark .pricing-minimal-price{color:var(--color-text-primary)}.pricing-minimal-period{font-size:.875rem;color:var(--color-gray-600);font-weight:400}.dark .pricing-minimal-period{color:var(--color-text-tertiary)}.pricing-minimal-divider{height:1px;background:var(--color-gray-200);margin-bottom:2rem}.dark .pricing-minimal-divider{background:var(--color-border)}.pricing-minimal-features{list-style:none;padding:0;margin:0 0 2rem 0}.pricing-minimal-feature{display:flex;align-items:flex-start;gap:.75rem;padding:.5rem 0;font-size:.9375rem;color:var(--color-gray-700)}.dark .pricing-minimal-feature{color:var(--color-text-secondary)}.pricing-minimal-feature-disabled{color:var(--color-gray-400);opacity:.5}.dark .pricing-minimal-feature-disabled{color:var(--color-text-quaternary)}.pricing-minimal-check{width:1.25rem;height:1.25rem;flex-shrink:0;display:flex;align-items:center;justify-content:center;margin-top:.125rem}.pricing-minimal-check-icon{width:1rem;height:1rem;color:var(--color-primary-600)}.pricing-minimal-feature-disabled .pricing-minimal-check-icon{color:var(--color-gray-400)}.dark .pricing-minimal-check-icon{color:var(--color-primary-400)}.dark .pricing-minimal-feature-disabled .pricing-minimal-check-icon{color:var(--color-gray-600)}.pricing-minimal-btn{display:block;width:100%;padding:.875rem 1.5rem;background:var(--color-gray-900);color:white;font-size:.9375rem;font-weight:600;text-align:center;border-radius:.375rem;border:2px solid var(--color-gray-900);transition:all .3s ease}.pricing-minimal-btn:hover{background:white;color:var(--color-gray-900)}.dark .pricing-minimal-btn{background:var(--color-gray-100);color:var(--color-gray-900);border-color:var(--color-gray-100)}.dark .pricing-minimal-btn:hover{background:transparent;color:var(--color-text-primary)}.pricing-minimal-card-popular .pricing-minimal-btn{background:var(--color-primary-600);border-color:var(--color-primary-600)}.pricing-minimal-card-popular .pricing-minimal-btn:hover{background:white;color:var(--color-primary-600)}.dark .pricing-minimal-card-popular .pricing-minimal-btn{background:var(--color-primary-500);border-color:var(--color-primary-500)}.dark .pricing-minimal-card-popular .pricing-minimal-btn:hover{background:transparent;color:var(--color-primary-400)}[dir=rtl] .pricing-minimal-section{direction:rtl}@media (max-width:768px){.pricing-minimal-section{padding:4rem 0}.pricing-minimal-title{font-size:2rem}.pricing-minimal-grid{grid-template-columns:1fr;gap:1.5rem}.pricing-minimal-card{padding:2rem 1.5rem}.pricing-minimal-price{font-size:2.5rem}}
</style>
</div>
