<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(array $section = [], array $company = [], array $social = [], array $services = [], bool $isWhiteBackground = false, ?int $paddingTop = null, ?int $paddingBottom = null)
    {
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        $defaults = [
            'headline' => '50% OFF Your First Order!',
            'description' => 'New customers get 50% off their first laundry order. Use code WELCOME50 at checkout.',
            'promo_code' => 'WELCOME50',
            'show_promo_code' => true,
            'promo_code_label' => 'Use promo code:',
            'copied_message' => 'Copied to clipboard!',
            'cta_text' => 'Claim Offer',
            'cta_url' => '#contact',
            'expiry_date' => '', // Format: 'YYYY-MM-DD HH:MM:SS' or '2026-12-31 23:59:59'
            'show_countdown' => false,
            'countdown_label' => 'Offer ends in:',
            'countdown_days_label' => 'Days',
            'countdown_hours_label' => 'Hrs',
            'countdown_minutes_label' => 'Mins',
            'countdown_seconds_label' => 'Secs',
            'discount_value' => '50%',
            'discount_label' => 'OFF',
            'icon' => 'lucide:gift',
            'terms' => 'Valid for new customers only. Cannot be combined with other offers.',
        ];

        $this->section = array_merge($defaults, $section);
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>

<div>
    <style>
        /* Bold Background Styles */
        .promo-bold-bg {
            background: linear-gradient(135deg,
                    var(--color-primary-600) 0%,
                    var(--color-primary-800) 50%,
                    var(--color-secondary-600) 100%);
        }

        .dark .promo-bold-bg {
            background: linear-gradient(135deg,
                    var(--color-primary-800) 0%,
                    var(--color-primary-950) 50%,
                    var(--color-secondary-900) 100%);
        }

        /* Bold Geometric Shapes */
        .promo-bold-shapes {
            position: absolute;
            inset: 0;
            pointer-events: none;
            overflow: hidden;
        }

        .promo-bold-square {
            position: absolute;
            border: 3px solid rgba(255, 255, 255, 0.1);
            animation: rotate-square 20s linear infinite;
        }

        .dark .promo-bold-square {
            border-color: rgba(255, 255, 255, 0.05);
        }

        .promo-bold-square-1 {
            width: 300px;
            height: 300px;
            top: -100px;
            right: -50px;
            transform: rotate(15deg);
        }

        .promo-bold-square-2 {
            width: 200px;
            height: 200px;
            bottom: -50px;
            left: 10%;
            transform: rotate(-25deg);
            animation-delay: 3s;
        }

        .promo-bold-square-3 {
            width: 150px;
            height: 150px;
            top: 40%;
            left: -30px;
            transform: rotate(45deg);
            animation-delay: 6s;
        }

        @keyframes rotate-square {
            0% {
                transform: rotate(var(--start-rotation, 0deg)) scale(1);
            }

            50% {
                transform: rotate(calc(var(--start-rotation, 0deg) + 180deg)) scale(1.1);
            }

            100% {
                transform: rotate(calc(var(--start-rotation, 0deg) + 360deg)) scale(1);
            }
        }

        .promo-bold-square-1 {
            --start-rotation: 15deg;
        }

        .promo-bold-square-2 {
            --start-rotation: -25deg;
        }

        .promo-bold-square-3 {
            --start-rotation: 45deg;
        }

        .promo-bold-triangle {
            position: absolute;
            width: 0;
            height: 0;
            border-left: 100px solid transparent;
            border-right: 100px solid transparent;
            border-bottom: 173px solid rgba(255, 255, 255, 0.05);
            animation: float-triangle 15s ease-in-out infinite;
        }

        .dark .promo-bold-triangle {
            border-bottom-color: rgba(255, 255, 255, 0.02);
        }

        .promo-bold-triangle-1 {
            top: 20%;
            right: 20%;
        }

        .promo-bold-triangle-2 {
            bottom: 15%;
            right: 40%;
            transform: rotate(180deg);
            animation-delay: 5s;
        }

        @keyframes float-triangle {

            0%,
            100% {
                transform: translateY(0) rotate(0deg);
            }

            50% {
                transform: translateY(-30px) rotate(10deg);
            }
        }

        /* Bold Content Container */
        .promo-bold-content {
            position: relative;
            z-index: 10;
            max-width: 900px;
            margin: 0 auto;
            text-align: center;
        }

        /* Bold Badge */
        .promo-bold-badge {
            display: inline-flex;
            align-items: center;
            gap: 0.75rem;
            padding: 1rem 2rem;
            background: rgba(255, 255, 255, 0.15);
            backdrop-filter: blur(10px);
            border: 2px solid rgba(255, 255, 255, 0.3);
            border-radius: 0.5rem;
            color: white;
            font-size: 1rem;
            font-weight: 700;
            letter-spacing: 0.1em;
            text-transform: uppercase;
            margin-bottom: 2.5rem;
            animation: pulse-badge 2s ease-in-out infinite;
        }

        .dark .promo-bold-badge {
            background: rgba(255, 255, 255, 0.1);
            border-color: rgba(255, 255, 255, 0.2);
            color: rgba(255, 255, 255, 0.95);
        }

        @keyframes pulse-badge {

            0%,
            100% {
                box-shadow: 0 0 0 0 rgba(255, 255, 255, 0.4);
            }

            50% {
                box-shadow: 0 0 0 10px rgba(255, 255, 255, 0);
            }
        }

        .dark @keyframes pulse-badge {

            0%,
            100% {
                box-shadow: 0 0 0 0 rgba(255, 255, 255, 0.2);
            }

            50% {
                box-shadow: 0 0 0 10px rgba(255, 255, 255, 0);
            }
        }

        /* Bold Headline */
        .promo-bold-headline {
            font-size: 2.5rem;
            font-weight: 800;
            line-height: 1.2;
            color: white;
            margin-bottom: 1rem;
            letter-spacing: -0.02em;
            text-transform: uppercase;
            text-shadow: 0 4px 20px rgba(0, 0, 0, 0.3);
            background: linear-gradient(to bottom, white, rgba(255, 255, 255, 0.8));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .dark .promo-bold-headline {
            background: linear-gradient(to bottom, white, rgba(255, 255, 255, 0.9));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            filter: drop-shadow(0 2px 4px rgba(0, 0, 0, 0.5));
        }

        @media (min-width: 768px) {
            .promo-bold-headline {
                font-size: 3rem;
            }
        }

        @media (max-width: 640px) {
            .promo-bold-headline {
                font-size: 1.875rem;
            }
        }

        /* Bold Description */
        .promo-bold-description {
            font-size: 1.125rem;
            line-height: 1.7;
            color: rgba(255, 255, 255, 0.95);
            margin-bottom: 2.5rem;
            font-weight: 500;
            max-width: 700px;
            margin-left: auto;
            margin-right: auto;
        }

        .dark .promo-bold-description {
            color: rgba(255, 255, 255, 0.9);
        }

        @media (max-width: 640px) {
            .promo-bold-description {
                font-size: 1rem;
            }
        }

        /* Bold Promo Code */
        .promo-bold-code-container {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            margin-bottom: 3rem;
        }

        .promo-bold-code-label {
            font-size: 1.125rem;
            font-weight: 600;
            color: rgba(255, 255, 255, 0.8);
            text-transform: uppercase;
            letter-spacing: 0.05em;
        }

        .dark .promo-bold-code-label {
            color: rgba(255, 255, 255, 0.75);
        }

        .promo-bold-code-box {
            display: inline-flex;
            align-items: center;
            gap: 0.625rem;
            padding: 0.625rem 1.25rem;
            background: linear-gradient(135deg, #fbbf24, #f59e0b);
            border-radius: 0.5rem;
            cursor: pointer;
            transition: all 0.3s ease;
            box-shadow: 0 4px 12px rgba(251, 191, 36, 0.3);
        }

        .dark .promo-bold-code-box {
            background: linear-gradient(135deg, #f59e0b, #d97706);
            box-shadow: 0 4px 12px rgba(217, 119, 6, 0.4);
        }

        .promo-bold-code-box:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(251, 191, 36, 0.5);
        }

        .dark .promo-bold-code-box:hover {
            box-shadow: 0 4px 12px rgba(217, 119, 6, 0.6);
        }

        .promo-bold-code-text {
            font-family: 'Courier New', monospace;
            font-size: 1.125rem;
            font-weight: 700;
            letter-spacing: 0.1em;
            color: #78350f;
            text-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

        @media (max-width: 640px) {
            .promo-bold-code-text {
                font-size: 1rem;
            }
        }

        /* Bold CTA Button - white with primary color text */
        .promo-bold-cta {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 0.75rem;
            padding: 1rem 2.5rem;
            background: white;
            color: var(--color-primary-700);
            font-weight: 700;
            font-size: 1.125rem;
            border-radius: 9999px;
            transition: all 0.3s ease;
            text-decoration: none;
            text-transform: uppercase;
            letter-spacing: 0.05em;
            box-shadow: 0 8px 30px rgba(0, 0, 0, 0.25);
            position: relative;
            overflow: hidden;
            white-space: nowrap;
        }

        .promo-bold-cta::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(135deg, var(--color-primary-50), var(--color-secondary-50));
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .promo-bold-cta:hover::before {
            opacity: 1;
        }

        .promo-bold-cta span,
        .promo-bold-cta svg {
            position: relative;
            z-index: 1;
        }

        .dark .promo-bold-cta {
            background: rgba(255, 255, 255, 0.95);
            color: var(--color-primary-600);
            box-shadow: 0 8px 30px rgba(0, 0, 0, 0.35);
        }

        .promo-bold-cta:hover {
            transform: translateY(-3px) scale(1.02);
            box-shadow: 0 12px 40px rgba(0, 0, 0, 0.35);
        }

        .dark .promo-bold-cta:hover {
            box-shadow: 0 12px 40px rgba(0, 0, 0, 0.45);
        }

        [dir="rtl"] .promo-bold-cta svg {
            transform: rotate(180deg);
        }

        /* Bold Countdown */
        .promo-bold-countdown {
            display: flex;
            justify-content: center;
            gap: 2rem;
            margin-bottom: 3rem;
        }

        @media (max-width: 640px) {
            .promo-bold-countdown {
                gap: 1rem;
            }
        }

        .promo-bold-countdown-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            padding: 1.5rem;
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            border: 2px solid rgba(255, 255, 255, 0.2);
            border-radius: 1rem;
            min-width: 100px;
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.2);
        }

        .dark .promo-bold-countdown-item {
            background: rgba(255, 255, 255, 0.05);
            border-color: rgba(255, 255, 255, 0.1);
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.4);
        }

        @media (max-width: 640px) {
            .promo-bold-countdown-item {
                min-width: 70px;
                padding: 1rem;
            }
        }

        .promo-bold-countdown-value {
            font-size: 3rem;
            font-weight: 900;
            color: white;
            line-height: 1;
            text-shadow: 0 2px 10px rgba(0, 0, 0, 0.3);
        }

        .dark .promo-bold-countdown-value {
            color: white;
            text-shadow: 0 2px 15px rgba(0, 0, 0, 0.5);
        }

        @media (max-width: 640px) {
            .promo-bold-countdown-value {
                font-size: 2rem;
            }
        }

        .promo-bold-countdown-label {
            font-size: 0.875rem;
            color: rgba(255, 255, 255, 0.9);
            text-transform: uppercase;
            letter-spacing: 0.1em;
            margin-top: 0.5rem;
            font-weight: 700;
        }

        .dark .promo-bold-countdown-label {
            color: rgba(255, 255, 255, 0.8);
        }

        /* Bold Terms */
        .promo-bold-terms {
            margin-top: 2.5rem;
            font-size: 0.875rem;
            color: rgba(255, 255, 255, 0.7);
            line-height: 1.6;
            max-width: 600px;
            margin-left: auto;
            margin-right: auto;
        }

        .dark .promo-bold-terms {
            color: rgba(255, 255, 255, 0.5);
        }

        /* Bold Icon */
        .promo-bold-icon {
            font-size: 4rem;
            color: #fbbf24;
            margin-bottom: 1.5rem;
            filter: drop-shadow(0 4px 15px rgba(251, 191, 36, 0.4));
            animation: bounce-icon 2s ease-in-out infinite;
        }

        .dark .promo-bold-icon {
            color: #f59e0b;
            filter: drop-shadow(0 4px 15px rgba(217, 119, 6, 0.5));
        }

        @keyframes bounce-icon {

            0%,
            100% {
                transform: translateY(0);
            }

            50% {
                transform: translateY(-15px);
            }
        }
    </style>


    <section class="section relative promo-bold-bg"
        @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
        {{-- Bold Geometric Shapes --}}
        <div class="promo-bold-shapes">
            <div class="promo-bold-square promo-bold-square-1"></div>
            <div class="promo-bold-square promo-bold-square-2"></div>
            <div class="promo-bold-square promo-bold-square-3"></div>
            <div class="promo-bold-triangle promo-bold-triangle-1"></div>
            <div class="promo-bold-triangle promo-bold-triangle-2"></div>
        </div>

        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-24">
            <div class="promo-bold-content">
                {{-- Icon --}}
                <div class="promo-bold-icon">
                    <x-icon icon="{{ $section['icon'] }}" class="w-20 h-20 mx-auto" />
                </div>

                {{-- Badge --}}
                <div class="promo-bold-badge">
                    <span>{{ $section['discount_value'] ?? '50%' }} {{ $section['discount_label'] ?? 'OFF' }}</span>
                </div>

                {{-- Headline --}}
                <h2 class="promo-bold-headline">{{ $section['headline'] }}</h2>

                {{-- Description --}}
                <p class="promo-bold-description">{{ $section['description'] }}</p>

                {{-- Countdown Timer --}}
                @if ($section['show_countdown'] && !empty($section['expiry_date']))
                    <div class="promo-bold-countdown" data-countdown-timer data-expiry="{{ $section['expiry_date'] }}">
                        <div class="promo-bold-countdown-item">
                            <div class="promo-bold-countdown-value" data-countdown-days>00</div>
                            <div class="promo-bold-countdown-label">{{ $section['countdown_days_label'] ?? 'Days' }}
                            </div>
                        </div>
                        <div class="promo-bold-countdown-item">
                            <div class="promo-bold-countdown-value" data-countdown-hours>00</div>
                            <div class="promo-bold-countdown-label">{{ $section['countdown_hours_label'] ?? 'Hrs' }}
                            </div>
                        </div>
                        <div class="promo-bold-countdown-item">
                            <div class="promo-bold-countdown-value" data-countdown-minutes>00</div>
                            <div class="promo-bold-countdown-label">{{ $section['countdown_minutes_label'] ?? 'Mins' }}
                            </div>
                        </div>
                        <div class="promo-bold-countdown-item">
                            <div class="promo-bold-countdown-value" data-countdown-seconds>00</div>
                            <div class="promo-bold-countdown-label">{{ $section['countdown_seconds_label'] ?? 'Secs' }}
                            </div>
                        </div>
                    </div>
                @endif

                {{-- Promo Code --}}
                @if ($section['show_promo_code'] && !empty($section['promo_code']))
                    <div class="promo-bold-code-container">
                        <div class="promo-bold-code-box" x-data="{ copied: false }"
                            @click="navigator.clipboard.writeText('{{ $section['promo_code'] }}'); copied = true; setTimeout(() => copied = false, 2000)">
                            <span class="promo-bold-code-text">{{ $section['promo_code'] }}</span>
                            <x-icon icon="lucide:copy" class="w-4 h-4 text-amber-900" x-show="!copied" />
                            <x-icon icon="lucide:check" class="w-4 h-4 text-green-700" x-show="copied" x-cloak />
                        </div>
                    </div>
                @endif

                {{-- CTA Button --}}
                <a href="{{ $section['cta_url'] }}" class="promo-bold-cta">
                    <span>{{ $section['cta_text'] }}</span>
                    <x-icon icon="lucide:arrow-right" class="w-4 h-4" />
                </a>

                {{-- Terms --}}
                @if (!empty($section['terms']))
                    <p class="promo-bold-terms">{{ $section['terms'] }}</p>
                @endif
            </div>
        </div>
    </section>

    @if (($section['show_countdown'] ?? false) && !empty($section['expiry_date']))
        @script
            <script>
                (function() {
                    const timers = document.querySelectorAll('[data-countdown-timer]');

                    timers.forEach(function(wrapper) {
                        if (wrapper.dataset.countdownInitialized) return;
                        wrapper.dataset.countdownInitialized = 'true';

                        const endDateStr = (wrapper.getAttribute('data-expiry') || '').replace(' ', 'T');
                        if (!endDateStr) return;

                        const daysEl = wrapper.querySelector('[data-countdown-days]');
                        const hoursEl = wrapper.querySelector('[data-countdown-hours]');
                        const minutesEl = wrapper.querySelector('[data-countdown-minutes]');
                        const secondsEl = wrapper.querySelector('[data-countdown-seconds]');

                        if (!daysEl || !hoursEl || !minutesEl || !secondsEl) return;

                        function updateCountdown() {
                            const end = new Date(endDateStr).getTime();
                            const now = new Date().getTime();
                            const diff = end - now;

                            if (diff > 0) {
                                daysEl.textContent = String(Math.floor(diff / (1000 * 60 * 60 * 24))).padStart(2, '0');
                                hoursEl.textContent = String(Math.floor((diff % (1000 * 60 * 60 * 24)) / (1000 * 60 *
                                    60))).padStart(2, '0');
                                minutesEl.textContent = String(Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60)))
                                    .padStart(2, '0');
                                secondsEl.textContent = String(Math.floor((diff % (1000 * 60)) / 1000)).padStart(2,
                                    '0');
                            } else {
                                wrapper.style.display = 'none';
                            }
                        }

                        updateCountdown();
                        setInterval(updateCountdown, 1000);
                    });
                })();
            </script>
        @endscript
    @endif

</div>
