<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(array $section = [], array $company = [], array $social = [], array $services = [], bool $isWhiteBackground = false, ?int $paddingTop = null, ?int $paddingBottom = null)
    {
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        $defaults = [
            'headline' => '50% OFF Your First Order!',
            'description' => 'New customers get 50% off their first laundry order. Use code WELCOME50 at checkout.',
            'promo_code' => 'WELCOME50',
            'show_promo_code' => true,
            'promo_code_label' => 'Use promo code:',
            'copied_message' => 'Copied to clipboard!',
            'cta_text' => 'Claim Offer',
            'cta_url' => '#contact',
            'expiry_date' => '', // Format: 'YYYY-MM-DD HH:MM:SS' or '2026-12-31 23:59:59'
            'show_countdown' => false,
            'countdown_label' => 'Offer ends in:',
            'countdown_days_label' => 'Days',
            'countdown_hours_label' => 'Hrs',
            'countdown_minutes_label' => 'Mins',
            'countdown_seconds_label' => 'Secs',
            'discount_value' => '50%',
            'discount_label' => 'OFF',
            'icon' => 'lucide:gift',
            'terms' => 'Valid for new customers only. Cannot be combined with other offers.',
        ];

        $this->section = array_merge($defaults, $section);
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>

<div>
    <style>
        /* Minimal Background Styles */
        .promo-minimal-bg {
            background: linear-gradient(to right,
                    var(--color-primary-50) 0%,
                    var(--color-primary-100) 100%);
        }

        .dark .promo-minimal-bg {
            background: linear-gradient(to right,
                    var(--color-primary-950) 0%,
                    var(--color-primary-900) 100%);
        }

        /* Minimal Geometric Shapes */
        .promo-minimal-shapes {
            position: absolute;
            inset: 0;
            pointer-events: none;
            overflow: hidden;
            opacity: 0.4;
        }

        .promo-minimal-line {
            position: absolute;
            background: linear-gradient(to right,
                    transparent,
                    var(--color-primary-200),
                    transparent);
            height: 1px;
            animation: slide-line 8s ease-in-out infinite;
        }

        .dark .promo-minimal-line {
            background: linear-gradient(to right,
                    transparent,
                    var(--color-primary-800),
                    transparent);
        }

        .promo-minimal-line-1 {
            width: 300px;
            top: 20%;
            left: 10%;
        }

        .promo-minimal-line-2 {
            width: 200px;
            top: 60%;
            right: 15%;
            animation-delay: 2s;
        }

        .promo-minimal-line-3 {
            width: 150px;
            bottom: 25%;
            left: 20%;
            animation-delay: 4s;
        }

        @keyframes slide-line {

            0%,
            100% {
                transform: translateX(0) scaleX(1);
                opacity: 0.2;
            }

            50% {
                transform: translateX(20px) scaleX(1.5);
                opacity: 0.6;
            }
        }

        [dir="rtl"] .promo-minimal-line {
            animation-name: slide-line-rtl;
        }

        @keyframes slide-line-rtl {

            0%,
            100% {
                transform: translateX(0) scaleX(1);
                opacity: 0.2;
            }

            50% {
                transform: translateX(-20px) scaleX(1.5);
                opacity: 0.6;
            }
        }

        .promo-minimal-dot {
            position: absolute;
            width: 6px;
            height: 6px;
            border-radius: 50%;
            background: var(--color-primary-400);
            animation: pulse-dot 3s ease-in-out infinite;
        }

        .dark .promo-minimal-dot {
            background: var(--color-primary-600);
        }

        .promo-minimal-dot-1 {
            top: 15%;
            right: 25%;
        }

        .promo-minimal-dot-2 {
            bottom: 30%;
            left: 30%;
            animation-delay: 1s;
        }

        .promo-minimal-dot-3 {
            top: 50%;
            right: 15%;
            animation-delay: 2s;
        }

        @keyframes pulse-dot {

            0%,
            100% {
                transform: scale(1);
                opacity: 0.3;
            }

            50% {
                transform: scale(1.5);
                opacity: 0.8;
            }
        }

        /* Minimal Content Container */
        .promo-minimal-content {
            position: relative;
            z-index: 10;
            max-width: 800px;
            margin: 0 auto;
            text-align: center;
        }

        /* Minimal Badge */
        .promo-minimal-badge {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.5rem 1rem;
            background: white;
            border: 1px solid var(--color-primary-200);
            border-radius: 9999px;
            color: var(--color-primary-700);
            font-size: 0.875rem;
            font-weight: 600;
            letter-spacing: 0.05em;
            text-transform: uppercase;
            margin-bottom: 1.5rem;
        }

        .dark .promo-minimal-badge {
            background: var(--color-primary-900);
            border-color: var(--color-primary-700);
            color: var(--color-primary-300);
        }

        /* Minimal Headline */
        .promo-minimal-headline {
            font-size: 2.5rem;
            font-weight: 800;
            line-height: 1.2;
            color: var(--color-primary-900);
            margin-bottom: 1rem;
            letter-spacing: -0.02em;
        }

        .dark .promo-minimal-headline {
            color: var(--color-primary-50);
        }

        @media (min-width: 768px) {
            .promo-minimal-headline {
                font-size: 3rem;
            }
        }

        @media (max-width: 640px) {
            .promo-minimal-headline {
                font-size: 1.875rem;
            }
        }

        /* Minimal Description */
        .promo-minimal-description {
            font-size: 1.125rem;
            line-height: 1.7;
            color: var(--color-gray-600);
            margin-bottom: 2.5rem;
            max-width: 600px;
            margin-left: auto;
            margin-right: auto;
        }

        .dark .promo-minimal-description {
            color: var(--color-text-tertiary);
        }

        @media (max-width: 640px) {
            .promo-minimal-description {
                font-size: 1rem;
            }
        }

        /* Minimal Promo Code */
        .promo-minimal-code-wrapper {
            display: inline-flex;
            align-items: center;
            gap: 0.625rem;
            padding: 0.625rem 1.25rem;
            background: white;
            border: 2px solid var(--color-primary-300);
            border-radius: 0.5rem;
            margin-bottom: 2.5rem;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .dark .promo-minimal-code-wrapper {
            background: var(--color-primary-900);
            border-color: var(--color-primary-700);
        }

        .promo-minimal-code-wrapper:hover {
            border-color: var(--color-primary-500);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            transform: translateY(-2px);
        }

        .promo-minimal-code-text {
            font-family: 'Courier New', monospace;
            font-size: 1.125rem;
            font-weight: 700;
            letter-spacing: 0.1em;
            color: var(--color-primary-600);
        }

        .dark .promo-minimal-code-text {
            color: var(--color-primary-400);
        }

        /* Minimal CTA Button */
        .promo-minimal-cta {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
            padding: 0.75rem 1.5rem;
            background: linear-gradient(135deg, var(--color-primary-600), var(--color-primary-700));
            color: white;
            font-weight: 600;
            font-size: 1rem;
            border-radius: 0.5rem;
            transition: all 0.3s ease;
            text-decoration: none;
            white-space: nowrap;
            box-shadow: 0 4px 14px rgba(var(--color-primary-rgb, 37, 99, 235), 0.35);
        }

        .promo-minimal-cta:hover {
            background: linear-gradient(135deg, var(--color-primary-700), var(--color-primary-800));
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(var(--color-primary-rgb, 37, 99, 235), 0.45);
        }

        .dark .promo-minimal-cta {
            background: linear-gradient(135deg, var(--color-primary-500), var(--color-primary-600));
        }

        .dark .promo-minimal-cta:hover {
            background: linear-gradient(135deg, var(--color-primary-400), var(--color-primary-500));
        }

        [dir="rtl"] .promo-minimal-cta svg {
            transform: rotate(180deg);
        }

        /* Minimal Countdown */
        .promo-minimal-countdown {
            display: flex;
            justify-content: center;
            gap: 1.5rem;
            margin-bottom: 2.5rem;
        }

        @media (max-width: 640px) {
            .promo-minimal-countdown {
                gap: 1rem;
            }
        }

        .promo-minimal-countdown-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            padding: 1rem;
            background: white;
            border: 1px solid var(--color-primary-200);
            border-radius: 0.5rem;
            min-width: 80px;
        }

        .dark .promo-minimal-countdown-item {
            background: var(--color-primary-900);
            border-color: var(--color-primary-700);
        }

        @media (max-width: 640px) {
            .promo-minimal-countdown-item {
                min-width: 60px;
                padding: 0.75rem;
            }
        }

        .promo-minimal-countdown-value {
            font-size: 2rem;
            font-weight: 700;
            color: var(--color-primary-600);
            line-height: 1;
        }

        .dark .promo-minimal-countdown-value {
            color: var(--color-primary-400);
        }

        @media (max-width: 640px) {
            .promo-minimal-countdown-value {
                font-size: 1.5rem;
            }
        }

        .promo-minimal-countdown-label {
            font-size: 0.75rem;
            color: var(--color-primary-600);
            text-transform: uppercase;
            letter-spacing: 0.05em;
            margin-top: 0.25rem;
        }

        .dark .promo-minimal-countdown-label {
            color: var(--color-primary-400);
        }

        /* Minimal Terms */
        .promo-minimal-terms {
            margin-top: 2rem;
            font-size: 0.875rem;
            color: var(--color-primary-600);
            line-height: 1.5;
        }

        .dark .promo-minimal-terms {
            color: var(--color-primary-400);
        }
    </style>

    <section class="section relative promo-minimal-bg"
        @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
        {{-- Minimal Geometric Shapes --}}
        <div class="promo-minimal-shapes">
            <div class="promo-minimal-line promo-minimal-line-1"></div>
            <div class="promo-minimal-line promo-minimal-line-2"></div>
            <div class="promo-minimal-line promo-minimal-line-3"></div>
            <div class="promo-minimal-dot promo-minimal-dot-1"></div>
            <div class="promo-minimal-dot promo-minimal-dot-2"></div>
            <div class="promo-minimal-dot promo-minimal-dot-3"></div>
        </div>

        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-20">
            <div class="promo-minimal-content">
                {{-- Badge --}}
                <div class="promo-minimal-badge">
                    <x-icon icon="{{ $section['icon'] }}" class="w-4 h-4" />
                    <span>{{ $section['subtitle'] }}</span>
                </div>

                {{-- Headline --}}
                <h2 class="promo-minimal-headline">{{ $section['headline'] }}</h2>

                {{-- Description --}}
                <p class="promo-minimal-description">{{ $section['description'] }}</p>

                {{-- Countdown Timer --}}
                @if ($section['show_countdown'] && !empty($section['expiry_date']))
                    <div class="promo-minimal-countdown" data-countdown-timer
                        data-expiry="{{ $section['expiry_date'] }}">
                        <div class="promo-minimal-countdown-item">
                            <div class="promo-minimal-countdown-value" data-countdown-days>00</div>
                            <div class="promo-minimal-countdown-label">{{ $section['countdown_days_label'] ?? 'Days' }}
                            </div>
                        </div>
                        <div class="promo-minimal-countdown-item">
                            <div class="promo-minimal-countdown-value" data-countdown-hours>00</div>
                            <div class="promo-minimal-countdown-label">{{ $section['countdown_hours_label'] ?? 'Hrs' }}
                            </div>
                        </div>
                        <div class="promo-minimal-countdown-item">
                            <div class="promo-minimal-countdown-value" data-countdown-minutes>00</div>
                            <div class="promo-minimal-countdown-label">
                                {{ $section['countdown_minutes_label'] ?? 'Mins' }}</div>
                        </div>
                        <div class="promo-minimal-countdown-item">
                            <div class="promo-minimal-countdown-value" data-countdown-seconds>00</div>
                            <div class="promo-minimal-countdown-label">
                                {{ $section['countdown_seconds_label'] ?? 'Secs' }}</div>
                        </div>
                    </div>
                @endif

                {{-- Promo Code --}}
                @if ($section['show_promo_code'] && !empty($section['promo_code']))
                    <div class="promo-minimal-code-wrapper" x-data="{ copied: false }"
                        @click="navigator.clipboard.writeText('{{ $section['promo_code'] }}'); copied = true; setTimeout(() => copied = false, 2000)">
                        <span class="promo-minimal-code-text">{{ $section['promo_code'] }}</span>
                        <x-icon icon="lucide:copy" class="w-5 h-5 text-primary-500" x-show="!copied" />
                        <x-icon icon="lucide:check" class="w-5 h-5 text-green-500" x-show="copied" x-cloak />
                    </div>
                @endif

                {{-- CTA Button --}}
                <a href="{{ $section['cta_url'] }}" class="promo-minimal-cta">
                    <span>{{ $section['cta_text'] }}</span>
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M13 7l5 5m0 0l-5 5m5-5H6" />
                    </svg>
                </a>

                {{-- Terms --}}
                @if (!empty($section['terms']))
                    <p class="promo-minimal-terms">{{ $section['terms'] }}</p>
                @endif
            </div>
        </div>
    </section>

    @if (($section['show_countdown'] ?? false) && !empty($section['expiry_date']))
        @script
            <script>
                (function() {
                    const timers = document.querySelectorAll('[data-countdown-timer]');

                    timers.forEach(function(wrapper) {
                        if (wrapper.dataset.countdownInitialized) return;
                        wrapper.dataset.countdownInitialized = 'true';

                        const endDateStr = (wrapper.getAttribute('data-expiry') || '').replace(' ', 'T');
                        if (!endDateStr) return;

                        const daysEl = wrapper.querySelector('[data-countdown-days]');
                        const hoursEl = wrapper.querySelector('[data-countdown-hours]');
                        const minutesEl = wrapper.querySelector('[data-countdown-minutes]');
                        const secondsEl = wrapper.querySelector('[data-countdown-seconds]');

                        if (!daysEl || !hoursEl || !minutesEl || !secondsEl) return;

                        function updateCountdown() {
                            const end = new Date(endDateStr).getTime();
                            const now = new Date().getTime();
                            const diff = end - now;

                            if (diff > 0) {
                                daysEl.textContent = String(Math.floor(diff / (1000 * 60 * 60 * 24))).padStart(2, '0');
                                hoursEl.textContent = String(Math.floor((diff % (1000 * 60 * 60 * 24)) / (1000 * 60 *
                                    60))).padStart(2, '0');
                                minutesEl.textContent = String(Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60)))
                                    .padStart(2, '0');
                                secondsEl.textContent = String(Math.floor((diff % (1000 * 60)) / 1000)).padStart(2,
                                '0');
                            } else {
                                wrapper.style.display = 'none';
                            }
                        }

                        updateCountdown();
                        setInterval(updateCountdown, 1000);
                    });
                })();
            </script>
        @endscript
    @endif

</div>
