<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(array $section = [], array $company = [], array $social = [], array $services = [], bool $isWhiteBackground = false, ?int $paddingTop = null, ?int $paddingBottom = null)
    {
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        $defaults = [
            'headline' => '50% OFF Your First Order!',
            'description' => 'New customers get 50% off their first laundry order. Use code WELCOME50 at checkout.',
            'promo_code' => 'WELCOME50',
            'show_promo_code' => true,
            'promo_code_label' => 'Use promo code:',
            'copied_message' => 'Copied to clipboard!',
            'cta_text' => 'Claim Offer',
            'cta_url' => '#contact',
            'expiry_date' => '', // Format: 'YYYY-MM-DD HH:MM:SS' or '2026-12-31 23:59:59'
            'show_countdown' => false,
            'countdown_label' => 'Offer ends in:',
            'countdown_days_label' => 'Days',
            'countdown_hours_label' => 'Hrs',
            'countdown_minutes_label' => 'Mins',
            'countdown_seconds_label' => 'Secs',
            'discount_value' => '50%',
            'discount_label' => 'OFF',
            'icon' => 'lucide:gift',
            'terms' => 'Valid for new customers only. Cannot be combined with other offers.',
        ];

        $this->section = array_merge($defaults, $section);
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>

<div>
    <style>
        /* Split Background Styles */
        .promo-split-bg {
            background: linear-gradient(to right,
                    var(--color-primary-500) 0%,
                    var(--color-primary-600) 50%,
                    var(--color-secondary-600) 100%);
        }

        .dark .promo-split-bg {
            background: linear-gradient(to right,
                    var(--color-primary-900) 0%,
                    var(--color-primary-950) 50%,
                    var(--color-secondary-900) 100%);
        }

        /* Split Container */
        .promo-split-container {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 3rem;
            align-items: center;
            min-height: 500px;
        }

        @media (max-width: 1024px) {
            .promo-split-container {
                grid-template-columns: 1fr;
                gap: 2rem;
                min-height: auto;
            }
        }

        /* Split Content Side */
        .promo-split-content {
            position: relative;
            z-index: 10;
            padding: 2rem;
        }

        [dir="rtl"] .promo-split-content {
            text-align: right;
        }

        @media (max-width: 1024px) {
            .promo-split-content {
                text-align: center;
                padding: 1rem;
            }
        }

        /* Split Visual Side */
        .promo-split-visual {
            position: relative;
            z-index: 10;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            padding: 2rem;
        }

        @media (max-width: 1024px) {
            .promo-split-visual {
                order: -1;
                padding: 1rem;
            }
        }

        /* Split Shapes */
        .promo-split-shapes {
            position: absolute;
            inset: 0;
            pointer-events: none;
            overflow: hidden;
        }

        .promo-split-wave {
            position: absolute;
            width: 150%;
            height: 150%;
            opacity: 0.1;
            animation: wave-split 20s ease-in-out infinite;
        }

        .promo-split-wave-1 {
            top: -50%;
            left: -25%;
            background: radial-gradient(ellipse at center,
                    var(--color-primary-300) 0%,
                    transparent 70%);
        }

        .dark .promo-split-wave-1 {
            background: radial-gradient(ellipse at center,
                    var(--color-primary-500) 0%,
                    transparent 70%);
            opacity: 0.08;
        }

        .promo-split-wave-2 {
            bottom: -50%;
            right: -25%;
            background: radial-gradient(ellipse at center,
                    var(--color-secondary-300) 0%,
                    transparent 70%);
            animation-delay: 5s;
        }

        .dark .promo-split-wave-2 {
            background: radial-gradient(ellipse at center,
                    var(--color-secondary-500) 0%,
                    transparent 70%);
            opacity: 0.08;
        }

        @keyframes wave-split {

            0%,
            100% {
                transform: scale(1) rotate(0deg);
            }

            50% {
                transform: scale(1.1) rotate(5deg);
            }
        }

        .promo-split-diagonal {
            position: absolute;
            width: 2px;
            height: 200%;
            top: -50%;
            left: 50%;
            transform: translateX(-50%) rotate(15deg);
            background: linear-gradient(to bottom,
                    transparent,
                    rgba(255, 255, 255, 0.1),
                    transparent);
        }

        .dark .promo-split-diagonal {
            background: linear-gradient(to bottom,
                    transparent,
                    rgba(255, 255, 255, 0.05),
                    transparent);
        }

        @media (max-width: 1024px) {
            .promo-split-diagonal {
                display: none;
            }
        }

        /* Split Badge */
        .promo-split-badge {
            display: inline-flex;
            align-items: center;
            gap: 0.625rem;
            padding: 0.75rem 1.75rem;
            background: rgba(255, 255, 255, 0.15);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.25);
            border-radius: 9999px;
            color: white;
            font-size: 0.875rem;
            font-weight: 700;
            letter-spacing: 0.05em;
            text-transform: uppercase;
            margin-bottom: 2rem;
        }

        .dark .promo-split-badge {
            background: rgba(255, 255, 255, 0.1);
            border-color: rgba(255, 255, 255, 0.2);
            color: rgba(255, 255, 255, 0.95);
        }

        @media (max-width: 1024px) {
            .promo-split-badge {
                margin-left: auto;
                margin-right: auto;
            }
        }

        /* Split Headline */
        .promo-split-headline {
            font-size: 2.5rem;
            font-weight: 800;
            line-height: 1.2;
            color: white;
            margin-bottom: 1rem;
            letter-spacing: -0.02em;
            text-shadow: 0 4px 20px rgba(0, 0, 0, 0.3);
        }

        .dark .promo-split-headline {
            color: white;
            text-shadow: 0 4px 20px rgba(0, 0, 0, 0.5);
        }

        @media (min-width: 768px) {
            .promo-split-headline {
                font-size: 3rem;
            }
        }

        @media (max-width: 640px) {
            .promo-split-headline {
                font-size: 1.875rem;
            }
        }

        /* Split Description */
        .promo-split-description {
            font-size: 1.125rem;
            line-height: 1.7;
            color: rgba(255, 255, 255, 0.95);
            margin-bottom: 2.5rem;
            font-weight: 400;
        }

        .dark .promo-split-description {
            color: rgba(255, 255, 255, 0.9);
        }

        @media (max-width: 640px) {
            .promo-split-description {
                font-size: 1rem;
            }
        }

        /* Split CTA */
        .promo-split-cta {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
            padding: 0.75rem 1.5rem;
            background: linear-gradient(135deg, #fbbf24, #f59e0b);
            color: #78350f;
            font-weight: 600;
            font-size: 1rem;
            border-radius: 0.5rem;
            transition: all 0.3s ease;
            text-decoration: none;
            white-space: nowrap;
            box-shadow: 0 4px 14px rgba(251, 191, 36, 0.4);
        }

        .dark .promo-split-cta {
            background: linear-gradient(135deg, #f59e0b, #d97706);
            box-shadow: 0 4px 14px rgba(217, 119, 6, 0.4);
        }

        .promo-split-cta:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(251, 191, 36, 0.5);
        }

        .dark .promo-split-cta:hover {
            box-shadow: 0 6px 20px rgba(217, 119, 6, 0.6);
        }

        [dir="rtl"] .promo-split-cta svg {
            transform: rotate(180deg);
        }

        @media (max-width: 1024px) {
            .promo-split-cta {
                margin-left: auto;
                margin-right: auto;
            }
        }

        /* Split Terms */
        .promo-split-terms {
            margin-top: 2rem;
            font-size: 0.875rem;
            color: rgba(255, 255, 255, 0.75);
            line-height: 1.6;
        }

        .dark .promo-split-terms {
            color: rgba(255, 255, 255, 0.7);
        }

        /* Visual Side Container */
        .promo-split-visual-wrapper {
            position: relative;
            width: 100%;
            max-width: 420px;
            margin: 0 auto;
        }

        /* Decorative Rings */
        .promo-split-ring {
            position: absolute;
            border: 2px solid rgba(255, 255, 255, 0.1);
            border-radius: 50%;
            animation: ring-pulse 4s ease-in-out infinite;
        }

        .dark .promo-split-ring {
            border-color: rgba(255, 255, 255, 0.05);
        }

        .promo-split-ring-1 {
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            animation-delay: 0s;
        }

        .promo-split-ring-2 {
            width: 120%;
            height: 120%;
            top: -10%;
            left: -10%;
            animation-delay: 1s;
            opacity: 0.5;
        }

        .promo-split-ring-3 {
            width: 140%;
            height: 140%;
            top: -20%;
            left: -20%;
            animation-delay: 2s;
            opacity: 0.3;
        }

        @keyframes ring-pulse {

            0%,
            100% {
                transform: scale(1);
                opacity: var(--ring-opacity, 1);
            }

            50% {
                transform: scale(1.05);
                opacity: calc(var(--ring-opacity, 1) * 0.6);
            }
        }

        .promo-split-ring-1 {
            --ring-opacity: 1;
        }

        .promo-split-ring-2 {
            --ring-opacity: 0.5;
        }

        .promo-split-ring-3 {
            --ring-opacity: 0.3;
        }

        /* Main Visual Card */
        .promo-split-visual-card {
            position: relative;
            background: linear-gradient(145deg,
                    rgba(255, 255, 255, 0.15) 0%,
                    rgba(255, 255, 255, 0.05) 100%);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 1.5rem;
            padding: 2.5rem 2rem;
            box-shadow:
                0 25px 50px rgba(0, 0, 0, 0.25),
                inset 0 1px 0 rgba(255, 255, 255, 0.2);
            overflow: hidden;
        }

        .dark .promo-split-visual-card {
            background: linear-gradient(145deg,
                    rgba(255, 255, 255, 0.12) 0%,
                    rgba(255, 255, 255, 0.04) 100%);
            border-color: rgba(255, 255, 255, 0.15);
            box-shadow:
                0 25px 50px rgba(0, 0, 0, 0.5),
                inset 0 1px 0 rgba(255, 255, 255, 0.15);
        }

        .promo-split-visual-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 1px;
            background: linear-gradient(90deg,
                    transparent,
                    rgba(255, 255, 255, 0.4),
                    transparent);
        }

        .dark .promo-split-visual-card::before {
            background: linear-gradient(90deg,
                    transparent,
                    rgba(255, 255, 255, 0.2),
                    transparent);
        }

        @media (max-width: 640px) {
            .promo-split-visual-card {
                padding: 2rem 1.5rem;
                border-radius: 1rem;
            }
        }

        /* Discount Display */
        .promo-split-discount {
            text-align: center;
            margin-bottom: 1.5rem;
        }

        .promo-split-discount-badge {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.5rem 1rem;
            background: linear-gradient(135deg, #fbbf24, #f59e0b);
            border-radius: 9999px;
            margin-bottom: 1rem;
            box-shadow: 0 4px 15px rgba(251, 191, 36, 0.4);
        }

        .dark .promo-split-discount-badge {
            background: linear-gradient(135deg, #f59e0b, #d97706);
            box-shadow: 0 4px 15px rgba(217, 119, 6, 0.4);
        }

        .promo-split-discount-badge-text {
            font-size: 0.75rem;
            font-weight: 700;
            color: #78350f;
            text-transform: uppercase;
            letter-spacing: 0.05em;
        }

        .promo-split-visual-icon {
            color: #fbbf24;
            margin-bottom: 0.75rem;
            filter: drop-shadow(0 4px 15px rgba(251, 191, 36, 0.5));
            animation: icon-bounce 2s ease-in-out infinite;
        }

        .dark .promo-split-visual-icon {
            color: #f59e0b;
            filter: drop-shadow(0 4px 15px rgba(217, 119, 6, 0.5));
        }

        @keyframes icon-bounce {

            0%,
            100% {
                transform: translateY(0);
            }

            50% {
                transform: translateY(-8px);
            }
        }

        .promo-split-visual-percent {
            font-size: 4.5rem;
            font-weight: 900;
            line-height: 1;
            background: linear-gradient(180deg, white 0%, rgba(255, 255, 255, 0.7) 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            text-shadow: none;
            filter: drop-shadow(0 4px 8px rgba(0, 0, 0, 0.3));
        }

        .dark .promo-split-visual-percent {
            background: linear-gradient(180deg, white 0%, rgba(255, 255, 255, 0.85) 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            filter: drop-shadow(0 4px 12px rgba(0, 0, 0, 0.5));
        }

        @media (max-width: 640px) {
            .promo-split-visual-percent {
                font-size: 3.5rem;
            }
        }

        .promo-split-visual-label {
            font-size: 1.5rem;
            font-weight: 800;
            color: rgba(255, 255, 255, 0.9);
            text-transform: uppercase;
            letter-spacing: 0.15em;
            margin-top: 0.25rem;
        }

        .dark .promo-split-visual-label {
            color: rgba(255, 255, 255, 0.9);
        }

        @media (max-width: 640px) {
            .promo-split-visual-label {
                font-size: 1.25rem;
            }
        }

        /* Split Promo Code in Visual */
        .promo-split-visual-code {
            margin-top: 1.5rem;
            text-align: center;
        }

        .promo-split-code-label {
            font-size: 0.75rem;
            color: rgba(255, 255, 255, 0.7);
            text-transform: uppercase;
            letter-spacing: 0.1em;
            margin-bottom: 0.5rem;
        }

        .dark .promo-split-code-label {
            color: rgba(255, 255, 255, 0.7);
        }

        .promo-split-visual-code-box {
            display: inline-flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.875rem 1.5rem;
            background: rgba(255, 255, 255, 0.95);
            border-radius: 0.5rem;
            cursor: pointer;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
            border: 2px dashed var(--color-primary-400);
        }

        .dark .promo-split-visual-code-box {
            background: rgba(255, 255, 255, 0.9);
            border-color: var(--color-primary-500);
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.35);
        }

        .promo-split-visual-code-box:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.25);
            background: white;
        }

        .dark .promo-split-visual-code-box:hover {
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.4);
            background: rgba(255, 255, 255, 0.95);
        }

        .promo-split-visual-code-text {
            font-family: 'Courier New', monospace;
            font-size: 1.25rem;
            font-weight: 700;
            letter-spacing: 0.15em;
            color: var(--color-primary-700);
        }

        .dark .promo-split-visual-code-text {
            color: var(--color-primary-600);
        }

        .promo-split-code-copy-icon {
            color: var(--color-primary-500);
        }

        .dark .promo-split-code-copy-icon {
            color: var(--color-primary-600);
        }

        @media (max-width: 640px) {
            .promo-split-visual-code-text {
                font-size: 1rem;
            }
        }

        /* Split Countdown in Visual */
        .promo-split-countdown {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 0.75rem;
            margin-top: 1.5rem;
        }

        @media (max-width: 640px) {
            .promo-split-countdown {
                gap: 0.5rem;
            }
        }

        .promo-split-countdown-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            padding: 0.875rem 0.5rem;
            background: rgba(0, 0, 0, 0.2);
            border: 1px solid rgba(255, 255, 255, 0.15);
            border-radius: 0.75rem;
            backdrop-filter: blur(5px);
        }

        .dark .promo-split-countdown-item {
            background: rgba(0, 0, 0, 0.3);
            border-color: rgba(255, 255, 255, 0.08);
        }

        .promo-split-countdown-value {
            font-size: 1.75rem;
            font-weight: 800;
            color: white;
            line-height: 1;
            text-shadow: 0 2px 4px rgba(0, 0, 0, 0.3);
        }

        .dark .promo-split-countdown-value {
            text-shadow: 0 2px 4px rgba(0, 0, 0, 0.5);
        }

        @media (max-width: 640px) {
            .promo-split-countdown-value {
                font-size: 1.25rem;
            }
        }

        .promo-split-countdown-label {
            font-size: 0.625rem;
            color: rgba(255, 255, 255, 0.8);
            text-transform: uppercase;
            letter-spacing: 0.05em;
            margin-top: 0.375rem;
            font-weight: 600;
        }

        .dark .promo-split-countdown-label {
            color: rgba(255, 255, 255, 0.75);
        }

        /* Sparkle decorations */
        .promo-split-sparkle {
            position: absolute;
            width: 8px;
            height: 8px;
            background: #fbbf24;
            border-radius: 50%;
            animation: sparkle 2s ease-in-out infinite;
        }

        .dark .promo-split-sparkle {
            background: #f59e0b;
        }

        .promo-split-sparkle-1 {
            top: 15%;
            left: 10%;
            animation-delay: 0s;
        }

        .promo-split-sparkle-2 {
            top: 25%;
            right: 15%;
            animation-delay: 0.5s;
        }

        .promo-split-sparkle-3 {
            bottom: 20%;
            left: 15%;
            animation-delay: 1s;
        }

        .promo-split-sparkle-4 {
            bottom: 30%;
            right: 10%;
            animation-delay: 1.5s;
        }

        @keyframes sparkle {

            0%,
            100% {
                opacity: 0.3;
                transform: scale(1);
            }

            50% {
                opacity: 1;
                transform: scale(1.5);
            }
        }
    </style>


    <section class="section relative promo-split-bg"
        @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
        {{-- Split Shapes --}}
        <div class="promo-split-shapes">
            <div class="promo-split-wave promo-split-wave-1"></div>
            <div class="promo-split-wave promo-split-wave-2"></div>
            <div class="promo-split-diagonal"></div>
        </div>

        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-20">
            <div class="promo-split-container">
                {{-- Content Side --}}
                <div class="promo-split-content">
                    {{-- Badge --}}
                    <div class="promo-split-badge">
                        <x-icon icon="{{ $section['icon'] }}" class="w-4 h-4" />
                        <span>{{ $section['discount_value'] ?? '50%' }} {{ $section['discount_label'] ?? 'OFF' }} -
                            Limited Time!</span>
                    </div>

                    {{-- Headline --}}
                    <h2 class="promo-split-headline">{{ $section['headline'] }}</h2>

                    {{-- Description --}}
                    <p class="promo-split-description">{{ $section['description'] }}</p>

                    {{-- CTA Button --}}
                    <a href="{{ $section['cta_url'] }}" class="promo-split-cta">
                        <span>{{ $section['cta_text'] }}</span>
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M13 7l5 5m0 0l-5 5m5-5H6" />
                        </svg>
                    </a>

                    {{-- Terms --}}
                    @if (!empty($section['terms']))
                        <p class="promo-split-terms">{{ $section['terms'] }}</p>
                    @endif
                </div>

                {{-- Visual Side --}}
                <div class="promo-split-visual">
                    <div class="promo-split-visual-wrapper">
                        {{-- Decorative Rings --}}
                        <div class="promo-split-ring promo-split-ring-3"></div>
                        <div class="promo-split-ring promo-split-ring-2"></div>
                        <div class="promo-split-ring promo-split-ring-1"></div>

                        {{-- Main Visual Card --}}
                        <div class="promo-split-visual-card">
                            {{-- Sparkle decorations --}}
                            <div class="promo-split-sparkle promo-split-sparkle-1"></div>
                            <div class="promo-split-sparkle promo-split-sparkle-2"></div>
                            <div class="promo-split-sparkle promo-split-sparkle-3"></div>
                            <div class="promo-split-sparkle promo-split-sparkle-4"></div>

                            {{-- Discount Display --}}
                            <div class="promo-split-discount">
                                {{-- Icon --}}
                                <div class="promo-split-visual-icon">
                                    <svg class="w-12 h-12 mx-auto" fill="none" stroke="currentColor" stroke-width="2"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round"
                                            d="M19 5L5 19M6.5 9a2.5 2.5 0 100-5 2.5 2.5 0 000 5zM17.5 20a2.5 2.5 0 100-5 2.5 2.5 0 000 5z" />
                                    </svg>
                                </div>

                                {{-- Large Percentage --}}
                                <div class="promo-split-visual-percent">{{ $section['discount_value'] ?? '50%' }}</div>
                                <div class="promo-split-visual-label">{{ $section['discount_label'] ?? 'OFF' }}</div>
                            </div>

                            {{-- Countdown Timer --}}
                            @if ($section['show_countdown'] && !empty($section['expiry_date']))
                                <div class="promo-split-countdown" data-countdown-timer
                                    data-expiry="{{ $section['expiry_date'] }}">
                                    <div class="promo-split-countdown-item">
                                        <div class="promo-split-countdown-value" data-countdown-days>00</div>
                                        <div class="promo-split-countdown-label">
                                            {{ $section['countdown_days_label'] ?? 'Days' }}</div>
                                    </div>
                                    <div class="promo-split-countdown-item">
                                        <div class="promo-split-countdown-value" data-countdown-hours>00</div>
                                        <div class="promo-split-countdown-label">
                                            {{ $section['countdown_hours_label'] ?? 'Hrs' }}</div>
                                    </div>
                                    <div class="promo-split-countdown-item">
                                        <div class="promo-split-countdown-value" data-countdown-minutes>00</div>
                                        <div class="promo-split-countdown-label">
                                            {{ $section['countdown_minutes_label'] ?? 'Mins' }}</div>
                                    </div>
                                    <div class="promo-split-countdown-item">
                                        <div class="promo-split-countdown-value" data-countdown-seconds>00</div>
                                        <div class="promo-split-countdown-label">
                                            {{ $section['countdown_seconds_label'] ?? 'Secs' }}</div>
                                    </div>
                                </div>
                            @endif

                            {{-- Promo Code --}}
                            @if ($section['show_promo_code'] && !empty($section['promo_code']))
                                <div class="promo-split-visual-code">
                                    <div class="promo-split-code-label">Use Code</div>
                                    <div class="promo-split-visual-code-box" x-data="{ copied: false }"
                                        @click="navigator.clipboard.writeText('{{ $section['promo_code'] }}'); copied = true; setTimeout(() => copied = false, 2000)">
                                        <span class="promo-split-visual-code-text">{{ $section['promo_code'] }}</span>
                                        <svg class="w-5 h-5 promo-split-code-copy-icon" x-show="!copied" fill="none"
                                            stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z" />
                                        </svg>
                                        <svg class="w-5 h-5 text-green-600" x-show="copied" x-cloak fill="none"
                                            stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7" />
                                        </svg>
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    @if (($section['show_countdown'] ?? false) && !empty($section['expiry_date']))
        @script
            <script>
                (function() {
                    const timers = document.querySelectorAll('[data-countdown-timer]');

                    timers.forEach(function(wrapper) {
                        if (wrapper.dataset.countdownInitialized) return;
                        wrapper.dataset.countdownInitialized = 'true';

                        const endDateStr = (wrapper.getAttribute('data-expiry') || '').replace(' ', 'T');
                        if (!endDateStr) return;

                        const daysEl = wrapper.querySelector('[data-countdown-days]');
                        const hoursEl = wrapper.querySelector('[data-countdown-hours]');
                        const minutesEl = wrapper.querySelector('[data-countdown-minutes]');
                        const secondsEl = wrapper.querySelector('[data-countdown-seconds]');

                        if (!daysEl || !hoursEl || !minutesEl || !secondsEl) return;

                        function updateCountdown() {
                            const end = new Date(endDateStr).getTime();
                            const now = new Date().getTime();
                            const diff = end - now;

                            if (diff > 0) {
                                daysEl.textContent = String(Math.floor(diff / (1000 * 60 * 60 * 24))).padStart(2, '0');
                                hoursEl.textContent = String(Math.floor((diff % (1000 * 60 * 60 * 24)) / (1000 * 60 *
                                    60))).padStart(2, '0');
                                minutesEl.textContent = String(Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60)))
                                    .padStart(2, '0');
                                secondsEl.textContent = String(Math.floor((diff % (1000 * 60)) / 1000)).padStart(2,
                                    '0');
                            } else {
                                wrapper.style.display = 'none';
                            }
                        }

                        updateCountdown();
                        setInterval(updateCountdown, 1000);
                    });
                })();
            </script>
        @endscript
    @endif

</div>
