<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(
        array $section = [],
        array $items = [],
        array $company = [],
        array $social = [],
        array $services = [],
        bool $isWhiteBackground = false,
        ?int $paddingTop = null,
        ?int $paddingBottom = null
    ) {
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->items = $items;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        $defaults = [
            'headline' => '50% OFF Your First Order!',
            'description' => 'New customers get 50% off their first laundry order. Use code WELCOME50 at checkout.',
            'promo_code' => 'WELCOME50',
            'show_promo_code' => true,
            'promo_code_label' => 'Use promo code:',
            'copied_message' => 'Copied to clipboard!',
            'cta_text' => 'Claim Offer',
            'cta_url' => '#contact',
            'expiry_date' => '', // Format: 'YYYY-MM-DD HH:MM:SS' or '2026-12-31 23:59:59'
            'show_countdown' => false,
            'countdown_label' => 'Offer ends in:',
            'countdown_days_label' => 'Days',
            'countdown_hours_label' => 'Hrs',
            'countdown_minutes_label' => 'Mins',
            'countdown_seconds_label' => 'Secs',
            'discount_value' => '50%',
            'discount_label' => 'OFF',
            'icon' => 'lucide:gift',
            'terms' => 'Valid for new customers only. Cannot be combined with other offers.',
        ];

        $this->section = array_merge($defaults, $section);
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>

<div>
<section class="section relative promo-bg" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    {{-- Background Shapes --}}
    <div class="promo-shapes">
        <div class="promo-shape promo-shape-1"></div>
        <div class="promo-shape promo-shape-2"></div>
        <div class="promo-shape promo-shape-3"></div>
    </div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-24">
        <div class="promo-content">
                {{-- Icon --}}
                @if(!empty($section['icon']))
                <div class="promo-icon-badge scroll-animate" data-animation="zoom-in">
                    <x-icon icon="{{ $section['icon'] }}" class="w-10 h-10" />
                </div>
                @endif

                {{-- Title Badge --}}
                @if(!empty($section['title']))
                <div class="scroll-animate" data-animation="fade-down" style="animation-delay: 0.1s">
                    <span class="promo-title-badge">{{ $section['title'] }}</span>
                </div>
                @endif

                {{-- Headline --}}
                @if(!empty($section['headline']))
                <h2 class="promo-headline scroll-animate" data-animation="fade-up" style="animation-delay: 0.2s">
                    {{ $section['headline'] }}
                </h2>
                @endif

                {{-- Subtitle --}}
                @if(!empty($section['subtitle']))
                <p class="promo-subtitle scroll-animate" data-animation="fade-up" style="animation-delay: 0.25s">
                    {{ $section['subtitle'] }}
                </p>
                @endif

                {{-- Description --}}
                @if(!empty($section['description']))
                <p class="promo-description scroll-animate" data-animation="fade-up" style="animation-delay: 0.3s">
                    {{ $section['description'] }}
                </p>
                @endif

                {{-- Promo Code Box --}}
                @if(($section['show_promo_code'] ?? false) && !empty($section['promo_code']))
                <div class="promo-code-wrapper scroll-animate" data-animation="zoom-in" style="animation-delay: 0.4s" x-data="{ copied: false }">
                    <p class="promo-code-label">{{ $section['promo_code_label'] ?? 'Use promo code:' }}</p>
                    <button
                        @click="navigator.clipboard.writeText('{{ $section['promo_code'] }}'); copied = true; setTimeout(() => copied = false, 2000)"
                        class="promo-code-box group">
                        <span class="promo-code-text">{{ $section['promo_code'] }}</span>
                        <div class="flex items-center gap-2">
                            <svg x-show="!copied" class="w-5 h-5 promo-copy-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z"/>
                            </svg>
                            <svg x-show="copied" x-cloak class="w-5 h-5 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                            </svg>
                        </div>
                    </button>
                    <p x-show="copied" x-transition class="text-green-400 text-sm mt-2">{{ $section['copied_message'] ?? 'Copied to clipboard!' }}</p>
                </div>
                @endif

                {{-- Countdown Timer --}}
                @if(($section['show_countdown'] ?? false) && !empty($section['expiry_date']))
                <div class="promo-countdown-wrapper scroll-animate" data-animation="fade-up" style="animation-delay: 0.5s" data-countdown-timer data-expiry="{{ $section['expiry_date'] }}">
                    <p class="promo-countdown-label">{{ $section['countdown_label'] ?? 'Offer ends in:' }}</p>
                    <div class="promo-countdown">
                        <div class="promo-countdown-item">
                            <span class="promo-countdown-value" data-countdown-days>00</span>
                            <span class="promo-countdown-unit">{{ $section['countdown_days_label'] ?? 'Days' }}</span>
                        </div>
                        <span class="promo-countdown-sep">:</span>
                        <div class="promo-countdown-item">
                            <span class="promo-countdown-value" data-countdown-hours>00</span>
                            <span class="promo-countdown-unit">{{ $section['countdown_hours_label'] ?? 'Hrs' }}</span>
                        </div>
                        <span class="promo-countdown-sep">:</span>
                        <div class="promo-countdown-item">
                            <span class="promo-countdown-value" data-countdown-minutes>00</span>
                            <span class="promo-countdown-unit">{{ $section['countdown_minutes_label'] ?? 'Mins' }}</span>
                        </div>
                        <span class="promo-countdown-sep">:</span>
                        <div class="promo-countdown-item">
                            <span class="promo-countdown-value" data-countdown-seconds>00</span>
                            <span class="promo-countdown-unit">{{ $section['countdown_seconds_label'] ?? 'Secs' }}</span>
                        </div>
                    </div>
                </div>
                @endif

                {{-- CTA Button --}}
                @if(!empty($section['cta_text']))
                <div class="promo-cta-wrapper scroll-animate" data-animation="zoom-in" style="animation-delay: 0.6s">
                    <a href="{{ $section['cta_url'] ?? '#contact' }}" class="promo-cta-btn">
                        <span>{{ $section['cta_text'] }}</span>
                        <svg class="w-4 h-4 rtl:rotate-180" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/>
                        </svg>
                    </a>
                </div>
                @endif

                {{-- Terms --}}
                @if(!empty($section['terms']))
                <p class="promo-terms scroll-animate" data-animation="fade-up" style="animation-delay: 0.7s">
                    {{ $section['terms'] }}
                </p>
                @endif
        </div>
    </div>
</section>

@if(($section['show_countdown'] ?? false) && !empty($section['expiry_date']))
@script
<script>
(function() {
    const timers = document.querySelectorAll('[data-countdown-timer]');

    timers.forEach(function(wrapper) {
        if (wrapper.dataset.countdownInitialized) return;
        wrapper.dataset.countdownInitialized = 'true';

        const endDateStr = (wrapper.getAttribute('data-expiry') || '').replace(' ', 'T');
        if (!endDateStr) return;

        const daysEl = wrapper.querySelector('[data-countdown-days]');
        const hoursEl = wrapper.querySelector('[data-countdown-hours]');
        const minutesEl = wrapper.querySelector('[data-countdown-minutes]');
        const secondsEl = wrapper.querySelector('[data-countdown-seconds]');

        if (!daysEl || !hoursEl || !minutesEl || !secondsEl) return;

        function updateCountdown() {
            const end = new Date(endDateStr).getTime();
            const now = new Date().getTime();
            const diff = end - now;

            if (diff > 0) {
                daysEl.textContent = String(Math.floor(diff / (1000 * 60 * 60 * 24))).padStart(2, '0');
                hoursEl.textContent = String(Math.floor((diff % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60))).padStart(2, '0');
                minutesEl.textContent = String(Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60))).padStart(2, '0');
                secondsEl.textContent = String(Math.floor((diff % (1000 * 60)) / 1000)).padStart(2, '0');
            } else {
                wrapper.style.display = 'none';
            }
        }

        updateCountdown();
        setInterval(updateCountdown, 1000);
    });
})();
</script>
@endscript
@endif

<style>
    /* ===== Promo Banner Section ===== */
    .promo-banner-section {
        position: relative;
        overflow: hidden;
    }

    /* ===== Background ===== */
    .promo-bg {
        background: linear-gradient(135deg,
            var(--color-primary-500) 0%,
            var(--color-primary-700) 50%,
            var(--color-primary-900) 100%);
    }

    .dark .promo-bg {
        background: linear-gradient(135deg,
            var(--color-primary-600) 0%,
            var(--color-primary-800) 50%,
            var(--color-primary-950) 100%);
    }

    /* ===== Background Shapes ===== */
    .promo-shapes {
        position: absolute;
        inset: 0;
        pointer-events: none;
        overflow: hidden;
    }

    .promo-shape {
        position: absolute;
        border-radius: 50%;
        background: rgba(255, 255, 255, 0.05);
        animation: float-shape 20s ease-in-out infinite;
    }

    .promo-shape-1 {
        width: 300px;
        height: 300px;
        top: -100px;
        right: -100px;
        animation-delay: 0s;
    }

    .promo-shape-2 {
        width: 250px;
        height: 250px;
        bottom: -80px;
        left: -80px;
        animation-delay: -7s;
    }

    .promo-shape-3 {
        width: 180px;
        height: 180px;
        top: 40%;
        right: 15%;
        animation-delay: -14s;
    }

    @keyframes float-shape {
        0%, 100% {
            transform: translate(0, 0) scale(1);
            opacity: 0.05;
        }
        33% {
            transform: translate(30px, -30px) scale(1.1);
            opacity: 0.08;
        }
        66% {
            transform: translate(-20px, 20px) scale(0.9);
            opacity: 0.04;
        }
    }

    /* ===== Container ===== */
    .promo-content {
        position: relative;
        z-index: 10;
        max-width: 900px;
        margin: 0 auto;
        text-align: center;
    }

    /* ===== Icon Badge ===== */
    .promo-icon-badge {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        width: 80px;
        height: 80px;
        margin: 0 auto 2rem;
        background: linear-gradient(135deg,
            rgba(251, 191, 36, 0.15),
            rgba(245, 158, 11, 0.2));
        border-radius: 50%;
        position: relative;
    }

    .promo-icon-badge::before {
        content: '';
        position: absolute;
        inset: -4px;
        border-radius: 50%;
        background: linear-gradient(135deg, #fbbf24, #f59e0b);
        opacity: 0.2;
        animation: pulse-ring 2s ease-in-out infinite;
    }

    @keyframes pulse-ring {
        0%, 100% {
            transform: scale(1);
            opacity: 0.2;
        }
        50% {
            transform: scale(1.1);
            opacity: 0;
        }
    }

    .promo-icon-badge svg {
        color: #fbbf24;
        position: relative;
        z-index: 1;
    }

    /* ===== Title Badge ===== */
    .promo-title-badge {
        display: inline-flex;
        align-items: center;
        padding: 0.5rem 1rem;
        background: rgba(255, 255, 255, 0.1);
        backdrop-filter: blur(10px);
        border: 1px solid rgba(255, 255, 255, 0.2);
        border-radius: 9999px;
        font-size: 0.875rem;
        font-weight: 600;
        color: rgba(255, 255, 255, 0.95);
        margin-bottom: 1.5rem;
    }

    /* ===== Headline ===== */
    .promo-headline {
        font-size: 2.5rem;
        font-weight: 800;
        line-height: 1.2;
        color: #ffffff;
        margin-bottom: 1rem;
        text-shadow: 0 2px 20px rgba(0, 0, 0, 0.2);
    }

    @media (min-width: 768px) {
        .promo-headline {
            font-size: 3rem;
        }
    }

    @media (max-width: 640px) {
        .promo-headline {
            font-size: 1.875rem;
        }
    }

    /* ===== Subtitle & Description ===== */
    .promo-subtitle {
        font-size: 1.125rem;
        color: rgba(255, 255, 255, 0.9);
        margin-bottom: 0.5rem;
        line-height: 1.7;
    }

    @media (max-width: 640px) {
        .promo-subtitle {
            font-size: 1rem;
        }
    }

    .promo-description {
        font-size: 1.125rem;
        color: rgba(255, 255, 255, 0.75);
        max-width: 42rem;
        margin: 0 auto 2.5rem;
        line-height: 1.7;
    }

    @media (max-width: 640px) {
        .promo-description {
            font-size: 1rem;
        }
    }

    /* ===== Promo Code Box ===== */
    .promo-code-wrapper {
        margin: 2.5rem auto;
    }

    .promo-code-label {
        font-size: 0.875rem;
        color: rgba(255, 255, 255, 0.7);
        margin-bottom: 0.75rem;
    }

    .promo-code-box {
        display: inline-flex;
        align-items: center;
        gap: 0.625rem;
        padding: 0.625rem 1.25rem;
        background: rgba(255, 255, 255, 0.08);
        backdrop-filter: blur(10px);
        border: 2px dashed rgba(251, 191, 36, 0.5);
        border-radius: 0.5rem;
        cursor: pointer;
        transition: all 0.3s ease;
    }

    .dark .promo-code-box {
        background: rgba(255, 255, 255, 0.05);
        border-color: rgba(251, 191, 36, 0.4);
    }

    .promo-code-box:hover {
        background: rgba(255, 255, 255, 0.12);
        border-color: rgba(251, 191, 36, 0.8);
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
    }

    .dark .promo-code-box:hover {
        background: rgba(255, 255, 255, 0.1);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.5);
    }

    .promo-code-text {
        font-family: 'Courier New', monospace;
        font-size: 1.125rem;
        font-weight: 700;
        letter-spacing: 0.1em;
        color: #fbbf24;
    }

    @media (max-width: 640px) {
        .promo-code-text {
            font-size: 1rem;
        }
    }

    .promo-copy-icon {
        color: rgba(255, 255, 255, 0.6);
        transition: color 0.3s ease;
    }

    .promo-code-box:hover .promo-copy-icon {
        color: rgba(255, 255, 255, 0.9);
    }

    /* ===== Countdown Timer ===== */
    .promo-countdown-wrapper {
        margin: 2.5rem auto;
    }

    .promo-countdown-label {
        font-size: 0.875rem;
        color: rgba(255, 255, 255, 0.7);
        margin-bottom: 1rem;
    }

    .promo-countdown {
        display: flex;
        justify-content: center;
        gap: 0.75rem;
        flex-wrap: wrap;
    }

    .promo-countdown-item {
        display: flex;
        flex-direction: column;
        align-items: center;
        min-width: 70px;
        padding: 1rem 0.75rem;
        background: rgba(255, 255, 255, 0.08);
        backdrop-filter: blur(10px);
        border: 1px solid rgba(255, 255, 255, 0.15);
        border-radius: 0.75rem;
    }

    @media (max-width: 640px) {
        .promo-countdown-item {
            min-width: 60px;
            padding: 0.75rem 0.5rem;
        }
    }

    .promo-countdown-value {
        font-size: 1.75rem;
        font-weight: 700;
        color: #ffffff;
        line-height: 1;
    }

    @media (max-width: 640px) {
        .promo-countdown-value {
            font-size: 1.5rem;
        }
    }

    .promo-countdown-unit {
        font-size: 0.75rem;
        color: rgba(255, 255, 255, 0.6);
        text-transform: uppercase;
        letter-spacing: 0.05em;
        margin-top: 0.25rem;
    }

    .promo-countdown-sep {
        display: flex;
        align-items: center;
        font-size: 1.5rem;
        font-weight: 700;
        color: rgba(255, 255, 255, 0.4);
        animation: blink-sep 1s ease-in-out infinite;
    }

    @keyframes blink-sep {
        0%, 100% { opacity: 1; }
        50% { opacity: 0.3; }
    }

    /* ===== CTA Button ===== */
    .promo-cta-wrapper {
        margin: 2.5rem auto 1.5rem;
    }

    .promo-cta-btn {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 0.5rem;
        padding: 0.75rem 1.5rem;
        background: linear-gradient(135deg, #fbbf24, #f59e0b);
        color: #78350f;
        font-weight: 600;
        font-size: 1rem;
        border-radius: 0.5rem;
        transition: all 0.3s ease;
        box-shadow: 0 4px 14px rgba(251, 191, 36, 0.4);
        position: relative;
        overflow: hidden;
        text-decoration: none;
        white-space: nowrap;
    }

    .promo-cta-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(251, 191, 36, 0.5);
    }

    /* ===== Terms ===== */
    .promo-terms {
        font-size: 0.75rem;
        color: rgba(255, 255, 255, 0.5);
        max-width: 32rem;
        margin: 0 auto;
        line-height: 1.5;
    }

    /* ===== RTL Support ===== */
    [dir="rtl"] .promo-cta-btn svg {
        transform: rotate(180deg);
    }

    /* ===== Dark Mode Adjustments ===== */
    .dark .promo-banner-section {
        /* Already dark by default for promo banner */
    }
</style>
</div>
