<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    private array $defaultItems = [
        [
            'icon' => 'lucide:shirt',
            'title' => 'Wash & Fold',
            'description' => 'Professional washing, drying, and folding service for your everyday clothes.',
            'price' => 'From $2.50/lb',
            'features' => [
                ['text' => 'Same-day service available'],
                ['text' => 'Eco-friendly detergents'],
                ['text' => 'Fabric softener included'],
            ],
            'button_text' => 'Learn More',
            'button_url' => '#contact',
            'button_icon' => 'lucide:arrow-right',
        ],
        [
            'icon' => 'lucide:sparkles',
            'title' => 'Dry Cleaning',
            'description' => 'Expert care for your delicate and special garments that need extra attention.',
            'price' => 'From $8.99/item',
            'features' => [
                ['text' => 'Suits & formal wear'],
                ['text' => 'Delicate fabrics'],
                ['text' => 'Stain treatment included'],
            ],
            'button_text' => 'Learn More',
            'button_url' => '#contact',
            'button_icon' => 'lucide:arrow-right',
        ],
        [
            'icon' => 'lucide:wind',
            'title' => 'Press & Iron',
            'description' => 'Professional pressing and ironing for a crisp, polished look.',
            'price' => 'From $3.50/item',
            'features' => [
                ['text' => 'Steam pressing'],
                ['text' => 'Hand finishing'],
                ['text' => 'Ready to wear'],
            ],
            'button_text' => 'Learn More',
            'button_url' => '#contact',
            'button_icon' => 'lucide:arrow-right',
        ],
        [
            'icon' => 'lucide:bed-double',
            'title' => 'Bedding & Linens',
            'description' => 'Fresh, clean bedding and household linens for maximum comfort.',
            'price' => 'From $15.99/set',
            'features' => [
                ['text' => 'Comforters & duvets'],
                ['text' => 'Sheets & pillowcases'],
                ['text' => 'Allergen removal'],
            ],
            'button_text' => 'Learn More',
            'button_url' => '#contact',
            'button_icon' => 'lucide:arrow-right',
        ],
        [
            'icon' => 'lucide:gem',
            'title' => 'Premium Care',
            'description' => 'Specialized treatment for luxury fabrics and designer pieces.',
            'price' => 'Custom pricing',
            'features' => [
                ['text' => 'Designer labels'],
                ['text' => 'Silk & cashmere'],
                ['text' => 'Hand wash only items'],
            ],
            'button_text' => 'Learn More',
            'button_url' => '#contact',
            'button_icon' => 'lucide:arrow-right',
        ],
        [
            'icon' => 'lucide:zap',
            'title' => 'Express Service',
            'description' => 'Urgent cleaning with quick turnaround when you need it fast.',
            'price' => '+50% rush fee',
            'features' => [
                ['text' => '2-hour turnaround'],
                ['text' => 'Priority handling'],
                ['text' => 'Delivery included'],
            ],
            'button_text' => 'Learn More',
            'button_url' => '#contact',
            'button_icon' => 'lucide:arrow-right',
        ],
    ];

    public function mount(
        array $section = [],
        array $items = [],
        array $company = [],
        array $social = [],
        array $services = [],
        bool $isWhiteBackground = false,
        ?int $paddingTop = null,
        ?int $paddingBottom = null
    ) {
        $this->company = $company;
        $this->social = $social;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        $this->section = array_merge([
            'badge' => 'Our Services',
            'title' => 'Professional Laundry Services',
            'subtitle' => 'From everyday laundry to delicate dry cleaning, we\'ve got all your garment care needs covered.',
        ], $section);

        $this->items = !empty($section['items']) ? $section['items'] : (!empty($items) ? $items : $this->defaultItems);
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>

<div>
<section id="services" class="services-bento-section {{ $isWhiteBackground ? 'services-bento-white' : 'services-bento-gray' }}" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    {{-- Background Elements --}}
    <div class="services-bento-bg">
        <div class="services-bento-noise"></div>
        <div class="services-bento-gradient services-bento-gradient-1"></div>
        <div class="services-bento-gradient services-bento-gradient-2"></div>
    </div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative">
        {{-- Section Header --}}
        <div class="services-bento-header">
            <div class="services-bento-badge">
                <x-icon icon="lucide:grid-3x3" class="w-4 h-4" />
                {{ $section['badge'] }}
            </div>
            <h2 class="services-bento-title">{{ $section['title'] }}</h2>
            <p class="services-bento-subtitle">{{ $section['subtitle'] }}</p>
        </div>

        {{-- Bento Grid --}}
        <div class="services-bento-grid">
            @foreach ($items as $index => $item)
                @php
                    $sizes = ['large', 'small', 'small', 'medium', 'medium', 'large'];
                    $size = $sizes[$index % count($sizes)];
                @endphp
                <div class="services-bento-card services-bento-card-{{ $size }} scroll-animate" style="animation-delay: {{ $index * 100 }}ms">
                    <div class="services-bento-card-bg"></div>
                    <div class="services-bento-card-inner">
                        {{-- Icon with decorative elements --}}
                        <div class="services-bento-icon-wrapper">
                            <div class="services-bento-icon">
                                <x-icon icon="{{ $item['icon'] ?? 'heroicons:sparkles' }}" class="w-7 h-7" />
                            </div>
                            <div class="services-bento-icon-ring"></div>
                        </div>

                        {{-- Content --}}
                        <div class="services-bento-content">
                            <div class="services-bento-title-row">
                                <h3 class="services-bento-card-title">{{ $item['title'] ?? '' }}</h3>
                                @if (!empty($item['price']))
                                    <span class="services-bento-price">{{ $item['price'] }}</span>
                                @endif
                            </div>
                            <p class="services-bento-desc">{{ $item['description'] ?? '' }}</p>

                            {{-- Features for large/medium cards --}}
                            @if ($size !== 'small' && !empty($item['features']))
                                <div class="services-bento-features">
                                    @foreach ($item['features'] as $feature)
                                        <div class="services-bento-feature">
                                            <x-icon icon="lucide:check-circle" class="w-4 h-4" />
                                            <span>{{ is_array($feature) ? ($feature['text'] ?? '') : $feature }}</span>
                                        </div>
                                    @endforeach
                                </div>
                            @endif
                        </div>

                        {{-- Button --}}
                        @if (!empty($item['button_text']) && !empty($item['button_url']))
                            <a href="{{ $item['button_url'] }}" class="services-bento-btn">
                                <span>{{ $item['button_text'] }}</span>
                                <x-icon icon="{{ $item['button_icon'] ?? 'lucide:arrow-up-right' }}" class="w-4 h-4" />
                            </a>
                        @endif

                        {{-- Decorative corner --}}
                        <div class="services-bento-corner"></div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>

<style>
    /* ===== Services Bento Section ===== */
    .services-bento-section {
        position: relative;
        padding: 6rem 0;
        overflow: hidden;
    }

    .services-bento-white {
        background: #ffffff;
    }

    .services-bento-gray {
        background: #f8fafc;
    }

    .dark .services-bento-white {
        background: var(--color-bg-secondary);
    }

    .dark .services-bento-gray {
        background: var(--color-bg-primary);
    }

    /* ===== Background ===== */
    .services-bento-bg {
        position: absolute;
        inset: 0;
        pointer-events: none;
        overflow: hidden;
    }

    .services-bento-noise {
        position: absolute;
        inset: 0;
        background-image: url("data:image/svg+xml,%3Csvg viewBox='0 0 256 256' xmlns='http://www.w3.org/2000/svg'%3E%3Cfilter id='noise'%3E%3CfeTurbulence type='fractalNoise' baseFrequency='0.65' numOctaves='3' stitchTiles='stitch'/%3E%3C/filter%3E%3Crect width='100%25' height='100%25' filter='url(%23noise)'/%3E%3C/svg%3E");
        opacity: 0.03;
    }

    .services-bento-gradient {
        position: absolute;
        width: 600px;
        height: 600px;
        border-radius: 50%;
        filter: blur(120px);
        opacity: 0.4;
    }

    .services-bento-gradient-1 {
        top: -200px;
        right: -100px;
        background: var(--color-primary-200);
    }

    .services-bento-gradient-2 {
        bottom: -200px;
        left: -100px;
        background: var(--color-secondary-200);
    }

    .dark .services-bento-gradient-1 {
        background: var(--color-primary-900);
        opacity: 0.3;
    }

    .dark .services-bento-gradient-2 {
        background: var(--color-secondary-900);
        opacity: 0.3;
    }

    /* ===== Header ===== */
    .services-bento-header {
        text-align: center;
        margin-bottom: 4rem;
    }

    .services-bento-badge {
        display: inline-flex;
        align-items: center;
        gap: 0.5rem;
        padding: 0.5rem 1.25rem;
        background: var(--color-gray-900);
        color: white;
        font-size: 0.8125rem;
        font-weight: 600;
        border-radius: 9999px;
        margin-bottom: 1.5rem;
    }

    .dark .services-bento-badge {
        background: var(--color-primary-600);
    }

    .services-bento-title {
        font-family: var(--font-heading);
        font-size: 2.5rem;
        font-weight: 800;
        color: var(--color-gray-900);
        margin-bottom: 1rem;
    }

    .dark .services-bento-title {
        color: var(--color-text-primary);
    }

    .services-bento-subtitle {
        font-size: 1.125rem;
        color: var(--color-gray-600);
        max-width: 600px;
        margin: 0 auto;
    }

    .dark .services-bento-subtitle {
        color: var(--color-text-tertiary);
    }

    /* ===== Bento Grid ===== */
    .services-bento-grid {
        display: grid;
        grid-template-columns: repeat(4, 1fr);
        grid-auto-rows: minmax(200px, auto);
        gap: 1.5rem;
    }

    /* ===== Card Sizes ===== */
    .services-bento-card-large {
        grid-column: span 2;
        grid-row: span 2;
    }

    .services-bento-card-medium {
        grid-column: span 2;
        grid-row: span 1;
    }

    .services-bento-card-small {
        grid-column: span 1;
        grid-row: span 1;
    }

    /* ===== Card ===== */
    .services-bento-card {
        position: relative;
        border-radius: 1.5rem;
        overflow: hidden;
        transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
    }

    .services-bento-card:hover {
        transform: translateY(-5px);
    }

    .services-bento-card-bg {
        position: absolute;
        inset: 0;
        background: linear-gradient(135deg, var(--color-primary-500), var(--color-secondary-500));
        opacity: 0;
        transition: opacity 0.4s ease;
    }

    .services-bento-card:hover .services-bento-card-bg {
        opacity: 0.05;
    }

    .services-bento-card-inner {
        position: relative;
        height: 100%;
        background: white;
        border: 1px solid var(--color-gray-200);
        border-radius: 1.5rem;
        padding: 1.5rem;
        display: flex;
        flex-direction: column;
        transition: all 0.4s ease;
    }

    .services-bento-card:hover .services-bento-card-inner {
        border-color: var(--color-primary-200);
        box-shadow: 0 20px 50px -15px rgba(0, 0, 0, 0.1);
    }

    .dark .services-bento-card-inner {
        background: var(--color-card-bg);
        border-color: var(--color-border);
    }

    .dark .services-bento-card:hover .services-bento-card-inner {
        border-color: var(--color-primary-700);
        box-shadow: 0 20px 50px -15px rgba(0, 0, 0, 0.4);
    }

    /* ===== Icon ===== */
    .services-bento-icon-wrapper {
        position: relative;
        display: inline-flex;
        margin-bottom: 1.25rem;
    }

    .services-bento-icon {
        width: 3.5rem;
        height: 3.5rem;
        display: flex;
        align-items: center;
        justify-content: center;
        background: linear-gradient(135deg, var(--color-primary-500), var(--color-secondary-500));
        border-radius: 1rem;
        color: white;
        transition: all 0.4s ease;
        position: relative;
        z-index: 1;
    }

    .services-bento-card:hover .services-bento-icon {
        transform: rotate(-10deg) scale(1.1);
    }

    .services-bento-icon-ring {
        position: absolute;
        inset: -6px;
        border: 2px solid var(--color-primary-200);
        border-radius: 1.25rem;
        opacity: 0;
        transition: all 0.4s ease;
    }

    .services-bento-card:hover .services-bento-icon-ring {
        opacity: 1;
        inset: -10px;
    }

    .dark .services-bento-icon-ring {
        border-color: var(--color-primary-700);
    }

    /* ===== Content ===== */
    .services-bento-content {
        flex: 1;
    }

    .services-bento-title-row {
        display: flex;
        align-items: center;
        justify-content: space-between;
        gap: 1rem;
        margin-bottom: 0.5rem;
        flex-wrap: wrap;
    }

    .services-bento-card-title {
        font-family: var(--font-heading);
        font-size: 1.25rem;
        font-weight: 700;
        color: var(--color-gray-900);
    }

    .dark .services-bento-card-title {
        color: var(--color-text-primary);
    }

    .services-bento-price {
        font-size: 0.8125rem;
        font-weight: 700;
        color: var(--color-primary-600);
        padding: 0.25rem 0.75rem;
        background: var(--color-primary-50);
        border-radius: 9999px;
        white-space: nowrap;
    }

    .dark .services-bento-price {
        color: var(--color-primary-400);
        background: rgba(var(--color-primary-rgb, 37, 99, 235), 0.15);
    }

    .services-bento-desc {
        font-size: 0.9375rem;
        color: var(--color-gray-600);
        line-height: 1.6;
        margin-bottom: 1rem;
    }

    .dark .services-bento-desc {
        color: var(--color-text-tertiary);
    }

    /* Small card adjustments */
    .services-bento-card-small .services-bento-desc {
        display: -webkit-box;
        -webkit-line-clamp: 2;
        -webkit-box-orient: vertical;
        overflow: hidden;
    }

    /* ===== Features ===== */
    .services-bento-features {
        display: flex;
        flex-direction: column;
        gap: 0.5rem;
        margin-bottom: 1rem;
    }

    .services-bento-feature {
        display: flex;
        align-items: center;
        gap: 0.5rem;
        font-size: 0.875rem;
        color: var(--color-gray-600);
    }

    .services-bento-feature svg {
        color: var(--color-primary-500);
        flex-shrink: 0;
    }

    .dark .services-bento-feature {
        color: var(--color-text-tertiary);
    }

    .dark .services-bento-feature svg {
        color: var(--color-primary-400);
    }

    /* ===== Button ===== */
    .services-bento-btn {
        display: inline-flex;
        align-items: center;
        gap: 0.5rem;
        font-size: 0.875rem;
        font-weight: 600;
        color: var(--color-gray-900);
        padding: 0.625rem 1.25rem;
        background: var(--color-gray-100);
        border-radius: 0.75rem;
        transition: all 0.3s ease;
        margin-top: auto;
    }

    .services-bento-btn:hover {
        background: var(--color-primary-600);
        color: white;
    }

    .dark .services-bento-btn {
        color: var(--color-text-primary);
        background: var(--color-bg-tertiary);
    }

    .dark .services-bento-btn:hover {
        background: var(--color-primary-600);
        color: white;
    }

    /* ===== Decorative Corner ===== */
    .services-bento-corner {
        position: absolute;
        top: 0;
        right: 0;
        width: 80px;
        height: 80px;
        background: linear-gradient(135deg, transparent 50%, var(--color-primary-50) 50%);
        border-radius: 0 1.5rem 0 0;
        opacity: 0;
        transition: opacity 0.3s ease;
    }

    .services-bento-card:hover .services-bento-corner {
        opacity: 1;
    }

    .dark .services-bento-corner {
        background: linear-gradient(135deg, transparent 50%, rgba(var(--color-primary-rgb, 37, 99, 235), 0.1) 50%);
    }

    /* ===== RTL Support ===== */
    [dir="rtl"] .services-bento-section {
        direction: rtl;
    }

    [dir="rtl"] .services-bento-badge {
        flex-direction: row-reverse;
    }

    [dir="rtl"] .services-bento-content {
        text-align: right;
    }

    [dir="rtl"] .services-bento-title-row {
        flex-direction: row-reverse;
    }

    [dir="rtl"] .services-bento-feature {
        flex-direction: row-reverse;
    }

    [dir="rtl"] .services-bento-btn {
        flex-direction: row-reverse;
    }

    [dir="rtl"] .services-bento-btn svg {
        transform: scaleX(-1);
    }

    [dir="rtl"] .services-bento-card:hover .services-bento-icon {
        transform: rotate(10deg) scale(1.1);
    }

    [dir="rtl"] .services-bento-corner {
        right: auto;
        left: 0;
        background: linear-gradient(-135deg, transparent 50%, var(--color-primary-50) 50%);
        border-radius: 1.5rem 0 0 0;
    }

    [dir="rtl"] .services-bento-gradient-1 {
        right: auto;
        left: -100px;
    }

    [dir="rtl"] .services-bento-gradient-2 {
        left: auto;
        right: -100px;
    }

    /* ===== Responsive ===== */
    @media (max-width: 1024px) {
        .services-bento-grid {
            grid-template-columns: repeat(2, 1fr);
        }

        .services-bento-card-large,
        .services-bento-card-medium {
            grid-column: span 2;
        }

        .services-bento-card-small {
            grid-column: span 1;
        }
    }

    @media (max-width: 640px) {
        .services-bento-section {
            padding: 4rem 0;
        }

        .services-bento-title {
            font-size: 2rem;
        }

        .services-bento-grid {
            grid-template-columns: 1fr;
        }

        .services-bento-card-large,
        .services-bento-card-medium,
        .services-bento-card-small {
            grid-column: span 1;
            grid-row: span 1;
        }

        .services-bento-card-inner {
            padding: 1.25rem;
        }

        .services-bento-btn {
            width: 100%;
            justify-content: center;
        }
    }
</style>
</div>
