<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    private array $defaultItems = [
        [
            'icon' => 'lucide:shirt',
            'title' => 'Wash & Fold',
            'description' => 'Professional washing, drying, and folding service for your everyday clothes.',
            'price' => 'From $2.50/lb',
            'features' => [
                ['text' => 'Same-day service available'],
                ['text' => 'Eco-friendly detergents'],
                ['text' => 'Fabric softener included'],
            ],
            'button_text' => 'Learn More',
            'button_url' => '#contact',
            'button_icon' => 'lucide:arrow-right',
        ],
        [
            'icon' => 'lucide:sparkles',
            'title' => 'Dry Cleaning',
            'description' => 'Expert care for your delicate and special garments that need extra attention.',
            'price' => 'From $8.99/item',
            'features' => [
                ['text' => 'Suits & formal wear'],
                ['text' => 'Delicate fabrics'],
                ['text' => 'Stain treatment included'],
            ],
            'button_text' => 'Learn More',
            'button_url' => '#contact',
            'button_icon' => 'lucide:arrow-right',
        ],
        [
            'icon' => 'lucide:wind',
            'title' => 'Press & Iron',
            'description' => 'Professional pressing and ironing for a crisp, polished look.',
            'price' => 'From $3.50/item',
            'features' => [
                ['text' => 'Steam pressing'],
                ['text' => 'Hand finishing'],
                ['text' => 'Ready to wear'],
            ],
            'button_text' => 'Learn More',
            'button_url' => '#contact',
            'button_icon' => 'lucide:arrow-right',
        ],
        [
            'icon' => 'lucide:bed-double',
            'title' => 'Bedding & Linens',
            'description' => 'Fresh, clean bedding and household linens for maximum comfort.',
            'price' => 'From $15.99/set',
            'features' => [
                ['text' => 'Comforters & duvets'],
                ['text' => 'Sheets & pillowcases'],
                ['text' => 'Allergen removal'],
            ],
            'button_text' => 'Learn More',
            'button_url' => '#contact',
            'button_icon' => 'lucide:arrow-right',
        ],
        [
            'icon' => 'lucide:gem',
            'title' => 'Premium Care',
            'description' => 'Specialized treatment for luxury fabrics and designer pieces.',
            'price' => 'Custom pricing',
            'features' => [
                ['text' => 'Designer labels'],
                ['text' => 'Silk & cashmere'],
                ['text' => 'Hand wash only items'],
            ],
            'button_text' => 'Learn More',
            'button_url' => '#contact',
            'button_icon' => 'lucide:arrow-right',
        ],
        [
            'icon' => 'lucide:zap',
            'title' => 'Express Service',
            'description' => 'Urgent cleaning with quick turnaround when you need it fast.',
            'price' => '+50% rush fee',
            'features' => [
                ['text' => '2-hour turnaround'],
                ['text' => 'Priority handling'],
                ['text' => 'Delivery included'],
            ],
            'button_text' => 'Learn More',
            'button_url' => '#contact',
            'button_icon' => 'lucide:arrow-right',
        ],
    ];

    public function mount(
        array $section = [],
        array $items = [],
        array $company = [],
        array $social = [],
        array $services = [],
        bool $isWhiteBackground = false,
        ?int $paddingTop = null,
        ?int $paddingBottom = null
    ) {
        $this->company = $company;
        $this->social = $social;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        $this->section = array_merge([
            'badge' => 'Our Services',
            'title' => 'Professional Laundry Services',
            'subtitle' => 'From everyday laundry to delicate dry cleaning, we\'ve got all your garment care needs covered.',
        ], $section);

        $this->items = !empty($section['items']) ? $section['items'] : (!empty($items) ? $items : $this->defaultItems);
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>

<div>
<section id="services" class="services-floating-section {{ $isWhiteBackground ? 'services-floating-white' : 'services-floating-gray' }}" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    {{-- Background Elements --}}
    <div class="services-floating-bg">
        <div class="services-floating-gradient"></div>
        <div class="services-floating-grid"></div>
        <div class="services-floating-glow services-floating-glow-1"></div>
        <div class="services-floating-glow services-floating-glow-2"></div>
    </div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative">
        {{-- Section Header --}}
        <div class="services-floating-header">
            <div class="services-floating-badge">
                <div class="services-floating-badge-glow"></div>
                <x-icon icon="lucide:sparkles" class="w-4 h-4" />
                <span>{{ $section['badge'] }}</span>
            </div>
            <h2 class="services-floating-title">{{ $section['title'] }}</h2>
            <p class="services-floating-subtitle">{{ $section['subtitle'] }}</p>
        </div>

        {{-- Services Grid --}}
        <div class="services-floating-grid-container">
            @foreach ($items as $index => $item)
                <div class="services-floating-card scroll-animate" style="animation-delay: {{ $index * 100 }}ms">
                    <div class="services-floating-card-shine"></div>
                    <div class="services-floating-card-inner">
                        {{-- Card Header --}}
                        <div class="services-floating-card-header">
                            <div class="services-floating-icon">
                                <div class="services-floating-icon-glow"></div>
                                <x-icon icon="{{ $item['icon'] ?? 'heroicons:sparkles' }}" class="w-7 h-7" />
                            </div>
                            @if (!empty($item['price']))
                                <div class="services-floating-price">{{ $item['price'] }}</div>
                            @endif
                        </div>

                        {{-- Card Content --}}
                        <div class="services-floating-content">
                            <h3 class="services-floating-card-title">{{ $item['title'] ?? '' }}</h3>
                            <p class="services-floating-desc">{{ $item['description'] ?? '' }}</p>
                        </div>

                        {{-- Features --}}
                        @if (!empty($item['features']))
                            <div class="services-floating-features">
                                @foreach ($item['features'] as $feature)
                                    <div class="services-floating-feature">
                                        <span class="services-floating-feature-icon">
                                            <x-icon icon="lucide:check" class="w-3.5 h-3.5" />
                                        </span>
                                        <span>{{ is_array($feature) ? ($feature['text'] ?? '') : $feature }}</span>
                                    </div>
                                @endforeach
                            </div>
                        @endif

                        {{-- Button --}}
                        @if (!empty($item['button_text']) && !empty($item['button_url']))
                            <a href="{{ $item['button_url'] }}" class="services-floating-btn">
                                <span>{{ $item['button_text'] }}</span>
                                <x-icon icon="{{ $item['button_icon'] ?? 'lucide:arrow-right' }}" class="w-4 h-4" />
                            </a>
                        @endif
                    </div>

                    {{-- Floating Elements --}}
                    <div class="services-floating-element services-floating-element-1"></div>
                    <div class="services-floating-element services-floating-element-2"></div>
                </div>
            @endforeach
        </div>
    </div>
</section>

<style>
    /* ===== Services Floating Section ===== */
    .services-floating-section {
        position: relative;
        padding: 6rem 0;
        overflow: hidden;
    }

    .services-floating-white {
        background: #ffffff;
    }

    .services-floating-gray {
        background: #0f172a;
    }

    .dark .services-floating-white {
        background: var(--color-bg-secondary);
    }

    .dark .services-floating-gray {
        background: #0a0f1a;
    }

    /* ===== Background ===== */
    .services-floating-bg {
        position: absolute;
        inset: 0;
        pointer-events: none;
        overflow: hidden;
    }

    .services-floating-gradient {
        position: absolute;
        inset: 0;
        background: radial-gradient(ellipse at 50% 0%, var(--color-primary-900) 0%, transparent 50%);
        opacity: 0.5;
    }

    .services-floating-grid {
        position: absolute;
        inset: 0;
        background-image:
            linear-gradient(rgba(255, 255, 255, 0.03) 1px, transparent 1px),
            linear-gradient(90deg, rgba(255, 255, 255, 0.03) 1px, transparent 1px);
        background-size: 60px 60px;
    }

    .services-floating-glow {
        position: absolute;
        width: 500px;
        height: 500px;
        border-radius: 50%;
        filter: blur(100px);
        opacity: 0.3;
    }

    .services-floating-glow-1 {
        top: -200px;
        left: 10%;
        background: var(--color-primary-500);
        animation: services-floating-pulse 8s ease-in-out infinite;
    }

    .services-floating-glow-2 {
        bottom: -200px;
        right: 10%;
        background: var(--color-secondary-500);
        animation: services-floating-pulse 8s ease-in-out infinite reverse;
    }

    @keyframes services-floating-pulse {
        0%, 100% { opacity: 0.2; transform: scale(1); }
        50% { opacity: 0.4; transform: scale(1.1); }
    }

    /* ===== Header ===== */
    .services-floating-header {
        text-align: center;
        margin-bottom: 4rem;
    }

    .services-floating-badge {
        display: inline-flex;
        align-items: center;
        gap: 0.5rem;
        padding: 0.5rem 1.25rem;
        background: rgba(255, 255, 255, 0.1);
        backdrop-filter: blur(10px);
        border: 1px solid rgba(255, 255, 255, 0.1);
        color: white;
        font-size: 0.8125rem;
        font-weight: 600;
        border-radius: 9999px;
        margin-bottom: 1.5rem;
        position: relative;
        overflow: hidden;
    }

    .services-floating-badge-glow {
        position: absolute;
        inset: 0;
        background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
        animation: services-floating-shine 3s linear infinite;
    }

    @keyframes services-floating-shine {
        0% { transform: translateX(-100%); }
        100% { transform: translateX(100%); }
    }

    .services-floating-title {
        font-family: var(--font-heading);
        font-size: 2.5rem;
        font-weight: 800;
        color: white;
        margin-bottom: 1rem;
    }

    .services-floating-subtitle {
        font-size: 1.125rem;
        color: rgba(255, 255, 255, 0.6);
        max-width: 600px;
        margin: 0 auto;
    }

    /* Light mode header */
    .services-floating-white .services-floating-badge {
        background: var(--color-primary-50);
        border-color: var(--color-primary-100);
        color: var(--color-primary-600);
    }

    .services-floating-white .services-floating-title {
        color: var(--color-gray-900);
    }

    .services-floating-white .services-floating-subtitle {
        color: var(--color-gray-600);
    }

    .services-floating-white .services-floating-gradient {
        background: radial-gradient(ellipse at 50% 0%, var(--color-primary-100) 0%, transparent 50%);
    }

    .services-floating-white .services-floating-grid {
        background-image:
            linear-gradient(var(--color-gray-100) 1px, transparent 1px),
            linear-gradient(90deg, var(--color-gray-100) 1px, transparent 1px);
    }

    /* ===== Grid ===== */
    .services-floating-grid-container {
        display: grid;
        gap: 1.5rem;
    }

    @media (min-width: 640px) {
        .services-floating-grid-container {
            grid-template-columns: repeat(2, 1fr);
        }
    }

    @media (min-width: 1024px) {
        .services-floating-grid-container {
            grid-template-columns: repeat(3, 1fr);
        }
    }

    /* ===== Card ===== */
    .services-floating-card {
        position: relative;
        border-radius: 1.5rem;
        padding: 2px;
        background: linear-gradient(135deg, rgba(255, 255, 255, 0.1), rgba(255, 255, 255, 0.05));
        transition: all 0.5s cubic-bezier(0.4, 0, 0.2, 1);
        transform-style: preserve-3d;
        perspective: 1000px;
    }

    .services-floating-card:hover {
        transform: translateY(-10px) rotateX(5deg);
    }

    .services-floating-card-shine {
        position: absolute;
        inset: 0;
        border-radius: 1.5rem;
        background: linear-gradient(135deg, rgba(255, 255, 255, 0.1) 0%, transparent 50%);
        opacity: 0;
        transition: opacity 0.3s ease;
    }

    .services-floating-card:hover .services-floating-card-shine {
        opacity: 1;
    }

    .services-floating-card-inner {
        position: relative;
        background: rgba(15, 23, 42, 0.8);
        backdrop-filter: blur(20px);
        border-radius: calc(1.5rem - 2px);
        padding: 1.75rem;
        height: 100%;
        display: flex;
        flex-direction: column;
        border: 1px solid rgba(255, 255, 255, 0.05);
    }

    .services-floating-white .services-floating-card {
        background: linear-gradient(135deg, var(--color-primary-200), var(--color-secondary-200));
    }

    .services-floating-white .services-floating-card-inner {
        background: white;
        border-color: var(--color-gray-100);
    }

    .dark .services-floating-card-inner {
        background: var(--color-card-bg);
        border-color: var(--color-border);
    }

    /* ===== Card Header ===== */
    .services-floating-card-header {
        display: flex;
        align-items: center;
        justify-content: space-between;
        margin-bottom: 1.25rem;
    }

    .services-floating-icon {
        position: relative;
        width: 3.5rem;
        height: 3.5rem;
        display: flex;
        align-items: center;
        justify-content: center;
        background: linear-gradient(135deg, var(--color-primary-500), var(--color-secondary-500));
        border-radius: 1rem;
        color: white;
        transition: all 0.4s ease;
    }

    .services-floating-icon-glow {
        position: absolute;
        inset: -5px;
        background: linear-gradient(135deg, var(--color-primary-500), var(--color-secondary-500));
        border-radius: 1.25rem;
        opacity: 0;
        filter: blur(10px);
        transition: opacity 0.3s ease;
    }

    .services-floating-card:hover .services-floating-icon-glow {
        opacity: 0.5;
    }

    .services-floating-card:hover .services-floating-icon {
        transform: rotate(-10deg) scale(1.1);
    }

    .services-floating-price {
        font-family: var(--font-heading);
        font-size: 0.8125rem;
        font-weight: 700;
        color: var(--color-primary-400);
        padding: 0.375rem 0.875rem;
        background: rgba(var(--color-primary-rgb, 37, 99, 235), 0.2);
        border-radius: 9999px;
    }

    .services-floating-white .services-floating-price {
        color: var(--color-primary-600);
        background: var(--color-primary-50);
    }

    /* ===== Content ===== */
    .services-floating-content {
        flex: 1;
        margin-bottom: 1.25rem;
    }

    .services-floating-card-title {
        font-family: var(--font-heading);
        font-size: 1.25rem;
        font-weight: 700;
        color: white;
        margin-bottom: 0.5rem;
    }

    .services-floating-white .services-floating-card-title {
        color: var(--color-gray-900);
    }

    .dark .services-floating-card-title {
        color: var(--color-text-primary);
    }

    .services-floating-desc {
        font-size: 0.9375rem;
        color: rgba(255, 255, 255, 0.6);
        line-height: 1.6;
    }

    .services-floating-white .services-floating-desc {
        color: var(--color-gray-600);
    }

    .dark .services-floating-desc {
        color: var(--color-text-tertiary);
    }

    /* ===== Features ===== */
    .services-floating-features {
        display: flex;
        flex-direction: column;
        gap: 0.5rem;
        margin-bottom: 1.25rem;
    }

    .services-floating-feature {
        display: flex;
        align-items: center;
        gap: 0.5rem;
        font-size: 0.875rem;
        color: rgba(255, 255, 255, 0.7);
    }

    .services-floating-white .services-floating-feature {
        color: var(--color-gray-600);
    }

    .dark .services-floating-feature {
        color: var(--color-text-tertiary);
    }

    .services-floating-feature-icon {
        width: 1.25rem;
        height: 1.25rem;
        display: flex;
        align-items: center;
        justify-content: center;
        background: rgba(var(--color-primary-rgb, 37, 99, 235), 0.3);
        border-radius: 50%;
        color: var(--color-primary-400);
        flex-shrink: 0;
    }

    .services-floating-white .services-floating-feature-icon {
        background: var(--color-primary-100);
        color: var(--color-primary-600);
    }

    /* ===== Button ===== */
    .services-floating-btn {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 0.5rem;
        padding: 0.75rem 1.5rem;
        background: linear-gradient(135deg, var(--color-primary-500), var(--color-secondary-500));
        color: white;
        font-size: 0.875rem;
        font-weight: 600;
        border-radius: 0.75rem;
        transition: all 0.3s ease;
        margin-top: auto;
        position: relative;
        overflow: hidden;
    }

    .services-floating-btn::before {
        content: '';
        position: absolute;
        inset: 0;
        background: linear-gradient(135deg, var(--color-primary-400), var(--color-secondary-400));
        opacity: 0;
        transition: opacity 0.3s ease;
    }

    .services-floating-btn:hover::before {
        opacity: 1;
    }

    .services-floating-btn span,
    .services-floating-btn svg {
        position: relative;
        z-index: 1;
    }

    .services-floating-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 10px 30px -10px rgba(var(--color-primary-rgb, 37, 99, 235), 0.5);
    }

    /* ===== Floating Elements ===== */
    .services-floating-element {
        position: absolute;
        border-radius: 50%;
        pointer-events: none;
    }

    .services-floating-element-1 {
        width: 60px;
        height: 60px;
        top: -10px;
        right: -10px;
        background: radial-gradient(circle, var(--color-primary-500) 0%, transparent 70%);
        opacity: 0.2;
        animation: services-floating-float 6s ease-in-out infinite;
    }

    .services-floating-element-2 {
        width: 40px;
        height: 40px;
        bottom: 20px;
        left: -5px;
        background: radial-gradient(circle, var(--color-secondary-500) 0%, transparent 70%);
        opacity: 0.2;
        animation: services-floating-float 6s ease-in-out infinite reverse;
    }

    @keyframes services-floating-float {
        0%, 100% { transform: translateY(0) rotate(0deg); }
        50% { transform: translateY(-10px) rotate(180deg); }
    }

    /* ===== RTL Support ===== */
    [dir="rtl"] .services-floating-section {
        direction: rtl;
    }

    [dir="rtl"] .services-floating-badge {
        flex-direction: row-reverse;
    }

    [dir="rtl"] .services-floating-card-header {
        flex-direction: row-reverse;
    }

    [dir="rtl"] .services-floating-content {
        text-align: right;
    }

    [dir="rtl"] .services-floating-feature {
        flex-direction: row-reverse;
    }

    [dir="rtl"] .services-floating-btn {
        flex-direction: row-reverse;
    }

    [dir="rtl"] .services-floating-btn svg {
        transform: scaleX(-1);
    }

    [dir="rtl"] .services-floating-card:hover .services-floating-icon {
        transform: rotate(10deg) scale(1.1);
    }

    [dir="rtl"] .services-floating-element-1 {
        right: auto;
        left: -10px;
    }

    [dir="rtl"] .services-floating-element-2 {
        left: auto;
        right: -5px;
    }

    /* ===== Responsive ===== */
    @media (max-width: 640px) {
        .services-floating-section {
            padding: 4rem 0;
        }

        .services-floating-title {
            font-size: 2rem;
        }

        .services-floating-card-inner {
            padding: 1.5rem;
        }

        .services-floating-btn {
            width: 100%;
        }

        .services-floating-card:hover {
            transform: translateY(-5px);
        }
    }
</style>
</div>
