<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(
        array $section = [],
        array $items = [],
        array $company = [],
        array $social = [],
        array $services = [],
        bool $isWhiteBackground = false,
        ?int $paddingTop = null,
        ?int $paddingBottom = null
    ) {
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        $this->section = array_merge([
            'badge' => 'Statistics',
            'title' => 'Our Achievements',
            'subtitle' => 'Numbers that speak for themselves',
        ], $section);

        // Use items from standardized props
        $this->items = !empty($items) ? $items : [
            ['value' => '15000+', 'label' => 'Happy Customers', 'icon' => 'heroicons:users'],
            ['value' => '50000+', 'label' => 'Orders Completed', 'icon' => 'heroicons:check-circle'],
            ['value' => '99%', 'label' => 'Satisfaction Rate', 'icon' => 'heroicons:star'],
            ['value' => '24/7', 'label' => 'Support Available', 'icon' => 'heroicons:clock'],
        ];
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>

<section id="stats" class="py-16 {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12">
            @if($section['badge'])
                <span class="inline-block px-4 py-1 rounded-full text-sm font-semibold bg-primary-100 text-primary-700 dark:bg-primary-900 dark:text-primary-300 mb-4">
                    {{ $section['badge'] }}
                </span>
            @endif

            <h2 class="text-3xl sm:text-4xl font-bold text-gray-900 dark:text-white mb-4">
                {{ $section['title'] }}
            </h2>

            <p class="text-lg text-gray-600 dark:text-gray-300 max-w-2xl mx-auto">
                {{ $section['subtitle'] }}
            </p>
        </div>

        <div class="grid grid-cols-2 md:grid-cols-4 gap-8">
            @foreach($items as $stat)
                <div class="text-center p-6 rounded-xl bg-gray-50 dark:bg-gray-800 hover:shadow-lg transition-shadow">
                    <div class="inline-flex items-center justify-center w-12 h-12 rounded-full bg-primary-100 dark:bg-primary-900 text-primary-600 dark:text-primary-400 mb-4">
                        <x-icon icon="{{ $stat['icon'] ?? 'heroicons:star' }}" class="w-6 h-6" />
                    </div>
                    <div class="text-3xl sm:text-4xl font-bold text-gray-900 dark:text-white mb-2">
                        {{ $stat['value'] }}
                    </div>
                    <div class="text-gray-600 dark:text-gray-400">
                        {{ $stat['label'] }}
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>
