<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(array $section = [], array $items = [], array $company = [], array $social = [], array $services = [], bool $isWhiteBackground = false, ?int $paddingTop = null, ?int $paddingBottom = null)
    {
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        // Default team members
        $defaultItems = [
            [
                'name' => 'Sarah Johnson',
                'position' => 'CEO & Founder',
                'bio' => 'Visionary leader with 15+ years of industry experience.',
                'image' => 'https://randomuser.me/api/portraits/women/44.jpg',
                'social_links' => [['icon' => 'mdi:linkedin', 'url' => '#'], ['icon' => 'mdi:twitter', 'url' => '#']],
            ],
            [
                'name' => 'Michael Chen',
                'position' => 'Operations Director',
                'bio' => 'Expert in streamlining processes and maximizing efficiency.',
                'image' => 'https://randomuser.me/api/portraits/men/32.jpg',
                'social_links' => [['icon' => 'mdi:linkedin', 'url' => '#'], ['icon' => 'mdi:twitter', 'url' => '#']],
            ],
            [
                'name' => 'Emily Rodriguez',
                'position' => 'Customer Success Manager',
                'bio' => 'Dedicated to ensuring exceptional customer experiences.',
                'image' => 'https://randomuser.me/api/portraits/women/68.jpg',
                'social_links' => [['icon' => 'mdi:linkedin', 'url' => '#'], ['icon' => 'mdi:twitter', 'url' => '#']],
            ],
            [
                'name' => 'David Park',
                'position' => 'Technical Lead',
                'bio' => 'Passionate about innovation and cutting-edge solutions.',
                'image' => 'https://randomuser.me/api/portraits/men/75.jpg',
                'social_links' => [['icon' => 'mdi:linkedin', 'url' => '#'], ['icon' => 'mdi:github', 'url' => '#']],
            ],
        ];

        $this->items = !empty($items) ? $items : $defaultItems;

        $this->section = array_merge(
            [
                'badge' => 'Our Team',
                'title' => 'Meet Our Experts',
                'subtitle' => 'The dedicated professionals behind our success, committed to delivering excellence.',
            ],
            $section,
        );
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>

<div>
    <style>
        .team-carousel-container {
            position: relative;
            overflow: hidden;
        }

        .team-carousel-track {
            display: flex;
            transition: transform 0.5s ease;
            gap: 1.5rem;
        }

        .team-carousel-card {
            flex: 0 0 calc(100% - 1rem);
            min-width: calc(100% - 1rem);
            transition: all 0.3s ease;
        }

        @media (min-width: 640px) {
            .team-carousel-card {
                flex: 0 0 calc(50% - 1rem);
                min-width: calc(50% - 1rem);
            }
        }

        @media (min-width: 1024px) {
            .team-carousel-card {
                flex: 0 0 calc(33.333% - 1rem);
                min-width: calc(33.333% - 1rem);
            }
        }

        .team-carousel-card:hover {
            transform: translateY(-8px);
        }

        .team-carousel-card .card-inner {
            background: linear-gradient(145deg, var(--color-primary-600), var(--color-secondary-600));
            border-radius: 1.5rem;
            padding: 2rem;
            height: 100%;
            position: relative;
            overflow: hidden;
        }

        .team-carousel-card .card-inner::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -50%;
            width: 100%;
            height: 100%;
            background: radial-gradient(circle, rgba(255, 255, 255, 0.1) 0%, transparent 70%);
            pointer-events: none;
        }

        .team-carousel-nav {
            position: absolute;
            top: 50%;
            transform: translateY(-50%);
            width: 48px;
            height: 48px;
            border-radius: 50%;
            background: white;
            border: none;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.15);
            transition: all 0.3s ease;
            z-index: 10;
        }

        .team-carousel-nav:hover {
            background: var(--color-primary-500);
            color: white;
        }

        .team-carousel-nav.prev {
            left: 0;
        }

        .team-carousel-nav.next {
            right: 0;
        }

        [dir="rtl"] .team-carousel-nav.prev {
            left: auto;
            right: 0;
        }

        [dir="rtl"] .team-carousel-nav.next {
            right: auto;
            left: 0;
        }

        .dark .team-carousel-nav {
            background: var(--color-gray-700);
            color: var(--color-text-primary);
        }

        .dark .team-carousel-nav:hover {
            background: var(--color-primary-500);
        }

        .team-carousel-image {
            width: 120px;
            height: 120px;
            border-radius: 50%;
            border: 4px solid rgba(255, 255, 255, 0.3);
            object-fit: cover;
            margin: 0 auto 1.5rem;
            display: block;
        }

        .team-carousel-social a {
            width: 36px;
            height: 36px;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.2);
            display: inline-flex;
            align-items: center;
            justify-content: center;
            color: white;
            transition: all 0.3s ease;
        }

        .team-carousel-social a:hover {
            background: white;
            color: var(--color-primary-600);
            transform: translateY(-3px);
        }
    </style>

    <section id="team"
        class="section {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}"
        @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            {{-- Section Header --}}
            <div class="text-center mb-16 scroll-animate" data-animation="fade-up">
                @if (!empty($section['badge']))
                    <span class="badge badge-primary mb-4">{{ $section['badge'] }}</span>
                @endif
                <h2 class="section-title">{{ $section['title'] }}</h2>
                @if (!empty($section['subtitle']))
                    <p class="section-subtitle">{{ $section['subtitle'] }}</p>
                @endif
            </div>

            {{-- Team Carousel --}}
            <div class="team-carousel-container px-12" x-data="{ currentSlide: 0, totalSlides: {{ count($items) }}, slidesPerView: 3 }" x-init="function updateSlidesPerView() {
                if (window.innerWidth < 640) slidesPerView = 1;
                else if (window.innerWidth < 1024) slidesPerView = 2;
                else slidesPerView = 3;
            }
            updateSlidesPerView();
            window.addEventListener('resize', updateSlidesPerView);">

                {{-- Navigation Buttons --}}
                <button class="team-carousel-nav prev" @click="currentSlide = Math.max(0, currentSlide - 1)"
                    :disabled="currentSlide === 0" :class="{ 'opacity-50 cursor-not-allowed': currentSlide === 0 }">
                    <svg class="w-6 h-6 rtl:rotate-180" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
                    </svg>
                </button>
                <button class="team-carousel-nav next"
                    @click="currentSlide = Math.min(totalSlides - slidesPerView, currentSlide + 1)"
                    :disabled="currentSlide >= totalSlides - slidesPerView"
                    :class="{ 'opacity-50 cursor-not-allowed': currentSlide >= totalSlides - slidesPerView }">
                    <svg class="w-6 h-6 rtl:rotate-180" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                    </svg>
                </button>

                {{-- Carousel Track --}}
                <div class="overflow-hidden">
                    <div class="team-carousel-track"
                        :style="'transform: translateX(' + (currentSlide * -(100 / slidesPerView)) + '%)'">
                        @foreach ($items as $index => $member)
                            <div class="team-carousel-card scroll-animate" data-animation="fade-up"
                                style="animation-delay: {{ $index * 100 }}ms">
                                <div class="card-inner text-center text-white">
                                    @php
                                        $imageUrl = $member['image_url'] ?? ($member['image'] ?? null);
                                        $defaultPlaceholder =
                                            'https://ui-avatars.com/api/?name=' .
                                            urlencode($member['name'] ?? 'Team') .
                                            '&size=300&background=random&color=fff&bold=true';
                                    @endphp
                                    <img src="{{ $imageUrl ?: $defaultPlaceholder }}" alt="{{ $member['name'] ?? '' }}"
                                        class="team-carousel-image" loading="lazy">

                                    <h3 class="text-xl font-bold mb-1">{{ $member['name'] ?? '' }}</h3>

                                    @if (!empty($member['position']) || !empty($member['role']))
                                        <p class="text-white/80 text-sm font-medium mb-3">
                                            {{ $member['position'] ?? $member['role'] }}
                                        </p>
                                    @endif

                                    @if (!empty($member['bio']))
                                        <p class="text-white/70 text-sm mb-4 line-clamp-2">{{ $member['bio'] }}</p>
                                    @endif

                                    @if (!empty($member['social_links']))
                                        <div class="team-carousel-social flex justify-center gap-2">
                                            @foreach ($member['social_links'] as $social)
                                                <a href="{{ $social['url'] ?? '#' }}" target="_blank" rel="noopener">
                                                    <x-icon icon="{{ $social['icon'] ?? 'mdi:link' }}"
                                                        class="w-4 h-4" />
                                                </a>
                                            @endforeach
                                        </div>
                                    @endif
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>

                {{-- Dots Navigation --}}
                <div class="flex justify-center gap-2 mt-8">
                    @foreach ($items as $index => $member)
                        @if ($index <= count($items) - 3)
                            <button class="w-3 h-3 rounded-full transition-all duration-300"
                                :class="currentSlide === {{ $index }} ? 'bg-primary-600 w-8' :
                                    'bg-gray-300 dark:bg-gray-600 hover:bg-gray-400'"
                                @click="currentSlide = {{ $index }}">
                            </button>
                        @endif
                    @endforeach
                </div>
            </div>
        </div>
    </section>
</div>
