<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(array $section = [], array $items = [], array $company = [], array $social = [], array $services = [], bool $isWhiteBackground = false, ?int $paddingTop = null, ?int $paddingBottom = null)
    {
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        // Default team members
        $defaultItems = [
            [
                'name' => 'Sarah Johnson',
                'position' => 'CEO & Founder',
                'bio' => 'Visionary leader with 15+ years of industry experience. Sarah founded the company with a mission to deliver excellence in every service we provide.',
                'image' => 'https://randomuser.me/api/portraits/women/44.jpg',
                'social_links' => [['icon' => 'mdi:linkedin', 'url' => '#'], ['icon' => 'mdi:twitter', 'url' => '#']],
            ],
            [
                'name' => 'Michael Chen',
                'position' => 'Operations Director',
                'bio' => 'Expert in streamlining processes and maximizing efficiency. Michael ensures our operations run smoothly and our customers receive the best service.',
                'image' => 'https://randomuser.me/api/portraits/men/32.jpg',
                'social_links' => [['icon' => 'mdi:linkedin', 'url' => '#'], ['icon' => 'mdi:twitter', 'url' => '#']],
            ],
            [
                'name' => 'Emily Rodriguez',
                'position' => 'Customer Success Manager',
                'bio' => 'Dedicated to ensuring exceptional customer experiences. Emily leads our support team with empathy and a commitment to solving problems.',
                'image' => 'https://randomuser.me/api/portraits/women/68.jpg',
                'social_links' => [['icon' => 'mdi:linkedin', 'url' => '#'], ['icon' => 'mdi:twitter', 'url' => '#']],
            ],
            [
                'name' => 'David Park',
                'position' => 'Technical Lead',
                'bio' => 'Passionate about innovation and cutting-edge solutions. David drives our technical strategy and ensures we stay ahead of the curve.',
                'image' => 'https://randomuser.me/api/portraits/men/75.jpg',
                'social_links' => [['icon' => 'mdi:linkedin', 'url' => '#'], ['icon' => 'mdi:github', 'url' => '#']],
            ],
        ];

        $this->items = !empty($items) ? $items : $defaultItems;

        $this->section = array_merge(
            [
                'badge' => 'Our Team',
                'title' => 'Meet Our Experts',
                'subtitle' => 'The dedicated professionals behind our success, committed to delivering excellence.',
            ],
            $section,
        );
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>

<div>
    <style>
        .team-grid2-card {
            display: flex;
            flex-direction: column;
            transition: all 0.4s ease;
            border-radius: 1rem;
            overflow: hidden;
        }

        @media (min-width: 768px) {
            .team-grid2-card {
                flex-direction: row;
            }

            .team-grid2-card:nth-child(even) {
                flex-direction: row-reverse;
            }

            [dir="rtl"] .team-grid2-card {
                flex-direction: row-reverse;
            }

            [dir="rtl"] .team-grid2-card:nth-child(even) {
                flex-direction: row;
            }
        }

        .team-grid2-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.15);
        }

        .dark .team-grid2-card:hover {
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.4);
        }

        .team-grid2-image-wrapper {
            position: relative;
            flex-shrink: 0;
            width: 100%;
            aspect-ratio: 4/3;
        }

        @media (min-width: 768px) {
            .team-grid2-image-wrapper {
                width: 280px;
                aspect-ratio: auto;
                height: 100%;
                min-height: 280px;
            }
        }

        .team-grid2-image-wrapper::after {
            content: '';
            position: absolute;
            inset: 0;
            background: linear-gradient(135deg, var(--color-primary-600), var(--color-secondary-600));
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .team-grid2-card:hover .team-grid2-image-wrapper::after {
            opacity: 0.2;
        }

        .team-grid2-image-wrapper img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.5s ease;
        }

        .team-grid2-card:hover .team-grid2-image-wrapper img {
            transform: scale(1.05);
        }

        .team-grid2-content {
            padding: 1.5rem;
            display: flex;
            flex-direction: column;
            justify-content: center;
            flex-grow: 1;
        }

        @media (min-width: 768px) {
            .team-grid2-content {
                padding: 2rem;
            }
        }

        .team-grid2-position {
            display: inline-block;
            padding: 0.25rem 0.75rem;
            background: linear-gradient(135deg, var(--color-primary-100), var(--color-secondary-100));
            color: var(--color-primary-700);
            border-radius: 9999px;
            font-size: 0.75rem;
            font-weight: 600;
            margin-bottom: 0.75rem;
        }

        .dark .team-grid2-position {
            background: linear-gradient(135deg, var(--color-primary-900), var(--color-secondary-900));
            color: var(--color-primary-300);
        }

        .team-grid2-social a {
            width: 36px;
            height: 36px;
            border-radius: 50%;
            background: var(--color-gray-100);
            display: inline-flex;
            align-items: center;
            justify-content: center;
            color: var(--color-gray-600);
            transition: all 0.3s ease;
        }

        .dark .team-grid2-social a {
            background: var(--color-gray-700);
            color: var(--color-gray-300);
        }

        .team-grid2-social a:hover {
            background: var(--color-primary-500);
            color: white;
            transform: translateY(-3px);
        }
    </style>

    <section id="team"
        class="section {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}"
        @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
        <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
            {{-- Section Header --}}
            <div class="text-center mb-16 scroll-animate" data-animation="fade-up">
                @if (!empty($section['badge']))
                    <span class="badge badge-primary mb-4">{{ $section['badge'] }}</span>
                @endif
                <h2 class="section-title">{{ $section['title'] }}</h2>
                @if (!empty($section['subtitle']))
                    <p class="section-subtitle">{{ $section['subtitle'] }}</p>
                @endif
            </div>

            {{-- Team Grid --}}
            <div class="space-y-6">
                @foreach ($items as $index => $member)
                    <div class="team-grid2-card bg-white dark:bg-gray-800 shadow-lg scroll-animate"
                        data-animation="fade-up" style="animation-delay: {{ $index * 100 }}ms">
                        {{-- Image --}}
                        <div class="team-grid2-image-wrapper">
                            @php
                                $imageUrl = $member['image_url'] ?? ($member['image'] ?? null);
                                $defaultPlaceholder =
                                    'https://ui-avatars.com/api/?name=' .
                                    urlencode($member['name'] ?? 'Team') .
                                    '&size=300&background=random&color=fff&bold=true';
                            @endphp
                            <img src="{{ $imageUrl ?: $defaultPlaceholder }}" alt="{{ $member['name'] ?? '' }}"
                                loading="lazy">
                        </div>

                        {{-- Content --}}
                        <div class="team-grid2-content">
                            @if (!empty($member['position']) || !empty($member['role']))
                                <span class="team-grid2-position">
                                    {{ $member['position'] ?? $member['role'] }}
                                </span>
                            @endif

                            <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-3">
                                {{ $member['name'] ?? '' }}
                            </h3>

                            @if (!empty($member['bio']))
                                <p class="text-gray-600 dark:text-gray-400 text-sm leading-relaxed mb-4">
                                    {{ $member['bio'] }}
                                </p>
                            @endif

                            @if (!empty($member['social_links']))
                                <div class="team-grid2-social flex gap-2">
                                    @foreach ($member['social_links'] as $social)
                                        <a href="{{ $social['url'] ?? '#' }}" target="_blank" rel="noopener">
                                            <x-icon icon="{{ $social['icon'] ?? 'mdi:link' }}" class="w-4 h-4" />
                                        </a>
                                    @endforeach
                                </div>
                            @endif
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </section>
</div>
