<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(array $section = [], array $items = [], array $company = [], array $social = [], array $services = [], bool $isWhiteBackground = false, ?int $paddingTop = null, ?int $paddingBottom = null)
    {
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        $defaultItems = [
            [
                'name' => 'Sarah Johnson',
                'position' => 'CEO & Founder',
                'bio' => 'Visionary leader with 15+ years of industry experience.',
                'image' => 'https://randomuser.me/api/portraits/women/44.jpg',
                'social_links' => [['icon' => 'mdi:linkedin', 'url' => '#'], ['icon' => 'mdi:twitter', 'url' => '#']],
            ],
            [
                'name' => 'Michael Chen',
                'position' => 'Operations Director',
                'bio' => 'Expert in streamlining processes and maximizing efficiency.',
                'image' => 'https://randomuser.me/api/portraits/men/32.jpg',
                'social_links' => [['icon' => 'mdi:linkedin', 'url' => '#'], ['icon' => 'mdi:twitter', 'url' => '#']],
            ],
            [
                'name' => 'Emily Rodriguez',
                'position' => 'Customer Success Manager',
                'bio' => 'Dedicated to ensuring exceptional customer experiences.',
                'image' => 'https://randomuser.me/api/portraits/women/68.jpg',
                'social_links' => [['icon' => 'mdi:linkedin', 'url' => '#'], ['icon' => 'mdi:twitter', 'url' => '#']],
            ],
            [
                'name' => 'David Park',
                'position' => 'Technical Lead',
                'bio' => 'Passionate about innovation and cutting-edge solutions.',
                'image' => 'https://randomuser.me/api/portraits/men/75.jpg',
                'social_links' => [['icon' => 'mdi:linkedin', 'url' => '#'], ['icon' => 'mdi:github', 'url' => '#']],
            ],
        ];

        $this->items = !empty($items) ? $items : $defaultItems;

        $this->section = array_merge(
            [
                'badge' => 'Our Team',
                'title' => 'Meet Our Experts',
                'subtitle' => 'The dedicated professionals behind our success, committed to delivering excellence.',
            ],
            $section,
        );
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>

<div>
    <style>
        .team-hex-bg {
            position: relative;
            overflow: hidden;
        }

        .team-hex-pattern {
            position: absolute;
            inset: 0;
            opacity: 0.03;
            background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='28' height='49' viewBox='0 0 28 49'%3E%3Cg fill-rule='evenodd'%3E%3Cg fill='%23000000' fill-rule='nonzero'%3E%3Cpath d='M13.99 9.25l13 7.5v15l-13 7.5L1 31.75v-15l12.99-7.5zM3 17.9v12.7l10.99 6.34 11-6.35V17.9l-11-6.34L3 17.9zM0 15l12.98-7.5V0h-2v6.35L0 12.69v2.3zm0 18.5L12.98 41v8h-2v-6.85L0 35.81v-2.3zM15 0v7.5L27.99 15H28v-2.31h-.01L17 6.35V0h-2zm0 49v-8l12.99-7.5H28v2.31h-.01L17 42.15V49h-2z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E");
        }

        .dark .team-hex-pattern {
            opacity: 0.05;
            filter: invert(1);
        }

        .team-hex-shape-1 {
            position: absolute;
            top: 10%;
            right: 5%;
            width: 150px;
            height: 150px;
            background: linear-gradient(135deg, var(--color-primary-500), var(--color-secondary-500));
            clip-path: polygon(50% 0%, 100% 25%, 100% 75%, 50% 100%, 0% 75%, 0% 25%);
            opacity: 0.1;
            animation: float 6s ease-in-out infinite;
        }

        .team-hex-shape-2 {
            position: absolute;
            bottom: 15%;
            left: 3%;
            width: 100px;
            height: 100px;
            background: linear-gradient(135deg, var(--color-secondary-500), var(--color-primary-500));
            clip-path: polygon(50% 0%, 100% 25%, 100% 75%, 50% 100%, 0% 75%, 0% 25%);
            opacity: 0.1;
            animation: float 8s ease-in-out infinite reverse;
        }

        [dir="rtl"] .team-hex-shape-1 {
            right: auto;
            left: 5%;
        }

        [dir="rtl"] .team-hex-shape-2 {
            left: auto;
            right: 3%;
        }

        .team-hex-card {
            position: relative;
            text-align: center;
            padding: 2rem 1.5rem;
            background: white;
            border-radius: 1rem;
            transition: all 0.4s ease;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.06);
        }

        .dark .team-hex-card {
            background: var(--color-card-bg);
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.3);
        }

        .team-hex-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 25px 50px rgba(0, 0, 0, 0.12);
        }

        .dark .team-hex-card:hover {
            box-shadow: 0 25px 50px rgba(0, 0, 0, 0.4);
        }

        .team-hex-image-wrapper {
            position: relative;
            width: 160px;
            height: 180px;
            margin: 0 auto 1.5rem;
        }

        .team-hex-image-bg {
            position: absolute;
            inset: 0;
            background: linear-gradient(135deg, var(--color-primary-500), var(--color-secondary-500));
            clip-path: polygon(50% 0%, 100% 25%, 100% 75%, 50% 100%, 0% 75%, 0% 25%);
            transition: all 0.3s ease;
        }

        .team-hex-card:hover .team-hex-image-bg {
            transform: scale(1.05) rotate(5deg);
        }

        .team-hex-image {
            position: absolute;
            inset: 4px;
            object-fit: cover;
            clip-path: polygon(50% 0%, 100% 25%, 100% 75%, 50% 100%, 0% 75%, 0% 25%);
            transition: all 0.3s ease;
        }

        .team-hex-card:hover .team-hex-image {
            transform: scale(1.02);
        }

        .team-hex-name {
            font-size: 1.25rem;
            font-weight: 700;
            color: var(--color-gray-900);
            margin-bottom: 0.25rem;
        }

        .dark .team-hex-name {
            color: var(--color-text-primary);
        }

        .team-hex-position {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            font-size: 0.875rem;
            font-weight: 500;
            color: var(--color-primary-600);
            margin-bottom: 0.75rem;
        }

        .dark .team-hex-position {
            color: var(--color-primary-400);
        }

        .team-hex-position::before,
        .team-hex-position::after {
            content: '';
            width: 20px;
            height: 2px;
            background: linear-gradient(90deg, var(--color-primary-300), var(--color-secondary-300));
            border-radius: 1px;
        }

        .team-hex-bio {
            font-size: 0.875rem;
            color: var(--color-gray-600);
            line-height: 1.6;
            margin-bottom: 1rem;
        }

        .dark .team-hex-bio {
            color: var(--color-gray-400);
        }

        .team-hex-social {
            display: flex;
            justify-content: center;
            gap: 0.75rem;
        }

        .team-hex-social a {
            width: 36px;
            height: 36px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            background: var(--color-gray-100);
            color: var(--color-gray-600);
            clip-path: polygon(50% 0%, 100% 25%, 100% 75%, 50% 100%, 0% 75%, 0% 25%);
            transition: all 0.3s ease;
        }

        .dark .team-hex-social a {
            background: var(--color-gray-700);
            color: var(--color-gray-300);
        }

        .team-hex-social a:hover {
            background: linear-gradient(135deg, var(--color-primary-500), var(--color-secondary-500));
            color: white;
            transform: scale(1.1) rotate(10deg);
        }

        .team-hex-title-shape {
            display: inline-block;
            position: relative;
        }

        .team-hex-title-shape::before {
            content: '';
            position: absolute;
            top: 50%;
            left: -60px;
            transform: translateY(-50%);
            width: 40px;
            height: 46px;
            background: linear-gradient(135deg, var(--color-primary-500), var(--color-secondary-500));
            clip-path: polygon(50% 0%, 100% 25%, 100% 75%, 50% 100%, 0% 75%, 0% 25%);
            opacity: 0.2;
        }

        .team-hex-title-shape::after {
            content: '';
            position: absolute;
            top: 50%;
            right: -60px;
            transform: translateY(-50%);
            width: 40px;
            height: 46px;
            background: linear-gradient(135deg, var(--color-secondary-500), var(--color-primary-500));
            clip-path: polygon(50% 0%, 100% 25%, 100% 75%, 50% 100%, 0% 75%, 0% 25%);
            opacity: 0.2;
        }

        @media (max-width: 640px) {

            .team-hex-title-shape::before,
            .team-hex-title-shape::after {
                display: none;
            }
        }
    </style>

    <section id="team"
        class="team-hex-bg section {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}"
        @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
        {{-- Background Pattern --}}
        <div class="team-hex-pattern"></div>
        <div class="team-hex-shape-1"></div>
        <div class="team-hex-shape-2"></div>

        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
            {{-- Section Header --}}
            <div class="text-center mb-16 scroll-animate" data-animation="fade-up">
                @if (!empty($section['badge']))
                    <span class="badge badge-primary mb-4">{{ $section['badge'] }}</span>
                @endif

                <h2 class="section-title">
                    <span class="team-hex-title-shape">{{ $section['title'] }}</span>
                </h2>

                @if (!empty($section['subtitle']))
                    <p class="section-subtitle">{{ $section['subtitle'] }}</p>
                @endif
            </div>

            {{-- Team Grid --}}
            <div class="grid sm:grid-cols-2 lg:grid-cols-4 gap-8">
                @foreach ($items as $index => $member)
                    <div class="team-hex-card scroll-animate" data-animation="fade-up"
                        style="animation-delay: {{ $index * 100 }}ms">
                        {{-- Hexagon Image --}}
                        <div class="team-hex-image-wrapper">
                            <div class="team-hex-image-bg"></div>
                            @php
                                $imageUrl = $member['image_url'] ?? ($member['image'] ?? null);
                                $defaultPlaceholder =
                                    'https://ui-avatars.com/api/?name=' .
                                    urlencode($member['name'] ?? 'Team') .
                                    '&size=300&background=random&color=fff&bold=true';
                            @endphp
                            <img src="{{ $imageUrl ?: $defaultPlaceholder }}" alt="{{ $member['name'] ?? '' }}"
                                class="team-hex-image" loading="lazy">
                        </div>

                        {{-- Name --}}
                        <h3 class="team-hex-name">{{ $member['name'] ?? '' }}</h3>

                        {{-- Position --}}
                        @if (!empty($member['position']) || !empty($member['role']))
                            <p class="team-hex-position">{{ $member['position'] ?? $member['role'] }}</p>
                        @endif

                        {{-- Bio --}}
                        @if (!empty($member['bio']))
                            <p class="team-hex-bio line-clamp-2">{{ $member['bio'] }}</p>
                        @endif

                        {{-- Social Links --}}
                        @if (!empty($member['social_links']))
                            <div class="team-hex-social">
                                @foreach ($member['social_links'] as $social)
                                    <a href="{{ $social['url'] ?? '#' }}" target="_blank" rel="noopener">
                                        <x-icon icon="{{ $social['icon'] ?? 'mdi:link' }}" class="w-4 h-4" />
                                    </a>
                                @endforeach
                            </div>
                        @endif
                    </div>
                @endforeach
            </div>
        </div>
    </section>
</div>
