<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(array $section = [], array $items = [], array $company = [], array $social = [], array $services = [], bool $isWhiteBackground = false, ?int $paddingTop = null, ?int $paddingBottom = null)
    {
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        // Default team members
        $defaultItems = [
            [
                'name' => 'Sarah Johnson',
                'position' => 'CEO & Founder',
                'bio' => 'Visionary leader with 15+ years of industry experience.',
                'image' => 'https://randomuser.me/api/portraits/women/44.jpg',
                'social_links' => [['icon' => 'mdi:linkedin', 'url' => '#'], ['icon' => 'mdi:twitter', 'url' => '#']],
            ],
            [
                'name' => 'Michael Chen',
                'position' => 'Operations Director',
                'bio' => 'Expert in streamlining processes and maximizing efficiency.',
                'image' => 'https://randomuser.me/api/portraits/men/32.jpg',
                'social_links' => [['icon' => 'mdi:linkedin', 'url' => '#'], ['icon' => 'mdi:twitter', 'url' => '#']],
            ],
            [
                'name' => 'Emily Rodriguez',
                'position' => 'Customer Success Manager',
                'bio' => 'Dedicated to ensuring exceptional customer experiences.',
                'image' => 'https://randomuser.me/api/portraits/women/68.jpg',
                'social_links' => [['icon' => 'mdi:linkedin', 'url' => '#'], ['icon' => 'mdi:twitter', 'url' => '#']],
            ],
            [
                'name' => 'David Park',
                'position' => 'Technical Lead',
                'bio' => 'Passionate about innovation and cutting-edge solutions.',
                'image' => 'https://randomuser.me/api/portraits/men/75.jpg',
                'social_links' => [['icon' => 'mdi:linkedin', 'url' => '#'], ['icon' => 'mdi:github', 'url' => '#']],
            ],
        ];

        $this->items = !empty($items) ? $items : $defaultItems;

        $this->section = array_merge(
            [
                'badge' => 'Our Team',
                'title' => 'Meet Our Experts',
                'subtitle' => 'The dedicated professionals behind our success, committed to delivering excellence.',
            ],
            $section,
        );
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>

<div>
    <style>
        .team-minimal-card {
            text-align: center;
            padding: 2rem 1rem;
            transition: all 0.3s ease;
            border-radius: 1rem;
            position: relative;
        }

        .team-minimal-card::before {
            content: '';
            position: absolute;
            inset: 0;
            border-radius: 1rem;
            background: linear-gradient(135deg, var(--color-primary-500), var(--color-secondary-500));
            opacity: 0;
            transition: opacity 0.3s ease;
            z-index: 0;
        }

        .team-minimal-card:hover::before {
            opacity: 1;
        }

        .team-minimal-card>* {
            position: relative;
            z-index: 1;
        }

        .team-minimal-card:hover .team-minimal-name,
        .team-minimal-card:hover .team-minimal-position,
        .team-minimal-card:hover .team-minimal-bio {
            color: white;
        }

        .team-minimal-image-container {
            position: relative;
            width: 140px;
            height: 140px;
            margin: 0 auto 1.5rem;
        }

        .team-minimal-image-ring {
            position: absolute;
            inset: -4px;
            border-radius: 50%;
            background: linear-gradient(135deg, var(--color-primary-400), var(--color-secondary-400));
            opacity: 0;
            transition: all 0.3s ease;
        }

        .team-minimal-card:hover .team-minimal-image-ring {
            opacity: 1;
            inset: -6px;
        }

        .team-minimal-image {
            width: 140px;
            height: 140px;
            border-radius: 50%;
            object-fit: cover;
            position: relative;
            z-index: 1;
            border: 4px solid white;
            transition: all 0.3s ease;
        }

        .dark .team-minimal-image {
            border-color: var(--color-gray-800);
        }

        .team-minimal-card:hover .team-minimal-image {
            border-color: white;
        }

        .team-minimal-name {
            font-size: 1.25rem;
            font-weight: 700;
            color: var(--color-gray-900);
            margin-bottom: 0.25rem;
            transition: color 0.3s ease;
        }

        .dark .team-minimal-name {
            color: var(--color-text-primary);
        }

        .team-minimal-position {
            font-size: 0.875rem;
            font-weight: 500;
            color: var(--color-primary-600);
            margin-bottom: 0.75rem;
            transition: color 0.3s ease;
        }

        .dark .team-minimal-position {
            color: var(--color-primary-400);
        }

        .team-minimal-bio {
            font-size: 0.875rem;
            color: var(--color-gray-600);
            line-height: 1.6;
            transition: color 0.3s ease;
        }

        .dark .team-minimal-bio {
            color: var(--color-gray-400);
        }

        .team-minimal-social {
            display: flex;
            justify-content: center;
            gap: 0.5rem;
            margin-top: 1rem;
            opacity: 0;
            transform: translateY(10px);
            transition: all 0.3s ease;
        }

        .team-minimal-card:hover .team-minimal-social {
            opacity: 1;
            transform: translateY(0);
        }

        .team-minimal-social a {
            width: 32px;
            height: 32px;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.2);
            display: inline-flex;
            align-items: center;
            justify-content: center;
            color: white;
            transition: all 0.3s ease;
        }

        .team-minimal-social a:hover {
            background: white;
            color: var(--color-primary-600);
            transform: scale(1.1);
        }

        .team-minimal-divider {
            width: 40px;
            height: 3px;
            background: linear-gradient(90deg, var(--color-primary-500), var(--color-secondary-500));
            margin: 0 auto 1rem;
            border-radius: 2px;
            transition: width 0.3s ease;
        }

        .team-minimal-card:hover .team-minimal-divider {
            width: 60px;
            background: white;
        }
    </style>

    <section id="team"
        class="section {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}"
        @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            {{-- Section Header --}}
            <div class="text-center mb-16 scroll-animate" data-animation="fade-up">
                @if (!empty($section['badge']))
                    <span class="badge badge-primary mb-4">{{ $section['badge'] }}</span>
                @endif
                <h2 class="section-title">{{ $section['title'] }}</h2>
                @if (!empty($section['subtitle']))
                    <p class="section-subtitle">{{ $section['subtitle'] }}</p>
                @endif
            </div>

            {{-- Team Grid --}}
            <div class="grid sm:grid-cols-2 lg:grid-cols-4 gap-6">
                @foreach ($items as $index => $member)
                    <div class="team-minimal-card scroll-animate" data-animation="fade-up"
                        style="animation-delay: {{ $index * 100 }}ms">
                        {{-- Image --}}
                        <div class="team-minimal-image-container">
                            <div class="team-minimal-image-ring"></div>
                            @php
                                $imageUrl = $member['image_url'] ?? ($member['image'] ?? null);
                                $defaultPlaceholder =
                                    'https://ui-avatars.com/api/?name=' .
                                    urlencode($member['name'] ?? 'Team') .
                                    '&size=300&background=random&color=fff&bold=true';
                            @endphp
                            <img src="{{ $imageUrl ?: $defaultPlaceholder }}" alt="{{ $member['name'] ?? '' }}"
                                class="team-minimal-image" loading="lazy">
                        </div>

                        {{-- Divider --}}
                        <div class="team-minimal-divider"></div>

                        {{-- Name --}}
                        <h3 class="team-minimal-name">{{ $member['name'] ?? '' }}</h3>

                        {{-- Position --}}
                        @if (!empty($member['position']) || !empty($member['role']))
                            <p class="team-minimal-position">{{ $member['position'] ?? $member['role'] }}</p>
                        @endif

                        {{-- Bio --}}
                        @if (!empty($member['bio']))
                            <p class="team-minimal-bio line-clamp-2">{{ $member['bio'] }}</p>
                        @endif

                        {{-- Social Links --}}
                        @if (!empty($member['social_links']))
                            <div class="team-minimal-social">
                                @foreach ($member['social_links'] as $social)
                                    <a href="{{ $social['url'] ?? '#' }}" target="_blank" rel="noopener">
                                        <x-icon icon="{{ $social['icon'] ?? 'mdi:link' }}" class="w-4 h-4" />
                                    </a>
                                @endforeach
                            </div>
                        @endif
                    </div>
                @endforeach
            </div>
        </div>
    </section>
</div>
