<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(array $section = [], array $items = [], array $company = [], array $social = [], array $services = [], bool $isWhiteBackground = false, ?int $paddingTop = null, ?int $paddingBottom = null)
    {
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        $defaultItems = [
            [
                'name' => 'Sarah Johnson',
                'position' => 'CEO & Founder',
                'bio' => 'Visionary leader with 15+ years of industry experience.',
                'image' => 'https://randomuser.me/api/portraits/women/44.jpg',
                'social_links' => [['icon' => 'mdi:linkedin', 'url' => '#'], ['icon' => 'mdi:twitter', 'url' => '#']],
            ],
            [
                'name' => 'Michael Chen',
                'position' => 'Operations Director',
                'bio' => 'Expert in streamlining processes and maximizing efficiency.',
                'image' => 'https://randomuser.me/api/portraits/men/32.jpg',
                'social_links' => [['icon' => 'mdi:linkedin', 'url' => '#'], ['icon' => 'mdi:twitter', 'url' => '#']],
            ],
            [
                'name' => 'Emily Rodriguez',
                'position' => 'Customer Success Manager',
                'bio' => 'Dedicated to ensuring exceptional customer experiences.',
                'image' => 'https://randomuser.me/api/portraits/women/68.jpg',
                'social_links' => [['icon' => 'mdi:linkedin', 'url' => '#'], ['icon' => 'mdi:twitter', 'url' => '#']],
            ],
            [
                'name' => 'David Park',
                'position' => 'Technical Lead',
                'bio' => 'Passionate about innovation and cutting-edge solutions.',
                'image' => 'https://randomuser.me/api/portraits/men/75.jpg',
                'social_links' => [['icon' => 'mdi:linkedin', 'url' => '#'], ['icon' => 'mdi:github', 'url' => '#']],
            ],
        ];

        $this->items = !empty($items) ? $items : $defaultItems;

        $this->section = array_merge(
            [
                'badge' => 'Our Team',
                'title' => 'Meet Our Experts',
                'subtitle' => 'The dedicated professionals behind our success, committed to delivering excellence.',
            ],
            $section,
        );
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>

<div>
    <style>
        .team-overlap-container {
            position: relative;
        }

        .team-overlap-bg-shape {
            position: absolute;
            border-radius: 50%;
            filter: blur(80px);
            opacity: 0.15;
            pointer-events: none;
        }

        .team-overlap-bg-shape-1 {
            width: 400px;
            height: 400px;
            background: var(--color-primary-500);
            top: -100px;
            right: 10%;
        }

        .team-overlap-bg-shape-2 {
            width: 300px;
            height: 300px;
            background: var(--color-secondary-500);
            bottom: -50px;
            left: 5%;
        }

        [dir="rtl"] .team-overlap-bg-shape-1 {
            right: auto;
            left: 10%;
        }

        [dir="rtl"] .team-overlap-bg-shape-2 {
            left: auto;
            right: 5%;
        }

        .team-overlap-card {
            position: relative;
            padding-top: 100px;
        }

        .team-overlap-image-wrapper {
            position: absolute;
            top: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 180px;
            height: 180px;
            z-index: 10;
        }

        .team-overlap-image-shape {
            position: absolute;
            inset: 0;
            background: linear-gradient(135deg, var(--color-primary-400), var(--color-secondary-400));
            border-radius: 30% 70% 70% 30% / 30% 30% 70% 70%;
            transition: all 0.5s ease;
            animation: morph-shape 8s ease-in-out infinite;
        }

        @keyframes morph-shape {

            0%,
            100% {
                border-radius: 30% 70% 70% 30% / 30% 30% 70% 70%;
            }

            25% {
                border-radius: 58% 42% 75% 25% / 76% 46% 54% 24%;
            }

            50% {
                border-radius: 50% 50% 33% 67% / 55% 27% 73% 45%;
            }

            75% {
                border-radius: 33% 67% 58% 42% / 63% 68% 32% 37%;
            }
        }

        .team-overlap-card:hover .team-overlap-image-shape {
            transform: scale(1.05) rotate(5deg);
        }

        .team-overlap-image {
            position: absolute;
            inset: 8px;
            object-fit: cover;
            border-radius: 30% 70% 70% 30% / 30% 30% 70% 70%;
            transition: all 0.5s ease;
            animation: morph-shape 8s ease-in-out infinite;
        }

        .team-overlap-content {
            background: white;
            border-radius: 1.5rem;
            padding: 100px 1.5rem 2rem;
            text-align: center;
            position: relative;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.08);
            transition: all 0.3s ease;
        }

        .dark .team-overlap-content {
            background: var(--color-card-bg);
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.3);
        }

        .team-overlap-card:hover .team-overlap-content {
            transform: translateY(-5px);
            box-shadow: 0 20px 50px rgba(0, 0, 0, 0.12);
        }

        .dark .team-overlap-card:hover .team-overlap-content {
            box-shadow: 0 20px 50px rgba(0, 0, 0, 0.4);
        }

        .team-overlap-content::before {
            content: '';
            position: absolute;
            top: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 60px;
            height: 4px;
            background: linear-gradient(90deg, var(--color-primary-500), var(--color-secondary-500));
            border-radius: 0 0 4px 4px;
        }

        .team-overlap-corner {
            position: absolute;
            width: 60px;
            height: 60px;
            opacity: 0.1;
        }

        .team-overlap-corner-tl {
            top: 1rem;
            left: 1rem;
            border-top: 3px solid var(--color-primary-500);
            border-left: 3px solid var(--color-primary-500);
            border-radius: 0.5rem 0 0 0;
        }

        .team-overlap-corner-br {
            bottom: 1rem;
            right: 1rem;
            border-bottom: 3px solid var(--color-secondary-500);
            border-right: 3px solid var(--color-secondary-500);
            border-radius: 0 0 0.5rem 0;
        }

        [dir="rtl"] .team-overlap-corner-tl {
            left: auto;
            right: 1rem;
            border-left: none;
            border-right: 3px solid var(--color-primary-500);
            border-radius: 0 0.5rem 0 0;
        }

        [dir="rtl"] .team-overlap-corner-br {
            right: auto;
            left: 1rem;
            border-right: none;
            border-left: 3px solid var(--color-secondary-500);
            border-radius: 0 0 0 0.5rem;
        }

        .team-overlap-name {
            font-size: 1.25rem;
            font-weight: 700;
            color: var(--color-gray-900);
            margin-bottom: 0.25rem;
        }

        .dark .team-overlap-name {
            color: var(--color-text-primary);
        }

        .team-overlap-position {
            font-size: 0.875rem;
            font-weight: 600;
            background: linear-gradient(135deg, var(--color-primary-600), var(--color-secondary-600));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            margin-bottom: 0.75rem;
        }

        .team-overlap-bio {
            font-size: 0.875rem;
            color: var(--color-gray-600);
            line-height: 1.6;
            margin-bottom: 1rem;
        }

        .dark .team-overlap-bio {
            color: var(--color-gray-400);
        }

        .team-overlap-social {
            display: flex;
            justify-content: center;
            gap: 0.5rem;
        }

        .team-overlap-social a {
            width: 36px;
            height: 36px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            border-radius: 50%;
            background: linear-gradient(135deg, var(--color-primary-50), var(--color-secondary-50));
            color: var(--color-primary-600);
            transition: all 0.3s ease;
        }

        .dark .team-overlap-social a {
            background: linear-gradient(135deg, var(--color-primary-900)/50, var(--color-secondary-900)/50);
            color: var(--color-primary-400);
        }

        .team-overlap-social a:hover {
            background: linear-gradient(135deg, var(--color-primary-500), var(--color-secondary-500));
            color: white;
            transform: translateY(-3px) scale(1.1);
        }

        .team-overlap-header-shapes {
            position: relative;
            display: inline-block;
        }

        .team-overlap-header-shapes::before {
            content: '';
            position: absolute;
            top: -20px;
            left: -40px;
            width: 30px;
            height: 30px;
            border: 3px solid var(--color-primary-300);
            border-radius: 50%;
            opacity: 0.5;
        }

        .team-overlap-header-shapes::after {
            content: '';
            position: absolute;
            bottom: -15px;
            right: -35px;
            width: 20px;
            height: 20px;
            background: var(--color-secondary-400);
            border-radius: 4px;
            transform: rotate(45deg);
            opacity: 0.3;
        }

        @media (max-width: 640px) {

            .team-overlap-header-shapes::before,
            .team-overlap-header-shapes::after {
                display: none;
            }
        }
    </style>

    <section id="team"
        class="section {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}"
        @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
        <div class="team-overlap-container max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            {{-- Background Shapes --}}
            <div class="team-overlap-bg-shape team-overlap-bg-shape-1"></div>
            <div class="team-overlap-bg-shape team-overlap-bg-shape-2"></div>

            {{-- Section Header --}}
            <div class="text-center mb-20 scroll-animate relative z-10" data-animation="fade-up">
                @if (!empty($section['badge']))
                    <span class="badge badge-primary mb-4">{{ $section['badge'] }}</span>
                @endif

                <h2 class="section-title">
                    <span class="team-overlap-header-shapes">{{ $section['title'] }}</span>
                </h2>

                @if (!empty($section['subtitle']))
                    <p class="section-subtitle">{{ $section['subtitle'] }}</p>
                @endif
            </div>

            {{-- Team Grid --}}
            <div class="grid sm:grid-cols-2 lg:grid-cols-4 gap-8 relative z-10">
                @foreach ($items as $index => $member)
                    <div class="team-overlap-card scroll-animate" data-animation="fade-up"
                        style="animation-delay: {{ $index * 150 }}ms">
                        {{-- Morphing Image --}}
                        <div class="team-overlap-image-wrapper">
                            <div class="team-overlap-image-shape" style="animation-delay: {{ $index * 0.5 }}s"></div>
                            @php
                                $imageUrl = $member['image_url'] ?? ($member['image'] ?? null);
                                $defaultPlaceholder =
                                    'https://ui-avatars.com/api/?name=' .
                                    urlencode($member['name'] ?? 'Team') .
                                    '&size=300&background=random&color=fff&bold=true';
                            @endphp
                            <img src="{{ $imageUrl ?: $defaultPlaceholder }}" alt="{{ $member['name'] ?? '' }}"
                                class="team-overlap-image" style="animation-delay: {{ $index * 0.5 }}s" loading="lazy">
                        </div>

                        {{-- Content Card --}}
                        <div class="team-overlap-content">
                            <div class="team-overlap-corner team-overlap-corner-tl"></div>
                            <div class="team-overlap-corner team-overlap-corner-br"></div>

                            <h3 class="team-overlap-name">{{ $member['name'] ?? '' }}</h3>

                            @if (!empty($member['position']) || !empty($member['role']))
                                <p class="team-overlap-position">{{ $member['position'] ?? $member['role'] }}</p>
                            @endif

                            @if (!empty($member['bio']))
                                <p class="team-overlap-bio line-clamp-2">{{ $member['bio'] }}</p>
                            @endif

                            @if (!empty($member['social_links']))
                                <div class="team-overlap-social">
                                    @foreach ($member['social_links'] as $social)
                                        <a href="{{ $social['url'] ?? '#' }}" target="_blank" rel="noopener">
                                            <x-icon icon="{{ $social['icon'] ?? 'mdi:link' }}" class="w-4 h-4" />
                                        </a>
                                    @endforeach
                                </div>
                            @endif
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </section>
</div>
