<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(array $section = [], array $items = [], array $company = [], array $social = [], array $services = [], bool $isWhiteBackground = false, ?int $paddingTop = null, ?int $paddingBottom = null)
    {
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        $defaultItems = [
            [
                'name' => 'Sarah Johnson',
                'position' => 'CEO & Founder',
                'bio' => 'Visionary leader with 15+ years of industry experience.',
                'image' => 'https://randomuser.me/api/portraits/women/44.jpg',
                'social_links' => [['icon' => 'mdi:linkedin', 'url' => '#'], ['icon' => 'mdi:twitter', 'url' => '#']],
            ],
            [
                'name' => 'Michael Chen',
                'position' => 'Operations Director',
                'bio' => 'Expert in streamlining processes and maximizing efficiency.',
                'image' => 'https://randomuser.me/api/portraits/men/32.jpg',
                'social_links' => [['icon' => 'mdi:linkedin', 'url' => '#'], ['icon' => 'mdi:twitter', 'url' => '#']],
            ],
            [
                'name' => 'Emily Rodriguez',
                'position' => 'Customer Success Manager',
                'bio' => 'Dedicated to ensuring exceptional customer experiences.',
                'image' => 'https://randomuser.me/api/portraits/women/68.jpg',
                'social_links' => [['icon' => 'mdi:linkedin', 'url' => '#'], ['icon' => 'mdi:twitter', 'url' => '#']],
            ],
            [
                'name' => 'David Park',
                'position' => 'Technical Lead',
                'bio' => 'Passionate about innovation and cutting-edge solutions.',
                'image' => 'https://randomuser.me/api/portraits/men/75.jpg',
                'social_links' => [['icon' => 'mdi:linkedin', 'url' => '#'], ['icon' => 'mdi:github', 'url' => '#']],
            ],
        ];

        $this->items = !empty($items) ? $items : $defaultItems;

        $this->section = array_merge(
            [
                'badge' => 'Our Team',
                'title' => 'Meet Our Experts',
                'subtitle' => 'The dedicated professionals behind our success, committed to delivering excellence.',
            ],
            $section,
        );
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>

<div>
    <style>
        .team-split-container {
            position: relative;
        }

        .team-split-left {
            position: relative;
            z-index: 1;
        }

        .team-split-shapes {
            position: absolute;
            inset: 0;
            overflow: hidden;
            pointer-events: none;
        }

        .team-split-circle {
            position: absolute;
            border-radius: 50%;
            background: linear-gradient(135deg, var(--color-primary-500), var(--color-secondary-500));
            opacity: 0.1;
        }

        .team-split-circle-1 {
            width: 300px;
            height: 300px;
            top: -100px;
            left: -100px;
        }

        .team-split-circle-2 {
            width: 200px;
            height: 200px;
            bottom: -50px;
            left: 50%;
            transform: translateX(-50%);
        }

        [dir="rtl"] .team-split-circle-1 {
            left: auto;
            right: -100px;
        }

        .team-split-dots {
            position: absolute;
            width: 120px;
            height: 120px;
            bottom: 20%;
            left: 10%;
            background-image: radial-gradient(var(--color-primary-400) 2px, transparent 2px);
            background-size: 15px 15px;
            opacity: 0.3;
        }

        [dir="rtl"] .team-split-dots {
            left: auto;
            right: 10%;
        }

        .team-split-title-decoration {
            position: relative;
            display: inline-block;
        }

        .team-split-title-decoration::after {
            content: '';
            position: absolute;
            bottom: -10px;
            left: 0;
            width: 80px;
            height: 4px;
            background: linear-gradient(90deg, var(--color-primary-500), var(--color-secondary-500));
            border-radius: 2px;
        }

        [dir="rtl"] .team-split-title-decoration::after {
            left: auto;
            right: 0;
        }

        .team-split-card {
            position: relative;
            background: white;
            border-radius: 1rem;
            overflow: hidden;
            transition: all 0.4s ease;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
        }

        .dark .team-split-card {
            background: var(--color-card-bg);
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.3);
        }

        .team-split-card:hover {
            transform: translateY(-8px);
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
        }

        .dark .team-split-card:hover {
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.4);
        }

        .team-split-card-shape {
            position: absolute;
            top: 0;
            right: 0;
            width: 60px;
            height: 60px;
            background: linear-gradient(135deg, var(--color-primary-100), var(--color-secondary-100));
            border-radius: 0 0 0 100%;
            transition: all 0.3s ease;
        }

        .dark .team-split-card-shape {
            background: linear-gradient(135deg, var(--color-primary-900), var(--color-secondary-900));
        }

        [dir="rtl"] .team-split-card-shape {
            right: auto;
            left: 0;
            border-radius: 0 0 100% 0;
        }

        .team-split-card:hover .team-split-card-shape {
            width: 80px;
            height: 80px;
            background: linear-gradient(135deg, var(--color-primary-500), var(--color-secondary-500));
        }

        .team-split-image-wrapper {
            position: relative;
            padding: 1rem 1rem 0;
            z-index: 1;
        }

        .team-split-image {
            width: 100%;
            aspect-ratio: 4/3;
            object-fit: cover;
            border-radius: 0.5rem;
            transition: transform 0.3s ease;
        }

        .team-split-card:hover .team-split-image {
            transform: scale(1.03);
        }

        .team-split-content {
            padding: 1rem;
            position: relative;
            z-index: 1;
        }

        .team-split-social {
            display: flex;
            gap: 0.375rem;
            margin-top: 0.75rem;
        }

        .team-split-social a {
            width: 28px;
            height: 28px;
            border-radius: 50%;
            background: var(--color-gray-100);
            display: inline-flex;
            align-items: center;
            justify-content: center;
            color: var(--color-gray-600);
            transition: all 0.3s ease;
        }

        .dark .team-split-social a {
            background: var(--color-gray-700);
            color: var(--color-gray-300);
        }

        .team-split-social a:hover {
            background: var(--color-primary-500);
            color: white;
            transform: translateY(-3px);
        }

        .team-split-stat {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 1rem;
            background: linear-gradient(135deg, var(--color-primary-50), var(--color-secondary-50));
            border-radius: 0.75rem;
            margin-top: 1.5rem;
        }

        .dark .team-split-stat {
            background: linear-gradient(135deg, var(--color-primary-900)/30, var(--color-secondary-900)/30);
        }

        .team-split-stat-icon {
            width: 48px;
            height: 48px;
            border-radius: 50%;
            background: linear-gradient(135deg, var(--color-primary-500), var(--color-secondary-500));
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
        }
    </style>


    <section id="team"
        class="section {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}"
        @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
        <div class="team-split-container max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            {{-- Background Shapes --}}
            <div class="team-split-shapes">
                <div class="team-split-circle team-split-circle-1"></div>
                <div class="team-split-circle team-split-circle-2"></div>
                <div class="team-split-dots"></div>
            </div>

            <div class="grid lg:grid-cols-12 gap-12 items-start">
                {{-- Left Side - Title & Description --}}
                <div class="lg:col-span-4 team-split-left scroll-animate" data-animation="fade-up">
                    <div class="lg:sticky lg:top-32">
                        @if (!empty($section['badge']))
                            <span class="badge badge-primary mb-4">{{ $section['badge'] }}</span>
                        @endif

                        <h2 class="team-split-title-decoration section-title text-start mb-6">
                            {{ $section['title'] }}
                        </h2>

                        @if (!empty($section['subtitle']))
                            <p class="text-gray-600 dark:text-gray-400 text-lg leading-relaxed mb-8">
                                {{ $section['subtitle'] }}
                            </p>
                        @endif

                        {{-- Stats --}}
                        <div class="team-split-stat">
                            <div class="team-split-stat-icon">
                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z" />
                                </svg>
                            </div>
                            <div>
                                <p class="text-2xl font-bold text-gray-900 dark:text-white">{{ count($items) }}+</p>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Right Side - Team Grid --}}
                <div class="lg:col-span-8">
                    <div class="grid sm:grid-cols-2 gap-6">
                        @foreach ($items as $index => $member)
                            <div class="team-split-card scroll-animate" data-animation="fade-up"
                                style="animation-delay: {{ $index * 100 }}ms">
                                <div class="team-split-card-shape"></div>

                                {{-- Image --}}
                                <div class="team-split-image-wrapper">
                                    @php
                                        $imageUrl = $member['image_url'] ?? ($member['image'] ?? null);
                                        $defaultPlaceholder =
                                            'https://ui-avatars.com/api/?name=' .
                                            urlencode($member['name'] ?? 'Team') .
                                            '&size=300&background=random&color=fff&bold=true';
                                    @endphp
                                    <img src="{{ $imageUrl ?: $defaultPlaceholder }}" alt="{{ $member['name'] ?? '' }}"
                                        class="team-split-image" loading="lazy">
                                </div>

                                {{-- Content --}}
                                <div class="team-split-content">
                                    <h3 class="text-lg font-bold text-gray-900 dark:text-white mb-1">
                                        {{ $member['name'] ?? '' }}
                                    </h3>

                                    @if (!empty($member['position']) || !empty($member['role']))
                                        <p class="text-primary-600 dark:text-primary-400 text-sm font-medium mb-2">
                                            {{ $member['position'] ?? $member['role'] }}
                                        </p>
                                    @endif

                                    @if (!empty($member['bio']))
                                        <p class="text-gray-600 dark:text-gray-400 text-sm line-clamp-2">
                                            {{ $member['bio'] }}
                                        </p>
                                    @endif

                                    @if (!empty($member['social_links']))
                                        <div class="team-split-social">
                                            @foreach ($member['social_links'] as $social)
                                                <a href="{{ $social['url'] ?? '#' }}" target="_blank" rel="noopener">
                                                    <x-icon icon="{{ $social['icon'] ?? 'mdi:link' }}"
                                                        class="w-4 h-4" />
                                                </a>
                                            @endforeach
                                        </div>
                                    @endif
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
