<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(array $section = [], array $items = [], array $company = [], array $social = [], array $services = [], bool $isWhiteBackground = false, ?int $paddingTop = null, ?int $paddingBottom = null)
    {
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        $defaultItems = [
            [
                'name' => 'Sarah Johnson',
                'position' => 'CEO & Founder',
                'bio' => 'Visionary leader with 15+ years of industry experience.',
                'image' => 'https://randomuser.me/api/portraits/women/44.jpg',
                'social_links' => [['icon' => 'mdi:linkedin', 'url' => '#'], ['icon' => 'mdi:twitter', 'url' => '#']],
            ],
            [
                'name' => 'Michael Chen',
                'position' => 'Operations Director',
                'bio' => 'Expert in streamlining processes and maximizing efficiency.',
                'image' => 'https://randomuser.me/api/portraits/men/32.jpg',
                'social_links' => [['icon' => 'mdi:linkedin', 'url' => '#'], ['icon' => 'mdi:twitter', 'url' => '#']],
            ],
            [
                'name' => 'Emily Rodriguez',
                'position' => 'Customer Success Manager',
                'bio' => 'Dedicated to ensuring exceptional customer experiences.',
                'image' => 'https://randomuser.me/api/portraits/women/68.jpg',
                'social_links' => [['icon' => 'mdi:linkedin', 'url' => '#'], ['icon' => 'mdi:twitter', 'url' => '#']],
            ],
            [
                'name' => 'David Park',
                'position' => 'Technical Lead',
                'bio' => 'Passionate about innovation and cutting-edge solutions.',
                'image' => 'https://randomuser.me/api/portraits/men/75.jpg',
                'social_links' => [['icon' => 'mdi:linkedin', 'url' => '#'], ['icon' => 'mdi:github', 'url' => '#']],
            ],
        ];

        $this->items = !empty($items) ? $items : $defaultItems;

        $this->section = array_merge(
            [
                'badge' => 'Our Team',
                'title' => 'Meet Our Experts',
                'subtitle' => 'The dedicated professionals behind our success, committed to delivering excellence.',
            ],
            $section,
        );
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>

<div>
    <style>
        .team-wave-section {
            position: relative;
            overflow: hidden;
        }

        .team-wave-bg {
            position: absolute;
            left: 0;
            right: 0;
            height: 60%;
            bottom: 0;
            background: linear-gradient(135deg, var(--color-primary-600), var(--color-secondary-600));
        }

        .team-wave-svg {
            position: absolute;
            top: -1px;
            left: 0;
            right: 0;
            width: 100%;
            height: 150px;
            transform: scaleY(-1);
        }

        .team-wave-svg path {
            fill: var(--color-bg-secondary);
        }

        .dark .team-wave-svg path {
            fill: var(--color-bg-secondary);
        }

        .team-wave-white .team-wave-svg path {
            fill: white;
        }

        .dark .team-wave-white .team-wave-svg path {
            fill: var(--color-bg-primary);
        }

        .team-wave-particles {
            position: absolute;
            inset: 0;
            overflow: hidden;
            pointer-events: none;
        }

        .team-wave-particle {
            position: absolute;
            width: 10px;
            height: 10px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
            animation: float-particle 15s infinite ease-in-out;
        }

        @keyframes float-particle {

            0%,
            100% {
                transform: translateY(0) translateX(0);
                opacity: 0;
            }

            10% {
                opacity: 1;
            }

            90% {
                opacity: 1;
            }

            100% {
                transform: translateY(-500px) translateX(100px);
                opacity: 0;
            }
        }

        .team-wave-card {
            position: relative;
            background: white;
            border-radius: 1.5rem;
            overflow: hidden;
            box-shadow: 0 20px 50px rgba(0, 0, 0, 0.15);
            transition: all 0.4s ease;
        }

        .dark .team-wave-card {
            background: var(--color-card-bg);
            box-shadow: 0 20px 50px rgba(0, 0, 0, 0.4);
        }

        .team-wave-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 30px 60px rgba(0, 0, 0, 0.2);
        }

        .dark .team-wave-card:hover {
            box-shadow: 0 30px 60px rgba(0, 0, 0, 0.5);
        }

        .team-wave-card-wave {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 120px;
            background: linear-gradient(135deg, var(--color-primary-500), var(--color-secondary-500));
        }

        .team-wave-card-wave svg {
            position: absolute;
            bottom: -1px;
            left: 0;
            right: 0;
            width: 100%;
            height: 40px;
        }

        .team-wave-card-wave svg path {
            fill: white;
        }

        .dark .team-wave-card-wave svg path {
            fill: var(--color-card-bg);
        }

        .team-wave-image-wrapper {
            position: relative;
            z-index: 10;
            padding-top: 60px;
            display: flex;
            justify-content: center;
        }

        .team-wave-image {
            width: 130px;
            height: 130px;
            border-radius: 50%;
            object-fit: cover;
            border: 5px solid white;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
            transition: all 0.3s ease;
        }

        .dark .team-wave-image {
            border-color: var(--color-card-bg);
        }

        .team-wave-card:hover .team-wave-image {
            transform: scale(1.05);
            box-shadow: 0 15px 40px rgba(0, 0, 0, 0.2);
        }

        .team-wave-content {
            padding: 1.5rem 1.5rem 2rem;
            text-align: center;
        }

        .team-wave-name {
            font-size: 1.25rem;
            font-weight: 700;
            color: var(--color-gray-900);
            margin-bottom: 0.25rem;
        }

        .dark .team-wave-name {
            color: var(--color-text-primary);
        }

        .team-wave-position {
            font-size: 0.875rem;
            font-weight: 500;
            color: var(--color-primary-600);
            margin-bottom: 0.75rem;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
        }

        .dark .team-wave-position {
            color: var(--color-primary-400);
        }

        .team-wave-position::before,
        .team-wave-position::after {
            content: '';
            width: 30px;
            height: 1px;
            background: linear-gradient(90deg, transparent, var(--color-primary-300), transparent);
        }

        .team-wave-bio {
            font-size: 0.875rem;
            color: var(--color-gray-600);
            line-height: 1.6;
            margin-bottom: 1rem;
        }

        .dark .team-wave-bio {
            color: var(--color-gray-400);
        }

        .team-wave-social {
            display: flex;
            justify-content: center;
            gap: 0.5rem;
        }

        .team-wave-social a {
            width: 36px;
            height: 36px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            border-radius: 50%;
            background: var(--color-gray-100);
            color: var(--color-gray-600);
            transition: all 0.3s ease;
        }

        .dark .team-wave-social a {
            background: var(--color-gray-700);
            color: var(--color-gray-300);
        }

        .team-wave-social a:hover {
            background: linear-gradient(135deg, var(--color-primary-500), var(--color-secondary-500));
            color: white;
            transform: translateY(-3px);
        }

        .team-wave-header {
            position: relative;
            z-index: 10;
        }

        .team-wave-title-underline {
            position: relative;
            display: inline-block;
        }

        .team-wave-title-underline::after {
            content: '';
            position: absolute;
            bottom: -8px;
            left: 50%;
            transform: translateX(-50%);
            width: 100px;
            height: 4px;
            background: linear-gradient(90deg, var(--color-primary-500), var(--color-secondary-500));
            border-radius: 2px;
        }

        .team-wave-grid {
            position: relative;
            z-index: 10;
        }

        .team-wave-floating-shape {
            position: absolute;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.1);
            pointer-events: none;
        }

        .team-wave-floating-shape-1 {
            width: 100px;
            height: 100px;
            bottom: 20%;
            left: 5%;
            animation: float 6s ease-in-out infinite;
        }

        .team-wave-floating-shape-2 {
            width: 60px;
            height: 60px;
            bottom: 40%;
            right: 8%;
            animation: float 8s ease-in-out infinite reverse;
        }

        [dir="rtl"] .team-wave-floating-shape-1 {
            left: auto;
            right: 5%;
        }

        [dir="rtl"] .team-wave-floating-shape-2 {
            right: auto;
            left: 8%;
        }
    </style>


    <section id="team"
        class="team-wave-section section {{ $isWhiteBackground ? 'team-wave-white bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}"
        @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
        {{-- Wave Background --}}
        <div class="team-wave-bg">
            <svg class="team-wave-svg" viewBox="0 0 1440 150" preserveAspectRatio="none">
                <path d="M0,64 C288,120 576,0 864,64 C1152,128 1440,32 1440,32 L1440,150 L0,150 Z"></path>
            </svg>
            {{-- Floating Shapes --}}
            <div class="team-wave-floating-shape team-wave-floating-shape-1"></div>
            <div class="team-wave-floating-shape team-wave-floating-shape-2"></div>
            {{-- Particles --}}
            <div class="team-wave-particles">
                @for ($i = 0; $i < 10; $i++)
                    <div class="team-wave-particle"
                        style="left: {{ rand(5, 95) }}%; bottom: {{ rand(5, 30) }}%; animation-delay: {{ $i * 1.5 }}s; animation-duration: {{ rand(12, 20) }}s;">
                    </div>
                @endfor
            </div>
        </div>

        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            {{-- Section Header --}}
            <div class="team-wave-header text-center mb-16 scroll-animate" data-animation="fade-up">
                @if (!empty($section['badge']))
                    <span class="badge badge-primary mb-4">{{ $section['badge'] }}</span>
                @endif

                <h2 class="section-title">
                    <span class="team-wave-title-underline">{{ $section['title'] }}</span>
                </h2>

                @if (!empty($section['subtitle']))
                    <p class="section-subtitle">{{ $section['subtitle'] }}</p>
                @endif
            </div>

            {{-- Team Grid --}}
            <div class="team-wave-grid grid sm:grid-cols-2 lg:grid-cols-4 gap-8">
                @foreach ($items as $index => $member)
                    <div class="team-wave-card scroll-animate" data-animation="fade-up"
                        style="animation-delay: {{ $index * 100 }}ms">
                        {{-- Card Wave --}}
                        <div class="team-wave-card-wave">
                            <svg viewBox="0 0 500 50" preserveAspectRatio="none">
                                <path d="M0,25 C125,50 250,0 375,25 C437.5,37.5 468.75,31.25 500,25 L500,50 L0,50 Z">
                                </path>
                            </svg>
                        </div>

                        {{-- Image --}}
                        <div class="team-wave-image-wrapper">
                            @php
                                $imageUrl = $member['image_url'] ?? ($member['image'] ?? null);
                                $defaultPlaceholder =
                                    'https://ui-avatars.com/api/?name=' .
                                    urlencode($member['name'] ?? 'Team') .
                                    '&size=300&background=random&color=fff&bold=true';
                            @endphp
                            <img src="{{ $imageUrl ?: $defaultPlaceholder }}" alt="{{ $member['name'] ?? '' }}"
                                class="team-wave-image" loading="lazy">
                        </div>

                        {{-- Content --}}
                        <div class="team-wave-content">
                            <h3 class="team-wave-name">{{ $member['name'] ?? '' }}</h3>

                            @if (!empty($member['position']) || !empty($member['role']))
                                <p class="team-wave-position">{{ $member['position'] ?? $member['role'] }}</p>
                            @endif

                            @if (!empty($member['bio']))
                                <p class="team-wave-bio line-clamp-2">{{ $member['bio'] }}</p>
                            @endif

                            @if (!empty($member['social_links']))
                                <div class="team-wave-social">
                                    @foreach ($member['social_links'] as $social)
                                        <a href="{{ $social['url'] ?? '#' }}" target="_blank" rel="noopener">
                                            <x-icon icon="{{ $social['icon'] ?? 'mdi:link' }}" class="w-4 h-4" />
                                        </a>
                                    @endforeach
                                </div>
                            @endif
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </section>
</div>
