<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(
        array $section = [],
        array $items = [],
        array $company = [],
        array $social = [],
        array $services = [],
        bool $isWhiteBackground = false,
        ?int $paddingTop = null,
        ?int $paddingBottom = null
    ) {
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        // Default team members with placeholder images
        $defaultItems = [
            [
                'name' => 'Sarah Johnson',
                'position' => 'CEO & Founder',
                'bio' => 'Visionary leader with 15+ years of industry experience.',
                'image' => 'https://randomuser.me/api/portraits/women/44.jpg',
                'social_links' => [
                    ['icon' => 'mdi:linkedin', 'url' => '#'],
                    ['icon' => 'mdi:twitter', 'url' => '#'],
                ]
            ],
            [
                'name' => 'Michael Chen',
                'position' => 'Operations Director',
                'bio' => 'Expert in streamlining processes and maximizing efficiency.',
                'image' => 'https://randomuser.me/api/portraits/men/32.jpg',
                'social_links' => [
                    ['icon' => 'mdi:linkedin', 'url' => '#'],
                    ['icon' => 'mdi:twitter', 'url' => '#'],
                ]
            ],
            [
                'name' => 'Emily Rodriguez',
                'position' => 'Customer Success Manager',
                'bio' => 'Dedicated to ensuring exceptional customer experiences.',
                'image' => 'https://randomuser.me/api/portraits/women/68.jpg',
                'social_links' => [
                    ['icon' => 'mdi:linkedin', 'url' => '#'],
                    ['icon' => 'mdi:twitter', 'url' => '#'],
                ]
            ],
            [
                'name' => 'David Park',
                'position' => 'Technical Lead',
                'bio' => 'Passionate about innovation and cutting-edge solutions.',
                'image' => 'https://randomuser.me/api/portraits/men/75.jpg',
                'social_links' => [
                    ['icon' => 'mdi:linkedin', 'url' => '#'],
                    ['icon' => 'mdi:github', 'url' => '#'],
                ]
            ],
        ];

        $this->items = !empty($items) ? $items : $defaultItems;

        $this->section = array_merge([
            'badge' => 'Our Team',
            'title' => 'Meet Our Experts',
            'subtitle' => 'The dedicated professionals behind our success, committed to delivering excellence.',
        ], $section);
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>

<div>
<section id="team" class="section {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {{-- Section Header --}}
        <div class="text-center mb-16">
            <span class="badge badge-primary mb-4">{{ $section['badge'] }}</span>
            <h2 class="section-title">{{ $section['title'] }}</h2>
            <p class="section-subtitle">{{ $section['subtitle'] }}</p>
        </div>

        {{-- Team Grid --}}
        <div class="grid sm:grid-cols-2 lg:grid-cols-4 gap-8">
            @foreach($items as $index => $member)
            <div class="team-card bg-white dark:bg-gray-800 rounded-2xl shadow-lg overflow-hidden scroll-animate" data-animation="fade-up" style="animation-delay: {{ $index * 100 }}ms">
                {{-- Member Image --}}
                <div class="team-image relative aspect-square">
                    @php
                        $imageUrl = $member['image_url'] ?? $member['image'] ?? null;
                        $defaultPlaceholder = 'https://ui-avatars.com/api/?name=' . urlencode($member['name'] ?? 'Team') . '&size=300&background=random&color=fff&bold=true';
                    @endphp
                    <img src="{{ $imageUrl ?: $defaultPlaceholder }}" alt="{{ $member['name'] ?? '' }}" class="w-full h-full object-cover" loading="lazy">

                    {{-- Social Links Overlay --}}
                    @if(!empty($member['social_links']))
                    <div class="team-social absolute bottom-0 left-0 right-0 p-4 bg-gradient-to-t from-black/80 to-transparent">
                        <div class="flex justify-center gap-3">
                            @foreach($member['social_links'] as $social)
                            <a href="{{ $social['url'] ?? '#' }}" target="_blank" rel="noopener" class="w-9 h-9 rounded-full bg-white/20 hover:bg-primary-500 flex items-center justify-center text-white transition-colors">
                                <x-icon icon="{{ $social['icon'] ?? 'mdi:link' }}" class="w-4 h-4" />
                            </a>
                            @endforeach
                        </div>
                    </div>
                    @endif
                </div>

                {{-- Member Info --}}
                <div class="p-6 text-center">
                    <h3 class="text-lg font-bold text-gray-900 dark:text-white mb-1">
                        {{ $member['name'] ?? '' }}
                    </h3>
                    @if(!empty($member['position']) || !empty($member['role']))
                    <p class="text-primary-600 dark:text-primary-400 text-sm font-semibold mb-2">
                        {{ $member['position'] ?? $member['role'] }}
                    </p>
                    @endif
                    @if(!empty($member['bio']))
                    <p class="text-gray-600 dark:text-gray-400 text-sm line-clamp-2">
                        {{ $member['bio'] }}
                    </p>
                    @endif
                </div>
            </div>
            @endforeach
        </div>
    </div>
</section>

<style>
    .team-card {
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }
    .team-card:hover {
        transform: translateY(-10px);
        box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.15);
    }
    .team-card:hover .team-image img {
        transform: scale(1.05);
    }
    .team-image {
        overflow: hidden;
    }
    .team-image img {
        transition: transform 0.5s ease;
    }
    .team-social {
        opacity: 0;
        transform: translateY(20px);
        transition: all 0.3s ease;
    }
    .team-card:hover .team-social {
        opacity: 1;
        transform: translateY(0);
    }
    .team-social a:hover {
        background: var(--color-primary-500) !important;
    }
</style>
</div>
