<?php

use Livewire\Component;

new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(
        array $section = [],
        array $items = [],
        array $company = [],
        array $social = [],
        array $services = [],
        bool $isWhiteBackground = false,
        ?int $paddingTop = null,
        ?int $paddingBottom = null
    ) {
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        // Default timeline items
        $defaultItems = [
            [
                'year' => '2020',
                'title' => 'Company Founded',
                'description' => 'Started with a vision to transform the industry and deliver exceptional value.',
                'icon' => 'heroicons:rocket-launch',
            ],
            [
                'year' => '2021',
                'title' => 'First Major Milestone',
                'description' => 'Reached 1,000 customers and expanded our service offerings.',
                'icon' => 'heroicons:flag',
            ],
            [
                'year' => '2022',
                'title' => 'National Expansion',
                'description' => 'Expanded operations to 10 new cities across the country.',
                'icon' => 'heroicons:globe-americas',
            ],
            [
                'year' => '2023',
                'title' => 'Industry Recognition',
                'description' => 'Received multiple awards for excellence and innovation.',
                'icon' => 'heroicons:trophy',
            ],
            [
                'year' => '2024',
                'title' => 'Continued Growth',
                'description' => 'Serving over 50,000 customers with 99% satisfaction rate.',
                'icon' => 'heroicons:chart-bar',
            ],
        ];

        $this->items = !empty($items) ? $items : $defaultItems;

        $this->section = array_merge([
            'title' => 'Our Journey',
            'subtitle' => 'Milestones that define us',
            'badge' => 'Timeline',
        ], $section);
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }
};
?>

<div>
<section id="timeline" class="section {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Section Header -->
        <div class="text-center mb-16 scroll-animate" data-animation="fade-up">
            @if(!empty($section['badge']))
            <span class="badge badge-primary mb-4">
                {{ $section['badge'] }}
            </span>
            @endif

            <h2 class="section-title">
                {{ $section['title'] }}
            </h2>

            @if(!empty($section['subtitle']))
            <p class="section-subtitle">
                {{ $section['subtitle'] }}
            </p>
            @endif
        </div>

        <!-- Timeline -->
        @if(count($items) > 0)
        <div class="timeline-container relative">
            <div class="timeline-line"></div>

            <div class="space-y-12">
                @foreach($items as $index => $item)
                <div class="timeline-item relative scroll-animate" data-animation="{{ $index % 2 === 0 ? 'fade-right' : 'fade-left' }}" style="animation-delay: {{ $index * 150 }}ms">
                    <div class="timeline-dot" style="top: 2rem;"></div>

                    <div class="grid md:grid-cols-2 gap-8 items-center {{ $index % 2 === 0 ? '' : 'md:flex-row-reverse' }}">
                        <!-- Year/Date Side -->
                        <div class="md:text-{{ $index % 2 === 0 ? 'right' : 'left' }} {{ $index % 2 === 0 ? 'md:pr-12' : 'md:pl-12 md:order-2' }} pl-12 md:pl-0">
                            <span class="inline-block text-3xl md:text-4xl font-bold text-primary-600 dark:text-primary-400">
                                {{ $item['year'] ?? '' }}
                            </span>
                        </div>

                        <!-- Content Side -->
                        <div class="{{ $index % 2 === 0 ? 'md:pl-12' : 'md:pr-12 md:order-1' }} pl-12 md:pl-0">
                            <div class="timeline-card bg-white dark:bg-gray-700 rounded-xl p-6 shadow-lg border border-gray-100 dark:border-gray-600">
                                @if(!empty($item['icon']))
                                <div class="w-12 h-12 rounded-lg bg-primary-100 dark:bg-primary-800 flex items-center justify-center mb-4">
                                    <x-icon icon="{{ $item['icon'] }}" class="w-6 h-6 text-primary-600 dark:text-primary-400" />
                                </div>
                                @endif

                                <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-2">
                                    {{ $item['title'] ?? '' }}
                                </h3>

                                @if(!empty($item['description']))
                                <p class="text-gray-600 dark:text-gray-300">
                                    {{ $item['description'] }}
                                </p>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
        @endif
    </div>
</section>

<style>
    .timeline-container {
        position: relative;
    }
    .timeline-line {
        position: absolute;
        left: 50%;
        transform: translateX(-50%);
        width: 4px;
        height: 100%;
        background: linear-gradient(to bottom, var(--color-primary-200), var(--color-primary-500), var(--color-primary-200));
        border-radius: 2px;
    }
    @media (max-width: 768px) {
        .timeline-line {
            left: 20px;
        }
    }
    [dir="rtl"] .timeline-line {
        left: auto;
        right: 50%;
        transform: translateX(50%);
    }
    [dir="rtl"] @media (max-width: 768px) {
        .timeline-line {
            right: 20px;
            left: auto;
        }
    }
    .timeline-dot {
        position: absolute;
        left: 50%;
        transform: translateX(-50%);
        width: 20px;
        height: 20px;
        background: var(--color-primary-500);
        border: 4px solid white;
        border-radius: 50%;
        box-shadow: 0 0 0 4px var(--color-primary-100);
        z-index: 10;
    }
    .dark .timeline-dot {
        border-color: var(--color-gray-800);
        box-shadow: 0 0 0 4px var(--color-primary-900);
    }
    @media (max-width: 768px) {
        .timeline-dot {
            left: 20px;
        }
    }
    [dir="rtl"] .timeline-dot {
        left: auto;
        right: 50%;
        transform: translateX(50%);
    }
    .timeline-item {
        transition: transform 0.3s ease;
    }
    .timeline-item:hover {
        transform: scale(1.02);
    }
    .timeline-card {
        transition: box-shadow 0.3s ease;
    }
    .timeline-item:hover .timeline-card {
        box-shadow: 0 20px 40px -15px rgba(0, 0, 0, 0.15);
    }
</style>
</div>
