<?php

use Livewire\Component;

/**
 * Reusable CTA Section Component
 *
 * Usage:
 * <livewire:laundry::cta-section
 *     title="Ready to Get Started?"
 *     subtitle="Join thousands of happy customers."
 *     primary-button="Schedule Your First Pickup"
 *     secondary-button="Call Us Now"
 *     phone="+1 (555) 123-4567"
 *     variant="gradient"
 * />
 *
 * Variants: "gradient" (primary color gradient) or "dark" (dark background with blur effects)
 */
new class extends Component {
    public string $title = 'Ready to Get Started?';
    public string $subtitle = 'Join thousands of happy customers.';
    public string $primaryButton = 'Schedule Your First Pickup';
    public string $secondaryButton = 'Call Us Now';
    public string $primaryLink = '#contact';
    public string $phone = '';
    public string $variant = 'gradient'; // 'gradient' or 'dark'

    public function mount(string $title = 'Ready to Get Started?', string $subtitle = 'Join thousands of happy customers.', string $primaryButton = 'Schedule Your First Pickup', string $secondaryButton = 'Call Us Now', string $primaryLink = '#contact', string $phone = '', string $variant = 'gradient')
    {
        $this->title = $title;
        $this->subtitle = $subtitle;
        $this->primaryButton = $primaryButton;
        $this->secondaryButton = $secondaryButton;
        $this->primaryLink = $primaryLink;
        $this->phone = $phone;
        $this->variant = $variant;
    }
};
?>

@if ($variant === 'gradient')
    {{-- Gradient Variant (Primary Color Background) --}}
    <section class="py-20 gradient-hero relative overflow-hidden">
        {{-- Floating Elements --}}
        <div class="absolute inset-0 overflow-hidden">
            <div class="floating-element w-64 h-64 bg-white -top-32 -right-32 animate-float"></div>
            <div class="floating-element w-48 h-48 bg-white bottom-0 left-1/4 animate-float delay-300"></div>
        </div>

        <div class="relative max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            <h2 class="text-3xl sm:text-4xl font-bold text-white mb-6">{{ $title }}</h2>
            <p class="text-xl text-white/90 mb-8">{{ $subtitle }}</p>
            <div class="flex flex-wrap justify-center gap-4">
                <a href="{{ $primaryLink }}" class="btn btn-white">
                    {{ $primaryButton }}
                </a>
                @if ($phone)
                    <a href="tel:{{ $phone }}" class="btn btn-outline-white">
                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z">
                            </path>
                        </svg>
                        {{ $secondaryButton }}
                    </a>
                @endif
            </div>
        </div>
    </section>
@else
    {{-- Dark Variant (Dark Background with Blur Effects) --}}
    <section class="py-20 bg-gray-900 dark:bg-gray-950 relative overflow-hidden">
        {{-- Background Elements --}}
        <div class="absolute inset-0">
            <div class="absolute top-0 left-0 w-72 h-72 bg-primary-600/20 rounded-full blur-3xl"></div>
            <div class="absolute bottom-0 right-0 w-96 h-96 bg-secondary-600/20 rounded-full blur-3xl"></div>
        </div>

        <div class="relative max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            <h2 class="text-3xl sm:text-4xl lg:text-5xl font-bold text-white mb-6">{{ $title }}</h2>
            <p class="text-xl text-gray-300 mb-10 max-w-2xl mx-auto">{{ $subtitle }}</p>
            <div class="flex flex-wrap justify-center gap-4">
                <a href="{{ $primaryLink }}" class="btn btn-primary">
                    {{ $primaryButton }}
                </a>
                @if ($phone)
                    <a href="tel:{{ $phone }}"
                        class="inline-flex items-center px-8 py-4 bg-white/10 text-white font-semibold rounded-xl border border-white/20 hover:bg-white/20 transition-colors">
                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z">
                            </path>
                        </svg>
                        {{ $secondaryButton }}
                    </a>
                @endif
            </div>
        </div>
    </section>
@endif
