<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="{{ $direction ?? 'ltr' }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    {{-- Primary SEO Meta Tags --}}
    <title>{{ $title ?? config('app.name') }}</title>
    @if (isset($seo))
        <meta name="description" content="{{ $seo['description'] ?? '' }}">
        <meta name="keywords" content="{{ $seo['keywords'] ?? '' }}">
        <meta name="author" content="{{ $seo['author'] ?? '' }}">
        <meta name="robots" content="{{ $seo['robots'] ?? 'index, follow' }}">
        <link rel="canonical" href="{{ $seo['canonical'] ?? request()->url() }}">

        {{-- Open Graph / Facebook --}}
        <meta property="og:type" content="{{ $seo['og']['type'] ?? 'website' }}">
        <meta property="og:url" content="{{ $seo['canonical'] ?? request()->url() }}">
        <meta property="og:title" content="{{ $title ?? config('app.name') }}">
        <meta property="og:description" content="{{ $seo['description'] ?? '' }}">
        <meta property="og:image" content="{{ $seo['og']['image'] ?? '' }}">
        <meta property="og:image:width" content="{{ $seo['og']['image_width'] ?? '' }}">
        <meta property="og:image:height" content="{{ $seo['og']['image_height'] ?? '' }}">
        <meta property="og:image:alt" content="{{ $seo['og']['image_alt'] ?? '' }}">
        <meta property="og:locale" content="{{ $seo['og']['locale'] ?? 'en_US' }}">
        <meta property="og:site_name" content="{{ $seo['og']['site_name'] ?? config('app.name') }}">

        {{-- Twitter Card --}}
        <meta name="twitter:card" content="{{ $seo['twitter']['card'] ?? 'summary_large_image' }}">
        <meta name="twitter:site" content="{{ $seo['twitter']['site'] ?? '' }}">
        <meta name="twitter:creator" content="{{ $seo['twitter']['creator'] ?? '' }}">
        <meta name="twitter:title" content="{{ $title ?? config('app.name') }}">
        <meta name="twitter:description" content="{{ $seo['description'] ?? '' }}">
        <meta name="twitter:image" content="{{ $seo['og']['image'] ?? '' }}">
        <meta name="twitter:image:alt" content="{{ $seo['og']['image_alt'] ?? '' }}">
    @endif

    {{-- Favicon from Business Settings --}}
    @if (!empty($company['favicon']))
        <link rel="icon" type="image/x-icon" href="{{ $company['favicon'] }}">
        <link rel="shortcut icon" href="{{ $company['favicon'] }}">
        <link rel="apple-touch-icon" href="{{ $company['favicon'] }}">
    @else
        <link rel="icon" type="image/x-icon" href="{{ asset('images/favicon.png') }}">
    @endif

    {{-- Additional SEO Meta Tags --}}
    <meta name="theme-color" content="{{ $themeColor ?? '#0ea5e9' }}">
    <meta name="msapplication-TileColor" content="{{ $themeColor ?? '#0ea5e9' }}">

    {{-- Website Slug for per-website theme/language preferences --}}
    <meta name="website-slug" content="{{ $websiteSlug ?? 'default' }}">
    <meta name="format-detection" content="telephone=yes">

    {{-- Google Fonts --}}
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Plus+Jakarta+Sans:wght@600;700;800&display=swap"
        rel="stylesheet">

    {{-- Vite Assets --}}
    {{ module_vite('build-' . $frontThemeName, 'resources/views/themes/' . $frontThemeName . '/assets/app.css', storage_path('vite-' . $frontThemeName . '.hot')) }}

    {{-- Dynamic Theme Colors --}}
    @if (isset($theme))
        <style>
            :root {
                /* Primary Colors */
                --color-primary-50: {{ $theme['primary']['50'] ?? '#f0f9ff' }};
                --color-primary-100: {{ $theme['primary']['100'] ?? '#e0f2fe' }};
                --color-primary-200: {{ $theme['primary']['200'] ?? '#bae6fd' }};
                --color-primary-300: {{ $theme['primary']['300'] ?? '#7dd3fc' }};
                --color-primary-400: {{ $theme['primary']['400'] ?? '#38bdf8' }};
                --color-primary-500: {{ $theme['primary']['500'] ?? '#0ea5e9' }};
                --color-primary-600: {{ $theme['primary']['600'] ?? '#0284c7' }};
                --color-primary-700: {{ $theme['primary']['700'] ?? '#0369a1' }};
                --color-primary-800: {{ $theme['primary']['800'] ?? '#075985' }};
                --color-primary-900: {{ $theme['primary']['900'] ?? '#0c4a6e' }};

                /* Secondary Colors */
                --color-secondary-50: {{ $theme['secondary']['50'] ?? '#fdf4ff' }};
                --color-secondary-100: {{ $theme['secondary']['100'] ?? '#fae8ff' }};
                --color-secondary-200: {{ $theme['secondary']['200'] ?? '#f5d0fe' }};
                --color-secondary-300: {{ $theme['secondary']['300'] ?? '#f0abfc' }};
                --color-secondary-400: {{ $theme['secondary']['400'] ?? '#e879f9' }};
                --color-secondary-500: {{ $theme['secondary']['500'] ?? '#d946ef' }};
                --color-secondary-600: {{ $theme['secondary']['600'] ?? '#c026d3' }};
                --color-secondary-700: {{ $theme['secondary']['700'] ?? '#a21caf' }};
                --color-secondary-800: {{ $theme['secondary']['800'] ?? '#86198f' }};
                --color-secondary-900: {{ $theme['secondary']['900'] ?? '#701a75' }};
            }
        </style>
    @endif

    {{-- Page Specific Styles --}}
    @stack('styles')

    {{-- Custom CSS from Business Settings --}}
    @if (!empty($customCss))
        <style id="custom-business-css">
            {!! $customCss !!}
        </style>
    @endif

    {{-- Note: Progress bar, header, and other critical styles are now in app.css --}}

    @livewireStyles
</head>

<body class="antialiased {{ ($themeMode ?? 'light') === 'dark' ? 'dark' : '' }}"
    data-theme="{{ $themeMode ?? 'light' }}">
    <script>
        // Detect if page is in iframe preview mode (full page only, not section previews)
        if (window.self !== window.top && !window.location.pathname.includes('/section-preview/')) {
            document.body.classList.add('in-iframe');
        }
    </script>
    {{-- Progress Loading Bar --}}
    <div id="progress-bar" class="progress-bar"></div>

    {{-- Main Content (includes header, page sections, and footer from website_builder) --}}
    {{ $slot }}

    {{-- Scroll to Top Button --}}
    <button id="scroll-top" class="scroll-top">
        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 10l7-7m0 0l7 7m-7-7v18"></path>
        </svg>
    </button>

    {{-- Vite JS --}}
    {{ module_vite('build-' . $frontThemeName, 'resources/views/themes/' . $frontThemeName . '/assets/app.js', storage_path('vite-' . $frontThemeName . '.hot')) }}

    @livewireScripts

    {{-- Page Specific Scripts --}}
    @stack('scripts')

    {{-- Custom JavaScript from Business Settings --}}
    @if (!empty($customJs))
        <script id="custom-business-js">
            {!! $customJs !!}
        </script>
    @endif
</body>

</html>
