<?php

use Examyou\RestAPI\Facades\ApiRoute;

// Admin module menu routes
// NOTE: Auth middleware disabled for testing. Re-enable in production!
ApiRoute::group(['namespace' => 'App\Http\Controllers\Admin', 'prefix' => 'modules'], function () {
    ApiRoute::get('menu',  ['as' => 'api.modules.menu', 'uses' => 'ModuleMenuController@index']);
    ApiRoute::post('menu/clear-cache', ['as' => 'api.modules.menu', 'uses' => 'ModuleMenuController@clearCache']);
});

// Admin Routes
ApiRoute::group(['namespace' => 'App\Http\Controllers\Api'], function () {
    ApiRoute::get('all-langs', ['as' => 'api.extra.all-langs', 'uses' => 'AuthController@allEnabledLangs']);
    ApiRoute::get('lang-trans', ['as' => 'api.extra.lang-trans', 'uses' => 'AuthController@langTrans']);
    ApiRoute::post('change-theme-mode', ['as' => 'api.extra.change-theme-mode', 'uses' => 'AuthController@changeThemeMode']);

    // Check visibility of module according to subscription plan
    ApiRoute::post('check-subscription-module-visibility', ['as' => 'api.extra.check-subscription-module-visibility', 'uses' => 'AuthController@checkSubscriptionModuleVisibility']);
    ApiRoute::post('visible-subscription-modules', ['as' => 'api.extra.visible-subscription-modules', 'uses' => 'AuthController@visibleSubscriptionModules']);

    ApiRoute::group(['middleware' => ['api.auth.check']], function () {

        // Dashboard routes
        ApiRoute::post('dashboard', ['as' => 'api.dashboard.index', 'uses' => 'DashboardController@index']);
        ApiRoute::get('dashboard/submission-chart', ['as' => 'api.dashboard.submission-chart', 'uses' => 'DashboardController@submissionChart']);
        ApiRoute::get('dashboard/status-distribution', ['as' => 'api.dashboard.status-distribution', 'uses' => 'DashboardController@statusDistribution']);
        ApiRoute::post('upload-file', ['as' => 'api.extra.upload-file', 'uses' => 'AuthController@uploadFile']);
        ApiRoute::post('profile', ['as' => 'api.extra.profile', 'uses' => 'AuthController@profile']);
        ApiRoute::post('user', ['as' => 'api.extra.user', 'uses' => 'AuthController@user']);
        ApiRoute::get('timezones', ['as' => 'api.extra.user', 'uses' => 'AuthController@getAllTimezones']);
        ApiRoute::get('get-all-employees', ['as' => 'api.extra.get-all-employees', 'uses' => 'AuthController@toGetAllEmployeeProfile']);
    });

    // Routes Accessable to thouse user who have permissions realted to route
    ApiRoute::group(['middleware' => ['api.permission.check', 'api.auth.check', 'license-expire']], function () {
        $options = [
            'as' => 'api',
            'except' => ['show']
        ];

        // Website Categories
        ApiRoute::resource('website-categories', 'WebsiteCategoryController', $options);

        // Website Pages
        ApiRoute::resource('website-pages', 'WebsitePageController', $options);
        ApiRoute::post('website-pages/update-sort-order', ['as' => 'api.websites.pages.update-sort-order', 'uses' => 'WebsitePageController@updateSortOrder']);

        // Front Languages
        ApiRoute::resource('website-languages', 'WebsiteLanguageController', $options);
        ApiRoute::post('website-languages/{id}/set-default', ['as' => 'api.website-languages.set-default', 'uses' => 'WebsiteLanguageController@setDefault']);

        // Business
        ApiRoute::resource('websites', 'WebsiteController', $options);
        ApiRoute::post('websites/ai-wizard-create', ['as' => 'api.websites.ai-wizard-create', 'uses' => 'WebsiteController@aiWizardCreate']);
        ApiRoute::post('websites/{id}/toggle-favourite', ['as' => 'api.websites.toggle-favourite', 'uses' => 'WebsiteController@toggleFavourite']);
        ApiRoute::post('websites/{id}/toggle-primary', ['as' => 'api.websites.toggle-primary', 'uses' => 'WebsiteController@togglePrimary']);

        // Business Settings (single resource for settings)
        ApiRoute::get('website-settings', ['as' => 'api.websites.settings.index', 'uses' => 'WebsiteSettingController@setting']);
        ApiRoute::post('website-settings', ['as' => 'api.websites.settings.update', 'uses' => 'WebsiteSettingController@updateSetting']);
        ApiRoute::get('website-settings/available-themes', ['as' => 'api.websites.settings.available-themes', 'uses' => 'WebsiteSettingController@getAvailableThemes']);
        ApiRoute::get('website-settings/layout-components/{themeName}/{type}', ['as' => 'api.websites.settings.layout-components', 'uses' => 'WebsiteSettingController@getLayoutComponents']);

        // Website Builder
        ApiRoute::resource('website-builder', 'WebsiteBuilderController', $options);
        ApiRoute::get('website-builder/section-layouts', ['as' => 'api.website-builder.section-layouts', 'uses' => 'WebsiteBuilderController@getSectionLayouts']);
        ApiRoute::post('website-builder/update-sort-order', ['as' => 'api.website-builder.update-sort-order', 'uses' => 'WebsiteBuilderController@updateSortOrder']);

        // Theme Sections (available section templates)
        ApiRoute::resource('theme-sections', 'ThemeSectionController', ['as' => 'api', 'only' => ['index']]);

        // AI Website Wizard
        ApiRoute::get('ai/config', ['as' => 'api.ai.config', 'uses' => 'Common\AiSettingsController@getActiveConfig']);
        ApiRoute::post('ai/extract-website-data', ['as' => 'api.ai.extract-website-data', 'uses' => 'Common\AiSettingsController@extractWebsiteData']);
        ApiRoute::post('ai/generate-pages', ['as' => 'api.ai.generate-pages', 'uses' => 'Common\AiSettingsController@generatePages']);
        ApiRoute::post('ai/save-generated-pages', ['as' => 'api.ai.save-generated-pages', 'uses' => 'Common\AiSettingsController@saveGeneratedPages']);
        ApiRoute::post('ai/generate-legal-pages', ['as' => 'api.ai.generate-legal-pages', 'uses' => 'Common\AiSettingsController@generateLegalPages']);
        ApiRoute::post('ai/generate-legal-page-suggestions', ['as' => 'api.ai.generate-legal-page-suggestions', 'uses' => 'Common\AiSettingsController@generateLegalPageSuggestions']);
        ApiRoute::post('ai/generate-legal-page-content', ['as' => 'api.ai.generate-legal-page-content', 'uses' => 'Common\AiSettingsController@generateLegalPageContent']);
        ApiRoute::post('ai/save-generated-legal-pages', ['as' => 'api.ai.save-generated-legal-pages', 'uses' => 'Common\AiSettingsController@saveGeneratedLegalPages']);
        // AI Website Builder Sections
        ApiRoute::get('ai/theme-sections-config', ['as' => 'api.ai.theme-sections-config', 'uses' => 'Common\AiSettingsController@getThemeSectionsConfig']);
        ApiRoute::post('ai/generate-section-suggestions', ['as' => 'api.ai.generate-section-suggestions', 'uses' => 'Common\AiSettingsController@generateSectionSuggestions']);
        ApiRoute::post('ai/generate-section-content', ['as' => 'api.ai.generate-section-content', 'uses' => 'Common\AiSettingsController@generateSectionContent']);
        ApiRoute::post('ai/save-generated-sections', ['as' => 'api.ai.save-generated-sections', 'uses' => 'Common\AiSettingsController@saveGeneratedSections']);

        // Icon Sets Management
        ApiRoute::get('icon-sets/{id}/icons', ['as' => 'api.icon-sets.icons', 'uses' => 'IconSetController@getIcons']);
        ApiRoute::post('icon-sets/{id}/add-icons', ['as' => 'api.icon-sets.add-icons', 'uses' => 'IconSetController@addIcons']);
        ApiRoute::post('icon-sets/{id}/remove-icons', ['as' => 'api.icon-sets.remove-icons', 'uses' => 'IconSetController@removeIcons']);
        ApiRoute::get('icons/all', ['as' => 'api.icons.all', 'uses' => 'IconSetController@getAllIcons']);
        ApiRoute::get('icons/search', ['as' => 'api.icons.search', 'uses' => 'IconSetController@searchIcons']);
        ApiRoute::post('icons/bulk-add', ['as' => 'api.icons.bulk-add', 'uses' => 'IconSetController@bulkAddIcons']);
        ApiRoute::get('icons/sets-dropdown', ['as' => 'api.icons.sets-dropdown', 'uses' => 'IconSetController@getIconSetsForDropdown']);
        ApiRoute::post('icon-sets/update-sort-order', ['as' => 'api.icon-sets.update-sort-order', 'uses' => 'IconSetController@updateSortOrder']);
        ApiRoute::resource('icon-sets', 'IconSetController', $options);

        // Website Legal Pages
        ApiRoute::post('website-legal-pages/update-sort-order', ['as' => 'api.website-legal-pages.update-sort-order', 'uses' => 'WebsiteLegalPageController@updateSortOrder']);
        ApiRoute::resource('website-legal-pages', 'WebsiteLegalPageController', $options);

        // Imports
        ApiRoute::post('staff-members/import', ['as' => 'api.staff_members.import', 'uses' => 'StaffMembersController@import']);

        // Bulk Store
        ApiRoute::post('staff-members/bulk-store', ['as' => 'api.staff_members.bulk-store', 'uses' => 'StaffMembersController@bulkStore']);

        // Create Menu Update
        ApiRoute::post('companies/update-create-menu', ['as' => 'api.companies.update-create-menu', 'uses' => 'CompanyController@updateCreateMenu']);

        ApiRoute::get('get-module-permisions/{module}', ['as' => 'api.permissions.module', 'uses' => 'ModulePermissionController@getModulePermissions']);
        ApiRoute::get('get-roles-with-module-permissions/{module}', ['as' => 'api.roles.module', 'uses' => 'ModulePermissionController@getRolesWithModulePermissions']);
        ApiRoute::post('seed-module-permissions/{module}', ['as' => 'api.permissions.seed', 'uses' => 'ModulePermissionController@seedModulePermissions']);
        ApiRoute::post('module-permissions/toggle', ['as' => 'api.permissions.toggle', 'uses' => 'ModulePermissionController@updateRolePermissions']);
        ApiRoute::post('module-permissions/bulk-update', ['as' => 'api.permissions.bulk-update', 'uses' => 'ModulePermissionController@bulkUpdateRolePermissions']);
        ApiRoute::post('module-permissions/bulk-update-all-roles', ['as' => 'api.permissions.bulk-update-all-roles', 'uses' => 'ModulePermissionController@bulkUpdateAllRolesPermissions']);

        ApiRoute::resource('staff-members', 'StaffMembersController', $options);
        ApiRoute::resource('companies', 'CompanyController', ['as' => 'api', 'only' => ['update']]);
        ApiRoute::get('module-wise-permissions', ['as' => 'api.permissions.module-wise', 'uses' => 'PermissionController@moduleWisePermissions']);
        ApiRoute::resource('permissions', 'PermissionController', ['as' => 'api', 'only' => ['index']]);
        ApiRoute::resource('roles', 'RolesController', $options);

        // PDF font related
        ApiRoute::post('pdf-custom-fonts', ['as' => 'api.pdf-custom-fonts', 'uses' => 'CompanyController@updatePdfFontSetting']);
        ApiRoute::get('pdf-templates', ['as' => 'api.pdf-templates', 'uses' => 'PdfController@getTemplates']);
        ApiRoute::post('sample-pdf', ['as' => 'api.sample-pdf', 'uses' => 'PdfController@generateSamplePdf']);
        ApiRoute::resource('pdf-fonts', 'PdfFontsController', $options);

        // Email Templates
        ApiRoute::resource('email-templates', 'EmailTemplateController', ['as' => 'api', 'only' => ['index', 'update']]);
    });
});
