<?php
use Livewire\Component;
?>

<section class="section <?php echo e($isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900'); ?>" <?php if($this->getCustomPaddingStyle()): ?> style="<?php echo e($this->getCustomPaddingStyle()); ?>" <?php endif; ?>>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        
        <div class="text-center mb-16">
            <span class="badge badge-primary mb-4"><?php echo e($section['badge']); ?></span>
            <h2 class="section-title"><?php echo e($section['title']); ?></h2>
            <p class="section-subtitle"><?php echo e($section['subtitle']); ?></p>
        </div>

        
        <div class="grid grid-cols-2 md:grid-cols-3 gap-4">
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                <div class="scroll-animate gallery-item <?php echo e($index === 0 ? 'md:col-span-2 md:row-span-2' : ''); ?>">
                    <img src="<?php echo e($item['image_url'] ?? $item['image']); ?>" alt="<?php echo e($item['alt']); ?>"
                        class="w-full h-full object-cover <?php echo e($index === 0 ? 'aspect-square md:aspect-auto md:h-full' : 'aspect-square'); ?>"
                        loading="lazy">
                    <div class="gallery-overlay">
                        <p class="text-white font-medium"><?php echo e($item['alt']); ?></p>
                    </div>
                </div>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
        </div>
    </div>
</section><?php /**PATH /Users/rajeshkumawat/sites/ant4-laravel12-vue3/storage/framework/views/livewire/views/9df26214.blade.php ENDPATH**/ ?>