<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" dir="<?php echo e($direction ?? 'ltr'); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    
    <title><?php echo e($title ?? config('app.name')); ?></title>
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($seo)): ?>
        <meta name="description" content="<?php echo e($seo['description'] ?? ''); ?>">
        <meta name="keywords" content="<?php echo e($seo['keywords'] ?? ''); ?>">
        <meta name="author" content="<?php echo e($seo['author'] ?? ''); ?>">
        <meta name="robots" content="<?php echo e($seo['robots'] ?? 'index, follow'); ?>">
        <link rel="canonical" href="<?php echo e($seo['canonical'] ?? request()->url()); ?>">

        
        <meta property="og:type" content="<?php echo e($seo['og']['type'] ?? 'website'); ?>">
        <meta property="og:url" content="<?php echo e($seo['canonical'] ?? request()->url()); ?>">
        <meta property="og:title" content="<?php echo e($title ?? config('app.name')); ?>">
        <meta property="og:description" content="<?php echo e($seo['description'] ?? ''); ?>">
        <meta property="og:image" content="<?php echo e($seo['og']['image'] ?? ''); ?>">
        <meta property="og:image:width" content="<?php echo e($seo['og']['image_width'] ?? ''); ?>">
        <meta property="og:image:height" content="<?php echo e($seo['og']['image_height'] ?? ''); ?>">
        <meta property="og:image:alt" content="<?php echo e($seo['og']['image_alt'] ?? ''); ?>">
        <meta property="og:locale" content="<?php echo e($seo['og']['locale'] ?? 'en_US'); ?>">
        <meta property="og:site_name" content="<?php echo e($seo['og']['site_name'] ?? config('app.name')); ?>">

        
        <meta name="twitter:card" content="<?php echo e($seo['twitter']['card'] ?? 'summary_large_image'); ?>">
        <meta name="twitter:site" content="<?php echo e($seo['twitter']['site'] ?? ''); ?>">
        <meta name="twitter:creator" content="<?php echo e($seo['twitter']['creator'] ?? ''); ?>">
        <meta name="twitter:title" content="<?php echo e($title ?? config('app.name')); ?>">
        <meta name="twitter:description" content="<?php echo e($seo['description'] ?? ''); ?>">
        <meta name="twitter:image" content="<?php echo e($seo['og']['image'] ?? ''); ?>">
        <meta name="twitter:image:alt" content="<?php echo e($seo['og']['image_alt'] ?? ''); ?>">
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

    
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($company['favicon'])): ?>
        <link rel="icon" type="image/x-icon" href="<?php echo e($company['favicon']); ?>">
        <link rel="shortcut icon" href="<?php echo e($company['favicon']); ?>">
        <link rel="apple-touch-icon" href="<?php echo e($company['favicon']); ?>">
    <?php else: ?>
        <link rel="icon" type="image/x-icon" href="<?php echo e(asset('images/favicon.png')); ?>">
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

    
    <meta name="theme-color" content="<?php echo e($themeColor ?? '#0ea5e9'); ?>">
    <meta name="msapplication-TileColor" content="<?php echo e($themeColor ?? '#0ea5e9'); ?>">

    
    <meta name="website-slug" content="<?php echo e($websiteSlug ?? 'default'); ?>">
    <meta name="format-detection" content="telephone=yes">

    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Plus+Jakarta+Sans:wght@600;700;800&display=swap"
        rel="stylesheet">

    
    <?php echo e(module_vite('build-' . $frontThemeName, 'resources/views/themes/' . $frontThemeName . '/assets/app.css', storage_path('vite-' . $frontThemeName . '.hot'))); ?>


    
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($theme)): ?>
        <style>
            :root {
                /* Primary Colors */
                --color-primary-50: <?php echo e($theme['primary']['50'] ?? '#f0f9ff'); ?>;
                --color-primary-100: <?php echo e($theme['primary']['100'] ?? '#e0f2fe'); ?>;
                --color-primary-200: <?php echo e($theme['primary']['200'] ?? '#bae6fd'); ?>;
                --color-primary-300: <?php echo e($theme['primary']['300'] ?? '#7dd3fc'); ?>;
                --color-primary-400: <?php echo e($theme['primary']['400'] ?? '#38bdf8'); ?>;
                --color-primary-500: <?php echo e($theme['primary']['500'] ?? '#0ea5e9'); ?>;
                --color-primary-600: <?php echo e($theme['primary']['600'] ?? '#0284c7'); ?>;
                --color-primary-700: <?php echo e($theme['primary']['700'] ?? '#0369a1'); ?>;
                --color-primary-800: <?php echo e($theme['primary']['800'] ?? '#075985'); ?>;
                --color-primary-900: <?php echo e($theme['primary']['900'] ?? '#0c4a6e'); ?>;

                /* Secondary Colors */
                --color-secondary-50: <?php echo e($theme['secondary']['50'] ?? '#fdf4ff'); ?>;
                --color-secondary-100: <?php echo e($theme['secondary']['100'] ?? '#fae8ff'); ?>;
                --color-secondary-200: <?php echo e($theme['secondary']['200'] ?? '#f5d0fe'); ?>;
                --color-secondary-300: <?php echo e($theme['secondary']['300'] ?? '#f0abfc'); ?>;
                --color-secondary-400: <?php echo e($theme['secondary']['400'] ?? '#e879f9'); ?>;
                --color-secondary-500: <?php echo e($theme['secondary']['500'] ?? '#d946ef'); ?>;
                --color-secondary-600: <?php echo e($theme['secondary']['600'] ?? '#c026d3'); ?>;
                --color-secondary-700: <?php echo e($theme['secondary']['700'] ?? '#a21caf'); ?>;
                --color-secondary-800: <?php echo e($theme['secondary']['800'] ?? '#86198f'); ?>;
                --color-secondary-900: <?php echo e($theme['secondary']['900'] ?? '#701a75'); ?>;
            }
        </style>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

    
    <?php echo $__env->yieldPushContent('styles'); ?>

    
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($customCss)): ?>
        <style id="custom-business-css">
            <?php echo $customCss; ?>

        </style>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

    

    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::styles(); ?>

</head>

<body class="antialiased <?php echo e(($themeMode ?? 'light') === 'dark' ? 'dark' : ''); ?>"
    data-theme="<?php echo e($themeMode ?? 'light'); ?>">
    <script>
        // Detect if page is in iframe preview mode (full page only, not section previews)
        if (window.self !== window.top && !window.location.pathname.includes('/section-preview/')) {
            document.body.classList.add('in-iframe');
        }
    </script>
    
    <div id="progress-bar" class="progress-bar"></div>

    
    <?php echo e($slot); ?>


    
    <button id="scroll-top" class="scroll-top">
        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 10l7-7m0 0l7 7m-7-7v18"></path>
        </svg>
    </button>

    
    <?php echo e(module_vite('build-' . $frontThemeName, 'resources/views/themes/' . $frontThemeName . '/assets/app.js', storage_path('vite-' . $frontThemeName . '.hot'))); ?>


    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::scripts(); ?>


    
    <?php echo $__env->yieldPushContent('scripts'); ?>

    
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($customJs)): ?>
        <script id="custom-business-js">
            <?php echo $customJs; ?>

        </script>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
</body>

</html>
<?php /**PATH /Users/rajeshkumawat/sites/ant4-laravel12-vue3/resources/views/themes/tailwind_theme/layouts/app.blade.php ENDPATH**/ ?>