<?php
use Livewire\Component;
?>

<section class="pricing-gradient-section <?php echo e($isWhiteBackground ? 'pricing-gradient-white' : 'pricing-gradient-gray'); ?>" <?php if($this->getCustomPaddingStyle()): ?> style="<?php echo e($this->getCustomPaddingStyle()); ?>" <?php endif; ?>>
    <div class="pricing-gradient-bg-shapes">
        <div class="pricing-gradient-shape pricing-gradient-shape-1"></div>
        <div class="pricing-gradient-shape pricing-gradient-shape-2"></div>
    </div>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative">
        <div class="text-center mb-12">
            <span class="pricing-gradient-badge"><?php echo e($section['badge']); ?></span>
            <h2 class="pricing-gradient-title"><?php echo e($section['title']); ?></h2>
            <p class="pricing-gradient-subtitle"><?php echo e($section['subtitle']); ?></p>
        </div>
        <div class="pricing-gradient-grid">
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                <div class="pricing-gradient-card <?php echo e($plan['popular'] ? 'pricing-gradient-card-popular' : ''); ?>" style="animation-delay: <?php echo e($index * 100); ?>ms">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($plan['popular']): ?>
                        <div class="pricing-gradient-popular-ribbon"><?php echo e($section['popular_badge']); ?></div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    <div class="pricing-gradient-card-header">
                        <h3 class="pricing-gradient-plan-name"><?php echo e($plan['name']); ?></h3>
                        <p class="pricing-gradient-plan-desc"><?php echo e($plan['description']); ?></p>
                    </div>
                    <div class="pricing-gradient-price-container">
                        <div class="pricing-gradient-price-wrapper">
                            <span class="pricing-gradient-currency"><?php echo e($section['currency_symbol']); ?></span>
                            <span class="pricing-gradient-amount"><?php echo e($plan['price']); ?></span>
                        </div>
                        <span class="pricing-gradient-period">/<?php echo e($plan['period']); ?></span>
                    </div>
                    <ul class="pricing-gradient-features">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__currentLoopData = $plan['features']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                            <li class="pricing-gradient-feature <?php echo e($feature['is_included'] ? 'pricing-gradient-feature-included' : 'pricing-gradient-feature-excluded'); ?>">
                                <?php if (isset($component)) { $__componentOriginald88937ee957874c050ccbc67a5e19575 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginald88937ee957874c050ccbc67a5e19575 = $attributes; } ?>
<?php $component = App\View\Components\Icon::resolve(['icon' => ''.e($feature['icon'] ?? 'lucide:check').'','class' => 'pricing-gradient-feature-icon'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('icon'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Icon::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginald88937ee957874c050ccbc67a5e19575)): ?>
<?php $attributes = $__attributesOriginald88937ee957874c050ccbc67a5e19575; ?>
<?php unset($__attributesOriginald88937ee957874c050ccbc67a5e19575); ?>
<?php endif; ?>
<?php if (isset($__componentOriginald88937ee957874c050ccbc67a5e19575)): ?>
<?php $component = $__componentOriginald88937ee957874c050ccbc67a5e19575; ?>
<?php unset($__componentOriginald88937ee957874c050ccbc67a5e19575); ?>
<?php endif; ?>
                                <span><?php echo e($feature['text']); ?></span>
                            </li>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
                    </ul>
                    <a href="<?php echo e($section['cta_button_url'] ?? '#contact'); ?>" class="pricing-gradient-btn"><?php echo e($section['cta_button']); ?></a>
                </div>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
        </div>
    </div>
</section>

</div><?php /**PATH /Users/rajeshkumawat/sites/ant4-laravel12-vue3/storage/framework/views/livewire/views/8e166996.blade.php ENDPATH**/ ?>