<?php

use Livewire\Component;

return new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(
        array $section = [],
        array $items = [],
        array $company = [],
        array $social = [],
        array $services = [],
        bool $isWhiteBackground = false,
        ?int $paddingTop = null,
        ?int $paddingBottom = null
    ) {
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        $defaultItems = [
            [
                'name' => 'Basic',
                'price' => '29',
                'period' => 'per month',
                'description' => 'Perfect for individuals',
                'features' => [
                    ['icon' => 'lucide:scale', 'text' => '15 lbs of laundry', 'is_included' => true],
                    ['icon' => 'lucide:sparkles', 'text' => 'Wash & fold service', 'is_included' => true],
                    ['icon' => 'lucide:truck', 'text' => 'Free pickup & delivery', 'is_included' => true],
                    ['icon' => 'lucide:clock', 'text' => '48-hour turnaround', 'is_included' => true],
                    ['icon' => 'lucide:flask-conical', 'text' => 'Standard detergents', 'is_included' => true],
                    ['icon' => 'lucide:leaf', 'text' => 'Premium eco detergents', 'is_included' => false],
                    ['icon' => 'lucide:zap', 'text' => 'Same-day turnaround', 'is_included' => false],
                ],
                'popular' => false,
            ],
            [
                'name' => 'Family',
                'price' => '79',
                'period' => 'per month',
                'description' => 'Best for families',
                'features' => [
                    ['icon' => 'lucide:scale', 'text' => '50 lbs of laundry', 'is_included' => true],
                    ['icon' => 'lucide:sparkles', 'text' => 'Wash, fold & iron', 'is_included' => true],
                    ['icon' => 'lucide:truck', 'text' => 'Free pickup & delivery', 'is_included' => true],
                    ['icon' => 'lucide:clock', 'text' => '24-hour turnaround', 'is_included' => true],
                    ['icon' => 'lucide:leaf', 'text' => 'Premium eco detergents', 'is_included' => true],
                    ['icon' => 'lucide:scissors', 'text' => '2 dry clean items/month', 'is_included' => true],
                    ['icon' => 'lucide:zap', 'text' => 'Same-day turnaround', 'is_included' => false],
                ],
                'popular' => true,
            ],
            [
                'name' => 'Business',
                'price' => '199',
                'period' => 'per month',
                'description' => 'For businesses & hotels',
                'features' => [
                    ['icon' => 'lucide:infinity', 'text' => 'Unlimited laundry', 'is_included' => true],
                    ['icon' => 'lucide:badge-check', 'text' => 'All services included', 'is_included' => true],
                    ['icon' => 'lucide:calendar-days', 'text' => 'Daily pickup available', 'is_included' => true],
                    ['icon' => 'lucide:zap', 'text' => 'Same-day turnaround', 'is_included' => true],
                    ['icon' => 'lucide:user-circle', 'text' => 'Dedicated account manager', 'is_included' => true],
                    ['icon' => 'lucide:phone', 'text' => 'Priority support', 'is_included' => true],
                    ['icon' => 'lucide:paintbrush', 'text' => 'Custom branding', 'is_included' => true],
                ],
                'popular' => false,
            ],
        ];

        if (!empty($items)) {
            $this->items = array_map(function ($item) {
                if (isset($item['features']) && is_array($item['features'])) {
                    $item['features'] = array_map(function ($feature) {
                        if (is_string($feature)) {
                            return ['icon' => '', 'text' => $feature, 'is_included' => true];
                        }
                        return [
                            'icon' => $feature['icon'] ?? '',
                            'text' => $feature['text'] ?? '',
                            'is_included' => $feature['is_included'] ?? true,
                        ];
                    }, $item['features']);
                }
                return $item;
            }, $items);
        } else {
            $this->items = $defaultItems;
        }

        $this->section = array_merge([
            'badge' => 'Pricing Plans',
            'title' => 'Choose Your Perfect Plan',
            'subtitle' => 'Flexible plans designed to fit your lifestyle.',
            'currency_symbol' => '$',
            'popular_badge' => 'Most Popular',
            'cta_button' => 'Get Started',
            'cta_button_url' => '#contact',
        ], $section);
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }

    protected function view($data = [])
    {
        return app('view')->file('/Users/rajeshkumawat/sites/ant4-laravel12-vue3/storage/framework/views/livewire/views/0abe822e.blade.php', $data);
    }

    public function styleModuleSrc()
    {
        return '/Users/rajeshkumawat/sites/ant4-laravel12-vue3/storage/framework/views/livewire/styles/0abe822e.css';
    }
};
