<?php

use Livewire\Component;

return new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(
        array $section = [],
        array $items = [],
        array $company = [],
        array $social = [],
        array $services = [],
        bool $isWhiteBackground = false,
        ?int $paddingTop = null,
        ?int $paddingBottom = null
    ) {
        $this->section = $section;
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        $this->items = !empty($items) ? $items : [
            ['icon' => 'heroicons:leaf', 'title' => 'Eco-Friendly', 'description' => '100% biodegradable detergents.'],
            ['icon' => 'heroicons:clock', 'title' => 'On-Time Delivery', 'description' => 'Guaranteed delivery within promised timeframe.'],
            ['icon' => 'heroicons:shield-check', 'title' => 'Fully Insured', 'description' => 'Your garments are protected.'],
            ['icon' => 'heroicons:heart', 'title' => 'Care & Quality', 'description' => 'Every item treated with attention.'],
        ];
    }

    public function getPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }

    public function getDefaultPaddingClasses(): string
    {
        $classes = [];
        if ($this->paddingTop === null) {
            $classes[] = 'pt-12';
        }
        if ($this->paddingBottom === null) {
            $classes[] = 'pb-12';
        }
        return implode(' ', $classes);
    }

    protected function view($data = [])
    {
        return app('view')->file('/Users/rajeshkumawat/sites/ant4-laravel12-vue3/storage/framework/views/livewire/views/46d5fef8.blade.php', $data);
    }

    public function styleModuleSrc()
    {
        return '/Users/rajeshkumawat/sites/ant4-laravel12-vue3/storage/framework/views/livewire/styles/46d5fef8.css';
    }
};
