<?php

use Livewire\Component;

return new class extends Component {
    public array $section = [];
    public array $company = [];
    public array $nav = [];
    public array $navItems = [];
    public array $languages = [];
    public ?string $currentLangKey = 'en';
    public ?string $websiteSlug = null;
    public string $homeUrl = '';

    public function mount(array $section = [], array $company = [], array $nav = [], array $navItems = [], array $languages = [], ?string $currentLangKey = 'en', ?string $websiteSlug = null)
    {
        $this->section = $section;
        $this->company = $company;
        $this->nav = $nav;
        $this->navItems = $navItems;
        $this->languages = $languages;
        $this->currentLangKey = $currentLangKey;
        $this->websiteSlug = $websiteSlug;

        // Generate home URL using global helper (handles is_primary for root URL)
        $frontWebsite = view()->shared('frontWebsite');
        $this->homeUrl = landing_home_url($frontWebsite, $this->websiteSlug);
    }

    /**
     * Change the frontend language
     * Stores in cookie with slug-based key (like theme mode), then triggers page reload
     * Cookie key format: lang_{slug} or lang_default
     */
    public function changeLanguage(string $langKey): void
    {
        // Use slug-based cookie key (same pattern as theme mode: theme_{slug})
        $langCookieKey = 'lang_' . ($this->websiteSlug ?? 'default');

        // Set cookie for persistence (1 year)
        cookie()->queue($langCookieKey, $langKey, 60 * 24 * 365);

        // Dispatch browser event to reload the page
        $this->dispatch('language-changed');
    }

    protected function view($data = [])
    {
        return app('view')->file('/Users/rajeshkumawat/sites/ant4-laravel12-vue3/storage/framework/views/livewire/views/7c11ad31.blade.php', $data);
    }

    public function styleModuleSrc()
    {
        return '/Users/rajeshkumawat/sites/ant4-laravel12-vue3/storage/framework/views/livewire/styles/7c11ad31.css';
    }
};
