<?php

use Livewire\Component;

return new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(
        array $section = [],
        array $items = [],
        array $company = [],
        array $social = [],
        array $services = [],
        bool $isWhiteBackground = false,
        ?int $paddingTop = null,
        ?int $paddingBottom = null
    ) {
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->items = $items;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        $defaults = [
            'headline' => '50% OFF Your First Order!',
            'description' => 'New customers get 50% off their first laundry order. Use code WELCOME50 at checkout.',
            'promo_code' => 'WELCOME50',
            'show_promo_code' => true,
            'promo_code_label' => 'Use promo code:',
            'copied_message' => 'Copied to clipboard!',
            'cta_text' => 'Claim Offer',
            'cta_url' => '#contact',
            'expiry_date' => '', // Format: 'YYYY-MM-DD HH:MM:SS' or '2026-12-31 23:59:59'
            'show_countdown' => false,
            'countdown_label' => 'Offer ends in:',
            'countdown_days_label' => 'Days',
            'countdown_hours_label' => 'Hrs',
            'countdown_minutes_label' => 'Mins',
            'countdown_seconds_label' => 'Secs',
            'discount_value' => '50%',
            'discount_label' => 'OFF',
            'icon' => 'lucide:gift',
            'terms' => 'Valid for new customers only. Cannot be combined with other offers.',
        ];

        $this->section = array_merge($defaults, $section);
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }

    protected function view($data = [])
    {
        return app('view')->file('/Users/rajeshkumawat/sites/ant4-laravel12-vue3/storage/framework/views/livewire/views/818a659d.blade.php', $data);
    }

    public function styleModuleSrc()
    {
        return '/Users/rajeshkumawat/sites/ant4-laravel12-vue3/storage/framework/views/livewire/styles/818a659d.css';
    }
};
