<?php

use Livewire\Component;

return new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(array $section = [], array $items = [], array $company = [], array $social = [], array $services = [], bool $isWhiteBackground = false, ?int $paddingTop = null, ?int $paddingBottom = null)
    {
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        // Default team members
        $defaultItems = [
            [
                'name' => 'Sarah Johnson',
                'position' => 'CEO & Founder',
                'bio' => 'Visionary leader with 15+ years of industry experience. Sarah founded the company with a mission to deliver excellence in every service we provide.',
                'image' => 'https://randomuser.me/api/portraits/women/44.jpg',
                'social_links' => [['icon' => 'mdi:linkedin', 'url' => '#'], ['icon' => 'mdi:twitter', 'url' => '#']],
            ],
            [
                'name' => 'Michael Chen',
                'position' => 'Operations Director',
                'bio' => 'Expert in streamlining processes and maximizing efficiency. Michael ensures our operations run smoothly and our customers receive the best service.',
                'image' => 'https://randomuser.me/api/portraits/men/32.jpg',
                'social_links' => [['icon' => 'mdi:linkedin', 'url' => '#'], ['icon' => 'mdi:twitter', 'url' => '#']],
            ],
            [
                'name' => 'Emily Rodriguez',
                'position' => 'Customer Success Manager',
                'bio' => 'Dedicated to ensuring exceptional customer experiences. Emily leads our support team with empathy and a commitment to solving problems.',
                'image' => 'https://randomuser.me/api/portraits/women/68.jpg',
                'social_links' => [['icon' => 'mdi:linkedin', 'url' => '#'], ['icon' => 'mdi:twitter', 'url' => '#']],
            ],
            [
                'name' => 'David Park',
                'position' => 'Technical Lead',
                'bio' => 'Passionate about innovation and cutting-edge solutions. David drives our technical strategy and ensures we stay ahead of the curve.',
                'image' => 'https://randomuser.me/api/portraits/men/75.jpg',
                'social_links' => [['icon' => 'mdi:linkedin', 'url' => '#'], ['icon' => 'mdi:github', 'url' => '#']],
            ],
        ];

        $this->items = !empty($items) ? $items : $defaultItems;

        $this->section = array_merge(
            [
                'badge' => 'Our Team',
                'title' => 'Meet Our Experts',
                'subtitle' => 'The dedicated professionals behind our success, committed to delivering excellence.',
            ],
            $section,
        );
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }

    protected function view($data = [])
    {
        return app('view')->file('/Users/rajeshkumawat/sites/ant4-laravel12-vue3/storage/framework/views/livewire/views/8558e462.blade.php', $data);
    }

    public function styleModuleSrc()
    {
        return '/Users/rajeshkumawat/sites/ant4-laravel12-vue3/storage/framework/views/livewire/styles/8558e462.css';
    }
};
