<?php

use Livewire\Component;

return new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(
        array $section = [],
        array $items = [],
        array $company = [],
        array $social = [],
        array $services = [],
        bool $isWhiteBackground = false,
        ?int $paddingTop = null,
        ?int $paddingBottom = null
    ) {
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        // Use items from standardized props
        $this->items = !empty($items) ? $items : [
            ['question' => 'How does the pickup and delivery work?', 'answer' => 'Simply schedule a pickup through our website or app. Our driver will arrive at your chosen time slot.'],
            ['question' => 'What if my clothes get damaged?', 'answer' => 'We take utmost care of your garments. In the rare case of damage, we have comprehensive insurance.'],
            ['question' => 'Do you use eco-friendly products?', 'answer' => 'Yes! We use biodegradable, eco-friendly detergents that are gentle on both your clothes and the environment.'],
            ['question' => 'What areas do you serve?', 'answer' => 'We currently serve the entire Washville metropolitan area including downtown and suburbs.'],
            ['question' => 'Can I specify washing instructions?', 'answer' => 'Absolutely! You can add special instructions for each order.'],
            ['question' => 'What payment methods do you accept?', 'answer' => 'We accept all major credit cards, debit cards, and digital wallets.'],
        ];

        $this->section = array_merge([
            'badge' => 'FAQ',
            'title' => 'Frequently Asked Questions',
            'subtitle' => 'Find answers to common questions.',
        ], $section);
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }

    protected function view($data = [])
    {
        return app('view')->file('/Users/rajeshkumawat/sites/ant4-laravel12-vue3/storage/framework/views/livewire/views/8ec5d804.blade.php', $data);
    }
};
