<?php

use Livewire\Component;
use App\Models\Website;
use App\Models\WebsiteLegalPage;
use App\Models\WebsiteLanguage;

return new class extends Component {
    public array $company = [];
    public array $nav = [];
    public array $services = [];
    public array $social = [];
    public array $footer = [];
    public array $section = []; // Database content from getSectionProps
    public $pages = [];
    public ?string $websiteSlug = null;
    public ?string $currentLangKey = 'en';
    public string $homeUrl = '';

    public function mount(array $company = [], array $nav = [], array $services = [], array $social = [], array $footer = [], array $section = [], ?string $websiteSlug = null, ?string $currentLangKey = 'en')
    {
        $this->company = $company;
        $this->nav = $nav;
        $this->services = $services;
        $this->social = $social;
        $this->section = $section;
        $this->websiteSlug = $websiteSlug;
        $this->currentLangKey = $currentLangKey ?? 'en';

        // Merge footer data: section (from database) takes priority, then footer defaults
        // This allows the database content to override defaults from LivewireBaseComponent
        $this->footer = array_merge($footer, array_filter($section, fn($v) => !empty($v)));

        // Generate home URL using global helper (handles is_primary for root URL)
        $frontWebsite = view()->shared('frontWebsite');
        $this->homeUrl = landing_home_url($frontWebsite, $this->websiteSlug);

        // Fetch active front pages filtered by business and language
        $this->loadPages();
    }

    protected function loadPages(): void
    {
        $query = WebsiteLegalPage::withoutGlobalScopes()
            ->where('status', 'active')
            ->where('show_in_footer', true)
            ->orderBy('display_order');

        // Filter by website_id if websiteSlug is provided
        if ($this->websiteSlug) {
            $website = Website::withoutGlobalScopes()->where('slug', $this->websiteSlug)->first();

            if ($website) {
                $query->where('website_id', $website->id);

                // Filter by website_language_id - must match BOTH website_id AND language key
                $lang = WebsiteLanguage::withoutGlobalScopes()
                    ->where('website_id', $website->id)
                    ->where('key', $this->currentLangKey)
                    ->first();

                if ($lang) {
                    $query->where('website_language_id', $lang->id);
                }
            }
        }

        $this->pages = $query->get();
    }

    protected function view($data = [])
    {
        return app('view')->file('/Users/rajeshkumawat/sites/ant4-laravel12-vue3/storage/framework/views/livewire/views/a952bee3.blade.php', $data);
    }

    public function styleModuleSrc()
    {
        return '/Users/rajeshkumawat/sites/ant4-laravel12-vue3/storage/framework/views/livewire/styles/a952bee3.css';
    }
};
