<?php

use Livewire\Component;

return new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(
        array $section = [],
        array $items = [],
        array $company = [],
        array $social = [],
        array $services = [],
        bool $isWhiteBackground = false,
        ?int $paddingTop = null,
        ?int $paddingBottom = null
    ) {
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        // Default partner logos (using placeholder company logos)
        $defaultItems = [
            ['name' => 'TechCorp', 'logo' => 'https://cdn.jsdelivr.net/gh/devicons/devicon/icons/google/google-original.svg'],
            ['name' => 'InnovateCo', 'logo' => 'https://cdn.jsdelivr.net/gh/devicons/devicon/icons/apple/apple-original.svg'],
            ['name' => 'GlobalTech', 'logo' => 'https://cdn.jsdelivr.net/gh/devicons/devicon/icons/microsoft/microsoft-original.svg'],
            ['name' => 'FutureLabs', 'logo' => 'https://cdn.jsdelivr.net/gh/devicons/devicon/icons/amazonwebservices/amazonwebservices-original-wordmark.svg'],
            ['name' => 'SmartSolutions', 'logo' => 'https://cdn.jsdelivr.net/gh/devicons/devicon/icons/slack/slack-original.svg'],
            ['name' => 'NextGen', 'logo' => 'https://cdn.jsdelivr.net/gh/devicons/devicon/icons/github/github-original.svg'],
        ];

        $this->items = !empty($items) ? $items : $defaultItems;

        $this->section = array_merge([
            'badge' => 'Our Partners',
            'title' => 'Trusted by Industry Leaders',
            'subtitle' => 'We collaborate with the best companies to deliver exceptional results.',
            'grayscale' => false, // Default: logos in full color
            'show_title' => false, // Default: hide partner names
        ], $section);
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }

    protected function view($data = [])
    {
        return app('view')->file('/Users/rajeshkumawat/sites/ant4-laravel12-vue3/storage/framework/views/livewire/views/b524aca3.blade.php', $data);
    }

    public function styleModuleSrc()
    {
        return '/Users/rajeshkumawat/sites/ant4-laravel12-vue3/storage/framework/views/livewire/styles/b524aca3.css';
    }
};
