<?php

use Livewire\Component;

return new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(
        array $section = [],
        array $items = [],
        array $company = [],
        array $social = [],
        array $services = [],
        bool $isWhiteBackground = false,
        ?int $paddingTop = null,
        ?int $paddingBottom = null
    ) {
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        $this->section = array_merge([
            'badge' => 'Statistics',
            'title' => 'Our Achievements',
            'subtitle' => 'Numbers that speak for themselves',
        ], $section);

        // Use items from standardized props
        $this->items = !empty($items) ? $items : [
            ['value' => '15000+', 'label' => 'Happy Customers', 'icon' => 'heroicons:users'],
            ['value' => '50000+', 'label' => 'Orders Completed', 'icon' => 'heroicons:check-circle'],
            ['value' => '99%', 'label' => 'Satisfaction Rate', 'icon' => 'heroicons:star'],
            ['value' => '24/7', 'label' => 'Support Available', 'icon' => 'heroicons:clock'],
        ];
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }

    protected function view($data = [])
    {
        return app('view')->file('/Users/rajeshkumawat/sites/ant4-laravel12-vue3/storage/framework/views/livewire/views/be568e03.blade.php', $data);
    }
};
