<?php

use Livewire\Component;

return new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(array $section = [], array $items = [], array $company = [], array $social = [], bool $isWhiteBackground = false, ?int $paddingTop = null, ?int $paddingBottom = null)
    {
        $this->items = $items;
        $this->company = $company;
        $this->social = $social;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        $this->section = array_merge(
            [
                'badge' => 'Contact Us',
                'title' => 'Get In Touch',
                'subtitle' => 'Have questions? We\'re here to help. Reach out to us through any of the channels below.',
                'info_phone_label' => 'Phone',
                'info_email_label' => 'Email',
                'info_address_label' => 'Address',
                'info_hours_label' => 'Business Hours',
                'info_follow_us_label' => 'Follow Us',
                'google_map_url' => '',
                'google_map_link_url' => '',
                'open_in_maps_text' => 'Open in Google Maps',
            ],
            $section,
        );
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }

    protected function view($data = [])
    {
        return app('view')->file('/Users/rajeshkumawat/sites/ant4-laravel12-vue3/storage/framework/views/livewire/views/d3949fd6.blade.php', $data);
    }
};
