<?php

use Livewire\Component;

return new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(array $section = [], array $items = [], array $company = [], array $social = [], array $services = [], bool $isWhiteBackground = false, ?int $paddingTop = null, ?int $paddingBottom = null)
    {
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        $defaultFeatures = [['icon' => 'heroicons:bolt', 'title' => 'Fast & Easy', 'description' => 'Book services in just a few taps'], ['icon' => 'heroicons:bell-alert', 'title' => 'Real-time Updates', 'description' => 'Track your order status live'], ['icon' => 'heroicons:shield-check', 'title' => 'Secure Payments', 'description' => 'Multiple payment options available'], ['icon' => 'heroicons:gift', 'title' => 'Exclusive Offers', 'description' => 'App-only deals and discounts']];

        $this->section = array_merge(
            [
                'badge' => 'Mobile App',
                'title' => 'Download Our App Today',
                'subtitle' => 'Experience convenience at your fingertips',
                'description' => 'Get instant access to all our services right from your smartphone. Available on iOS and Android.',
                'app_image_url' => 'https://www.expertappdevs.com/sitebucket/portfolio/20220329062908-about-image-001.png',
                'cta_buttons' => [['icon' => 'mdi:apple', 'url' => '#', 'text_top' => 'Download on the', 'text_main' => 'App Store'], ['icon' => 'mdi:google-play', 'url' => '#', 'text_top' => 'Get it on', 'text_main' => 'Google Play']],
                'qr_code' => null,
                'qr_label' => 'Scan to Download',
                'qr_description' => 'Point your camera at the QR code to download the app instantly',
                'app_stats' => [['icon' => 'lucide:download', 'value' => '500K+', 'label' => 'Downloads'], ['icon' => 'lucide:star', 'value' => '4.8', 'label' => 'App Rating'], ['icon' => 'lucide:users', 'value' => '100K+', 'label' => 'Happy Users']],
                'trusted_users' => [
                    'enabled' => true,
                    'title' => 'Trusted by %count% users',
                    'subtitle' => 'Join thousands of satisfied customers',
                    'avatars' => [],
                ],
                'features' => [],
            ],
            $section,
        );

        $features = $this->section['features'] ?? ($items ?? $defaultFeatures);

        $this->items = array_map(function ($feature) {
            return [
                'icon' => $feature['icon'] ?? 'heroicons:check',
                'title' => $feature['title'] ?? ($feature['text'] ?? ''),
                'description' => $feature['description'] ?? '',
            ];
        }, $features);
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }

    protected function view($data = [])
    {
        return app('view')->file('/Users/rajeshkumawat/sites/ant4-laravel12-vue3/storage/framework/views/livewire/views/e43ae979.blade.php', $data);
    }

    public function styleModuleSrc()
    {
        return '/Users/rajeshkumawat/sites/ant4-laravel12-vue3/storage/framework/views/livewire/styles/e43ae979.css';
    }
};
