<?php

use Livewire\Component;

return new class extends Component {
    public array $section = [];
    public array $items = [];
    public array $company = [];
    public array $social = [];
    public array $services = [];
    public bool $isWhiteBackground = false;
    public ?int $paddingTop = null;
    public ?int $paddingBottom = null;

    public function mount(
        array $section = [],
        array $items = [],
        array $company = [],
        array $social = [],
        array $services = [],
        bool $isWhiteBackground = false,
        ?int $paddingTop = null,
        ?int $paddingBottom = null
    ) {
        $this->company = $company;
        $this->social = $social;
        $this->services = $services;
        $this->isWhiteBackground = $isWhiteBackground;
        $this->paddingTop = $paddingTop;
        $this->paddingBottom = $paddingBottom;

        // Use items from standardized props
        $this->items = !empty($items) ? $items : [
            ['name' => 'Sarah Johnson', 'role' => 'Working Professional', 'avatar' => 'https://randomuser.me/api/portraits/women/1.jpg', 'rating' => 5, 'text' => 'SparkleWash has been a lifesaver! As a busy professional, I no longer worry about laundry.'],
            ['name' => 'Michael Chen', 'role' => 'Restaurant Owner', 'avatar' => 'https://randomuser.me/api/portraits/men/2.jpg', 'rating' => 5, 'text' => 'We use SparkleWash for all our restaurant linens. The quality is exceptional.'],
            ['name' => 'Emily Rodriguez', 'role' => 'Mother of Three', 'avatar' => 'https://randomuser.me/api/portraits/women/3.jpg', 'rating' => 5, 'text' => 'With three kids, laundry used to be never-ending. Now SparkleWash handles it all.'],
            ['name' => 'David Park', 'role' => 'Hotel Manager', 'avatar' => 'https://randomuser.me/api/portraits/men/4.jpg', 'rating' => 5, 'text' => 'Our hotel has partnered with SparkleWash for over 2 years. Their reliability is exceptional.'],
        ];

        $this->section = array_merge([
            'badge' => 'Testimonials',
            'title' => 'What Our Customers Say',
            'subtitle' => 'Don\'t just take our word for it.',
        ], $section);
    }

    public function getCustomPaddingStyle(): string
    {
        $styles = [];
        if ($this->paddingTop !== null) {
            $styles[] = "padding-top: {$this->paddingTop}px";
        }
        if ($this->paddingBottom !== null) {
            $styles[] = "padding-bottom: {$this->paddingBottom}px";
        }
        return !empty($styles) ? implode('; ', $styles) : '';
    }

    protected function view($data = [])
    {
        return app('view')->file('/Users/rajeshkumawat/sites/ant4-laravel12-vue3/storage/framework/views/livewire/views/ec3feab2.blade.php', $data);
    }
};
