<?php
use Livewire\Component;
?>

<section class="{{ $this->getDefaultPaddingClasses() }} {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}" @if($this->getPaddingStyle()) style="{{ $this->getPaddingStyle() }}" @endif>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-2 md:grid-cols-4 gap-8">
            @foreach ($items as $index => $feature)
                <div class="scroll-animate flex items-center gap-4">
                    <div
                        class="w-14 h-14 rounded-xl bg-primary-100 dark:bg-primary-900/30 flex items-center justify-center flex-shrink-0">
                        <x-icon icon="{{ $feature['icon'] ?? 'heroicons:heart' }}" class="w-7 h-7 text-primary-600" />
                    </div>
                    <div>
                        <h3 class="font-semibold text-gray-900 dark:text-white">{{ $feature['title'] }}</h3>
                        <p class="text-sm text-gray-600 dark:text-gray-400">{{ $feature['description'] }}</p>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>