<?php
use Livewire\Component;
?>

<div>
<section class="features-cards-section {{ $isWhiteBackground ? 'features-cards-white' : 'features-cards-gray' }}" @if($this->getPaddingStyle()) style="{{ $this->getPaddingStyle() }}" @endif>
    {{-- Background Decorations --}}
    <div class="features-cards-bg">
        <div class="features-cards-circle features-cards-circle-1"></div>
        <div class="features-cards-circle features-cards-circle-2"></div>
    </div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative">
        <div class="features-cards-grid">
            @foreach ($items as $index => $feature)
                <div class="features-cards-item scroll-animate" style="animation-delay: {{ $index * 100 }}ms">
                    <div class="features-cards-inner">
                        {{-- Gradient Background --}}
                        <div class="features-cards-gradient"></div>

                        {{-- Icon --}}
                        <div class="features-cards-icon-wrapper">
                            <div class="features-cards-icon">
                                <x-icon icon="{{ $feature['icon'] ?? 'heroicons:heart' }}" class="w-8 h-8" />
                            </div>
                            <div class="features-cards-icon-glow"></div>
                        </div>

                        {{-- Content --}}
                        <div class="features-cards-content">
                            <h3 class="features-cards-title">{{ $feature['title'] }}</h3>
                            <p class="features-cards-desc">{{ $feature['description'] }}</p>
                        </div>

                        {{-- Decorative Corner --}}
                        <div class="features-cards-corner"></div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>


</div>