<?php
use Livewire\Component;
?>

{{-- Contact Section 2: Card Grid with Gradient Background --}}
<section id="contact"
    class="section relative overflow-hidden {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}"
    @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>

    {{-- Background Decorative Elements --}}
    <div class="absolute inset-0 overflow-hidden pointer-events-none">
        <div class="absolute -top-40 -right-40 w-80 h-80 bg-gradient-to-br from-primary-500/10 to-secondary-500/10 rounded-full blur-3xl"></div>
        <div class="absolute -bottom-40 -left-40 w-80 h-80 bg-gradient-to-tr from-secondary-500/10 to-primary-500/10 rounded-full blur-3xl"></div>
        {{-- Geometric Shapes --}}
        <div class="absolute top-20 left-10 w-20 h-20 border-2 border-primary-200 dark:border-primary-800 rounded-lg rotate-12 opacity-50"></div>
        <div class="absolute bottom-32 right-20 w-16 h-16 border-2 border-secondary-200 dark:border-secondary-800 rounded-full opacity-50"></div>
        <div class="absolute top-1/2 right-10 w-8 h-8 bg-primary-200 dark:bg-primary-800 rounded-full opacity-30"></div>
    </div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
        {{-- Header --}}
        <div class="text-center mb-16">
            <span class="badge badge-primary mb-4">{{ $section['badge'] }}</span>
            <h2 class="section-title">{{ $section['title'] }}</h2>
            <p class="section-subtitle max-w-2xl mx-auto">{{ $section['subtitle'] }}</p>
        </div>

        {{-- Contact Cards Grid --}}
        <div class="grid sm:grid-cols-2 lg:grid-cols-4 gap-6 mb-12">
            {{-- Phone Card --}}
            <div class="group bg-white dark:bg-gray-800 rounded-2xl p-6 shadow-lg hover:shadow-xl transition-all duration-300 border border-gray-100 dark:border-gray-700 hover:border-primary-200 dark:hover:border-primary-700 hover:-translate-y-1">
                <div class="w-14 h-14 rounded-2xl bg-gradient-to-br from-primary-500 to-primary-600 flex items-center justify-center mb-5 group-hover:scale-110 transition-transform duration-300">
                    <x-icon icon="heroicons:phone" class="w-7 h-7 text-white" />
                </div>
                <h3 class="font-bold text-gray-900 dark:text-white text-lg mb-2">{{ $section['info_phone_label'] }}</h3>
                <a href="tel:{{ $company['phone'] }}" class="text-gray-600 dark:text-gray-400 hover:text-primary-600 dark:hover:text-primary-400 transition-colors text-sm">
                    {{ $company['phone'] }}
                </a>
            </div>

            {{-- Email Card --}}
            <div class="group bg-white dark:bg-gray-800 rounded-2xl p-6 shadow-lg hover:shadow-xl transition-all duration-300 border border-gray-100 dark:border-gray-700 hover:border-primary-200 dark:hover:border-primary-700 hover:-translate-y-1">
                <div class="w-14 h-14 rounded-2xl bg-gradient-to-br from-secondary-500 to-secondary-600 flex items-center justify-center mb-5 group-hover:scale-110 transition-transform duration-300">
                    <x-icon icon="heroicons:envelope" class="w-7 h-7 text-white" />
                </div>
                <h3 class="font-bold text-gray-900 dark:text-white text-lg mb-2">{{ $section['info_email_label'] }}</h3>
                <a href="mailto:{{ $company['email'] }}" class="text-gray-600 dark:text-gray-400 hover:text-primary-600 dark:hover:text-primary-400 transition-colors text-sm break-all">
                    {{ $company['email'] }}
                </a>
            </div>

            {{-- Address Card --}}
            <div class="group bg-white dark:bg-gray-800 rounded-2xl p-6 shadow-lg hover:shadow-xl transition-all duration-300 border border-gray-100 dark:border-gray-700 hover:border-primary-200 dark:hover:border-primary-700 hover:-translate-y-1">
                <div class="w-14 h-14 rounded-2xl bg-gradient-to-br from-primary-500 to-secondary-500 flex items-center justify-center mb-5 group-hover:scale-110 transition-transform duration-300">
                    <x-icon icon="heroicons:map-pin" class="w-7 h-7 text-white" />
                </div>
                <h3 class="font-bold text-gray-900 dark:text-white text-lg mb-2">{{ $section['info_address_label'] }}</h3>
                <p class="text-gray-600 dark:text-gray-400 text-sm">{{ $company['address'] }}</p>
            </div>

            {{-- Hours Card --}}
            <div class="group bg-white dark:bg-gray-800 rounded-2xl p-6 shadow-lg hover:shadow-xl transition-all duration-300 border border-gray-100 dark:border-gray-700 hover:border-primary-200 dark:hover:border-primary-700 hover:-translate-y-1">
                <div class="w-14 h-14 rounded-2xl bg-gradient-to-br from-secondary-500 to-primary-500 flex items-center justify-center mb-5 group-hover:scale-110 transition-transform duration-300">
                    <x-icon icon="heroicons:clock" class="w-7 h-7 text-white" />
                </div>
                <h3 class="font-bold text-gray-900 dark:text-white text-lg mb-2">{{ $section['info_hours_label'] }}</h3>
                <p class="text-gray-600 dark:text-gray-400 text-sm">{{ $company['hours'] }}</p>
            </div>
        </div>

        {{-- Map and Social Section --}}
        <div class="grid lg:grid-cols-3 gap-8">
            {{-- Google Map --}}
            <div class="lg:col-span-2 bg-white dark:bg-gray-800 rounded-2xl overflow-hidden shadow-lg border border-gray-100 dark:border-gray-700">
                <div class="relative w-full h-[350px]">
                    <iframe src="{{ $section['google_map_url'] }}" width="100%" height="100%" style="border:0;"
                        allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"
                        class="absolute inset-0">
                    </iframe>
                </div>
                <div class="p-4 border-t border-gray-100 dark:border-gray-700 bg-gray-50 dark:bg-gray-800/50">
                    <a href="{{ $section['google_map_link_url'] }}" target="_blank"
                        class="inline-flex items-center gap-2 text-primary-600 hover:text-primary-700 text-sm font-medium transition-colors">
                        <x-icon icon="heroicons:arrow-top-right-on-square" class="w-4 h-4" />
                        {{ $section['open_in_maps_text'] }}
                    </a>
                </div>
            </div>

            {{-- Social Links Card --}}
            @if (($social['show_icon'] ?? true) && count($social ?? []) > 0)
                <div class="bg-gradient-to-br from-primary-600 to-secondary-600 rounded-2xl p-8 text-white shadow-lg">
                    <h3 class="font-bold text-2xl mb-4">{{ $section['info_follow_us_label'] }}</h3>
                    <p class="text-white/80 mb-8 text-sm">Connect with us on social media for updates, tips, and exclusive offers.</p>
                    <div class="flex flex-wrap gap-4">
                        @foreach ($social as $key => $link)
                            @if ($key !== 'show_icon' && is_array($link))
                                <a href="{{ $link['url'] }}" target="_blank" rel="noopener noreferrer"
                                    class="w-12 h-12 rounded-xl bg-white/20 backdrop-blur-sm flex items-center justify-center hover:bg-white hover:text-primary-600 transition-all duration-300 hover:scale-110">
                                    <x-icon icon="{{ $link['icon'] ?? 'mdi:link' }}" class="w-6 h-6" />
                                </a>
                            @endif
                        @endforeach
                    </div>
                </div>
            @endif
        </div>
    </div>
</section>