<?php
use Livewire\Component;
?>

<div>
<section class="pricing-modern-section {{ $isWhiteBackground ? 'pricing-modern-white' : 'pricing-modern-gray' }}" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    {{-- Background Shapes --}}
    <div class="pricing-modern-bg">
        <div class="pricing-modern-shape pricing-modern-shape-1"></div>
        <div class="pricing-modern-shape pricing-modern-shape-2"></div>
        <div class="pricing-modern-circle"></div>
    </div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative">
        {{-- Section Header --}}
        <div class="text-center mb-16">
            <span class="pricing-modern-badge">{{ $section['badge'] }}</span>
            <h2 class="pricing-modern-title">{{ $section['title'] }}</h2>
            <p class="pricing-modern-subtitle">{{ $section['subtitle'] }}</p>
        </div>

        {{-- Pricing Cards --}}
        <div class="pricing-modern-grid">
            @foreach ($items as $index => $plan)
                <div class="pricing-modern-card scroll-animate {{ $plan['popular'] ? 'pricing-modern-card-popular' : '' }}" style="animation-delay: {{ $index * 100 }}ms">
                    @if ($plan['popular'])
                        <div class="pricing-modern-popular-badge">
                            <x-icon icon="lucide:star" class="w-3 h-3" />
                            <span>{{ $section['popular_badge'] }}</span>
                        </div>
                    @endif

                    {{-- Card Header --}}
                    <div class="pricing-modern-header">
                        <div class="pricing-modern-icon">
                            <x-icon icon="{{ $index === 0 ? 'lucide:user' : ($index === 1 ? 'lucide:users' : 'lucide:building-2') }}" class="w-8 h-8" />
                        </div>
                        <h3 class="pricing-modern-plan-name">{{ $plan['name'] }}</h3>
                        <p class="pricing-modern-plan-desc">{{ $plan['description'] }}</p>
                    </div>

                    {{-- Price --}}
                    <div class="pricing-modern-price-container">
                        <div class="pricing-modern-price-wrap">
                            <span class="pricing-modern-currency">{{ $section['currency_symbol'] ?? '$' }}</span>
                            <span class="pricing-modern-price">{{ $plan['price'] }}</span>
                        </div>
                        <span class="pricing-modern-period">/{{ $plan['period'] }}</span>
                    </div>

                    {{-- Features --}}
                    <ul class="pricing-modern-features">
                        @foreach ($plan['features'] as $feature)
                            @php
                                $isIncluded = $feature['is_included'] ?? true;
                            @endphp
                            <li class="pricing-modern-feature {{ !$isIncluded ? 'pricing-modern-feature-excluded' : '' }}">
                                <span class="pricing-modern-feature-icon {{ !$isIncluded ? 'pricing-modern-feature-icon-excluded' : '' }}">
                                    @if (!empty($feature['icon']))
                                        <x-icon icon="{{ $feature['icon'] }}" class="w-4 h-4" />
                                    @else
                                        <x-icon icon="{{ $isIncluded ? 'lucide:check' : 'lucide:x' }}" class="w-4 h-4" />
                                    @endif
                                </span>
                                <span class="pricing-modern-feature-text">{{ $feature['text'] }}</span>
                            </li>
                        @endforeach
                    </ul>

                    {{-- CTA Button --}}
                    <a href="{{ $section['cta_button_url'] ?? '#contact' }}" class="pricing-modern-button">
                        <span>{{ $section['cta_button'] }}</span>
                        <x-icon icon="lucide:arrow-right" class="w-4 h-4" />
                    </a>

                    {{-- Decorative Element --}}
                    <div class="pricing-modern-decoration"></div>
                </div>
            @endforeach
        </div>
    </div>
</section>


</div>