<?php
use Livewire\Component;
?>

<div>
    <section class="hero6-section" @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
        {{-- Background Grid --}}
        <div class="hero6-bg-grid"></div>

        {{-- Floating Orbs --}}
        <div class="hero6-orb hero6-orb-1"></div>
        <div class="hero6-orb hero6-orb-2"></div>
        <div class="hero6-orb hero6-orb-3"></div>

        <div class="hero6-container">
            {{-- Content Area --}}
            <div class="hero6-content animate-fade-in-up">
                {{-- Badge --}}
                <div class="hero6-badge">
                    <span class="hero6-badge-icon">
                        <svg class="w-3 h-3 text-primary-600" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd"
                                d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                                clip-rule="evenodd"></path>
                        </svg>
                    </span>
                    <span>{{ $hero['badge'] }}</span>
                </div>

                {{-- Title --}}
                <h1 class="hero6-title">
                    {{ $hero['title'] }}
                    <span class="hero6-subtitle">{{ $hero['subtitle'] }}</span>
                </h1>

                {{-- Description --}}
                <p class="hero6-description">{{ $hero['description'] }}</p>

                {{-- CTA Buttons --}}
                <div class="hero6-cta-group">
                    @foreach ($hero['buttons'] ?? [] as $index => $button)
                        @if ($button['is_transparent'] ?? false)
                            <a href="{{ $button['url'] ?? '#' }}" class="hero6-btn-secondary">
                                @if (!empty($button['text']))
                                    <span>{{ $button['text'] }}</span>
                                @endif
                                @if (!empty($button['icon']))
                                    <x-icon icon="{{ $button['icon'] }}" class="w-5 h-5" />
                                @endif
                            </a>
                        @else
                            <a href="{{ $button['url'] ?? '#' }}" class="hero6-btn-primary">
                                @if (!empty($button['icon']))
                                    <x-icon icon="{{ $button['icon'] }}" class="w-5 h-5" />
                                @endif
                                @if (!empty($button['text']))
                                    <span>{{ $button['text'] }}</span>
                                @endif
                            </a>
                        @endif
                    @endforeach
                </div>

                {{-- Stats --}}
                @if (!empty($hero['stats']))
                    <div class="hero6-stats">
                        @foreach ($hero['stats'] as $stat)
                            <div class="hero6-stat-item">
                                @if (!empty($stat['icon']))
                                    <div class="hero6-stat-icon">
                                        <x-icon icon="{{ $stat['icon'] }}" class="w-5 h-5" />
                                    </div>
                                @endif
                                <div>
                                    <div class="hero6-stat-value">{{ $stat['value'] }}</div>
                                    <div class="hero6-stat-label">{{ $stat['label'] }}</div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @endif
            </div>

            {{-- Card Stack --}}
            <div class="hero6-card-stack animate-fade-in-up delay-200">
                {{-- Background Card --}}
                <div class="hero6-bg-card"></div>

                {{-- Main Card --}}
                <div class="hero6-main-card">
                    <div class="hero6-card-image">
                        <img src="{{ $hero['hero_image_url'] ?? ($hero['hero_image'] ?? 'https://images.unsplash.com/photo-1545173168-9f1947eebb7f?w=600&h=500&fit=crop') }}"
                            alt="Professional Laundry Service" loading="lazy">
                        <div class="hero6-card-badge">
                            <svg class="w-3 h-3" fill="currentColor" viewBox="0 0 20 20">
                                <path
                                    d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z">
                                </path>
                            </svg>
                            {{ $hero['badge'] }}
                        </div>
                    </div>
                    <div class="hero6-card-content">
                        <h3 class="hero6-card-title">{{ $hero['title'] }}</h3>
                        <p class="hero6-card-subtitle">{{ $hero['subtitle'] }}</p>
                        @if (!empty($hero['floating_cards']))
                            <div class="hero6-card-features">
                                @foreach ($hero['floating_cards'] as $card)
                                    <div class="hero6-card-feature">
                                        <span class="hero6-card-feature-icon">
                                            <x-icon icon="{{ $card['icon'] ?? 'heroicons:check' }}" class="w-3 h-3" />
                                        </span>
                                        {{ $card['title'] ?? '' }} {{ $card['subtitle'] ?? '' }}
                                    </div>
                                @endforeach
                            </div>
                        @endif
                    </div>
                </div>

                {{-- Floating Cards --}}
                @foreach ($hero['floating_cards'] ?? [] as $index => $card)
                    <div
                        class="hero6-float-card hero6-float-card-{{ $index + 1 }} animate-bounce-soft {{ $index > 0 ? 'delay-300' : '' }}">
                        <div class="hero6-float-icon {{ $index === 0 ? 'green' : 'blue' }}">
                            <x-icon icon="{{ $card['icon'] ?? 'heroicons:check' }}" class="w-5 h-5 text-white" />
                        </div>
                        <div>
                            <p class="hero6-float-title">{{ $card['title'] ?? '' }}</p>
                            <p class="hero6-float-subtitle">{{ $card['subtitle'] ?? '' }}</p>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>

        {{-- Wave Bottom --}}
        <div class="hero6-wave">
            <svg viewBox="0 0 1440 120" fill="none" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none">
                <path
                    d="M0 120L48 108C96 96 192 72 288 60C384 48 480 48 576 54C672 60 768 72 864 78C960 84 1056 84 1152 78C1248 72 1344 60 1392 54L1440 48V120H1392C1344 120 1248 120 1152 120C1056 120 960 120 864 120C768 120 672 120 576 120C480 120 384 120 288 120C192 120 96 120 48 120H0Z"
                    class="hero6-wave-fill" />
            </svg>
        </div>
    </section>


    

</div>