<?php
use Livewire\Component;
?>

<div>
    


    <section id="app-download"
        class="app-centered-section section {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}"
        @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
        {{-- Decorative Elements --}}
        <div class="app-deco-ring app-deco-ring-1"></div>
        <div class="app-deco-ring app-deco-ring-2"></div>
        <div class="app-deco-ring app-deco-ring-3"></div>
        <div class="app-dot-pattern app-dot-pattern-1"></div>
        <div class="app-dot-pattern app-dot-pattern-2"></div>

        <div class="relative z-10 max-w-5xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            {{-- Header --}}
            <div class="scroll-animate mb-8" data-animation="fade-up">
                <span class="badge badge-primary mb-4">{{ $section['badge'] }}</span>

                <h2 class="section-title">{{ $section['title'] }}</h2>

                @if (!empty($section['subtitle']))
                    <p class="text-lg text-primary-600 dark:text-primary-400 font-medium mb-3">
                        {{ $section['subtitle'] }}
                    </p>
                @endif

                @if (!empty($section['description']))
                    <p class="text-gray-600 dark:text-gray-300 max-w-2xl mx-auto mb-6">
                        {!! strip_tags($section['description']) !!}
                    </p>
                @endif
            </div>

            {{-- Phone Mockup --}}
            <div class="scroll-animate mb-8" data-animation="fade-up">
                @php $appImageUrl = $section['app_image_url'] ?? $section['app_image'] ?? null; @endphp
                <div class="app-phone-container mx-auto">
                    <div class="app-phone-shadow"></div>
                    @if ($appImageUrl)
                        <div class="app-centered-mockup">
                            <img src="{{ $appImageUrl }}" alt="{{ $section['title'] }}"
                                class="max-w-[200px] sm:max-w-[240px] w-full h-auto drop-shadow-2xl rounded-3xl mx-auto"
                                loading="lazy">
                        </div>
                    @else
                        <div
                            class="app-centered-mockup bg-gradient-to-br from-primary-500 to-primary-700 rounded-[2rem] p-3 max-w-[200px] sm:max-w-[240px] mx-auto shadow-2xl">
                            <div
                                class="bg-white dark:bg-gray-800 rounded-[1.5rem] aspect-[9/19] flex items-center justify-center">
                                <x-icon icon="heroicons:device-phone-mobile"
                                    class="w-12 h-12 text-gray-300 dark:text-gray-600" />
                            </div>
                        </div>
                    @endif
                </div>
            </div>

            {{-- Download Buttons --}}
            @php
                $ctaButtons = $section['cta_buttons'] ?? [];
                if (empty($ctaButtons) && (!empty($section['app_store_url']) || !empty($section['play_store_url']))) {
                    $ctaButtons = [];
                    if (!empty($section['app_store_url'])) {
                        $ctaButtons[] = [
                            'icon' => 'mdi:apple',
                            'url' => $section['app_store_url'],
                            'text_top' => $section['app_store_text_top'] ?? 'Download on the',
                            'text_main' => $section['app_store_text_main'] ?? 'App Store',
                        ];
                    }
                    if (!empty($section['play_store_url'])) {
                        $ctaButtons[] = [
                            'icon' => 'mdi:google-play',
                            'url' => $section['play_store_url'],
                            'text_top' => $section['play_store_text_top'] ?? 'Get it on',
                            'text_main' => $section['play_store_text_main'] ?? 'Google Play',
                        ];
                    }
                }
            @endphp
            @if (count($ctaButtons) > 0)
                <div class="scroll-animate flex flex-wrap justify-center gap-4 mb-8" data-animation="fade-up">
                    @foreach ($ctaButtons as $index => $button)
                        @if (!empty($button['url']))
                            <a href="{{ $button['url'] }}" target="_blank" rel="noopener"
                                class="{{ $index === 0 ? 'store-btn-primary' : 'store-btn-secondary' }} inline-flex items-center gap-3 px-5 py-3 rounded-xl shadow-lg">
                                <x-icon icon="{{ $button['icon'] ?? 'heroicons:device-phone-mobile' }}"
                                    class="w-7 h-7" />
                                <div class="text-left">
                                    <div class="text-xs opacity-80">{{ $button['text_top'] ?? '' }}</div>
                                    <div class="text-base font-semibold -mt-0.5">{{ $button['text_main'] ?? '' }}</div>
                                </div>
                            </a>
                        @endif
                    @endforeach
                </div>
            @endif

            {{-- Features as Cards --}}
            @if (count($items) > 0)
                <div class="scroll-animate grid grid-cols-2 sm:grid-cols-4 gap-4 mb-8 max-w-3xl mx-auto"
                    data-animation="fade-up">
                    @foreach ($items as $feature)
                        <div class="app-feature-card">
                            <div class="app-feature-icon-box">
                                <x-icon icon="{{ $feature['icon'] ?? 'heroicons:check' }}" class="app-feature-icon" />
                            </div>
                            <div class="app-feature-title">{{ $feature['title'] ?? '' }}</div>
                            @if (!empty($feature['description']))
                                <div class="app-feature-desc">{{ $feature['description'] }}</div>
                            @endif
                        </div>
                    @endforeach
                </div>
            @endif

            {{-- Stats --}}
            @php $appStats = $section['app_stats'] ?? []; @endphp
            @if (count($appStats) > 0)
                <div class="scroll-animate grid grid-cols-{{ count($appStats) }} gap-4 max-w-lg mx-auto mb-8"
                    data-animation="fade-up">
                    @foreach ($appStats as $stat)
                        <div class="app-stat-box">
                            <div class="flex items-center justify-center gap-1 mb-1">
                                @if (!empty($stat['icon']))
                                    <x-icon icon="{{ $stat['icon'] }}" class="w-5 h-5 text-primary-500" />
                                @endif
                                <span class="app-stat-value text-xl font-bold">{{ $stat['value'] ?? '' }}</span>
                            </div>
                            <div class="app-stat-label text-xs">{{ $stat['label'] ?? '' }}</div>
                        </div>
                    @endforeach
                </div>
            @endif

            {{-- Trusted Users --}}
            @php
                $trustedUsers = $section['trusted_users'] ?? [];
                $trustedUsersEnabled = $trustedUsers['enabled'] ?? false;
                $userAvatars = $trustedUsers['avatars'] ?? [];
                $trustedUsersCount = count($userAvatars) > 0 ? number_format(count($userAvatars) * 1000) : '10,000+';
                $trustedTitle = $trustedUsers['title'] ?? 'Trusted by %count% users';
                $trustedTitle = str_replace('%count%', $trustedUsersCount, $trustedTitle);
                $trustedSubtitle = $trustedUsers['subtitle'] ?? 'Join thousands of satisfied customers';
            @endphp
            @if ($trustedUsersEnabled)
                <div class="scroll-animate flex justify-center mb-8" data-animation="fade-up">
                    <div class="app-centered-trusted">
                        {{-- Avatar Stack --}}
                        @if (count($userAvatars) > 0)
                            <div class="flex -space-x-2">
                                @foreach (array_slice($userAvatars, 0, 5) as $index => $avatar)
                                    @php
                                        $avatarUrl = is_array($avatar)
                                            ? $avatar['image_url'] ?? ($avatar['image'] ?? null)
                                            : $avatar;
                                        $avatarName = is_array($avatar) ? $avatar['name'] ?? 'User' : 'User';
                                    @endphp
                                    @if ($avatarUrl)
                                        <img src="{{ $avatarUrl }}" alt="{{ $avatarName }}"
                                            title="{{ $avatarName }}"
                                            class="w-8 h-8 rounded-full border-2 border-white dark:border-gray-700 object-cover"
                                            loading="lazy">
                                    @endif
                                @endforeach
                            </div>
                        @endif

                        {{-- Trusted Text --}}
                        <div class="text-left">
                            <p class="app-centered-trusted-text">{{ $trustedTitle }}</p>
                            <p class="app-centered-trusted-sub">{{ $trustedSubtitle }}</p>
                        </div>
                    </div>
                </div>
            @endif

            {{-- QR Code --}}
            @php $qrCodeUrl = $section['qr_code_url'] ?? $section['qr_code'] ?? null; @endphp
            @if ($qrCodeUrl)
                <div class="scroll-animate flex justify-center" data-animation="fade-up">
                    <div class="app-centered-qr">
                        <div class="app-centered-qr-image flex-shrink-0">
                            <img src="{{ $qrCodeUrl }}" alt="QR Code" class="w-16 h-16 object-contain"
                                loading="lazy">
                        </div>
                        <div class="text-left">
                            <p class="app-centered-qr-title">{{ $section['qr_label'] ?? 'Scan to Download' }}</p>
                            <p class="app-centered-qr-desc">
                                {{ $section['qr_description'] ?? 'Point your camera at the QR code' }}</p>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </section>
</div>