<?php
use Livewire\Component;
?>

<section class="py-20 gradient-hero relative overflow-hidden" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    <div class="absolute inset-0 overflow-hidden">
        <div class="floating-element w-64 h-64 bg-white -top-32 -right-32 animate-float"></div>
        <div class="floating-element w-48 h-48 bg-white bottom-0 left-1/4 animate-float delay-300"></div>
    </div>

    <div class="relative max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <h2 class="text-3xl sm:text-4xl font-bold text-white mb-6">{{ $section['title'] }}</h2>
        <p class="text-xl text-white/90 mb-8">{{ $section['subtitle'] }}</p>
        <div class="flex flex-wrap justify-center gap-4">
            <a href="#contact" class="btn btn-white">
                {{ $section['primary_button'] }}
            </a>
            <a href="tel:{{ $company['phone'] }}" class="btn btn-outline-white">
                <x-icon icon="heroicons:phone" class="w-5 h-5 mr-2" />
                {{ $section['secondary_button'] }}
            </a>
        </div>
    </div>
</section>