<?php
use Livewire\Component;
?>

<div>
<section id="services" class="services-zigzag-section {{ $isWhiteBackground ? 'services-zigzag-white' : 'services-zigzag-gray' }}" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    {{-- Background Elements --}}
    <div class="services-zigzag-bg">
        <div class="services-zigzag-wave services-zigzag-wave-1"></div>
        <div class="services-zigzag-wave services-zigzag-wave-2"></div>
        <div class="services-zigzag-dot services-zigzag-dot-1"></div>
        <div class="services-zigzag-dot services-zigzag-dot-2"></div>
        <div class="services-zigzag-dot services-zigzag-dot-3"></div>
    </div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative">
        {{-- Section Header --}}
        <div class="services-zigzag-header">
            <div class="services-zigzag-badge">
                <span class="services-zigzag-badge-icon">
                    <x-icon icon="lucide:layers" class="w-4 h-4" />
                </span>
                {{ $section['badge'] }}
            </div>
            <h2 class="services-zigzag-title">{{ $section['title'] }}</h2>
            <p class="services-zigzag-subtitle">{{ $section['subtitle'] }}</p>
        </div>

        {{-- Zigzag Items --}}
        <div class="services-zigzag-list">
            @foreach ($items as $index => $item)
                <div class="services-zigzag-item scroll-animate {{ $index % 2 === 1 ? 'services-zigzag-item-reverse' : '' }}" style="animation-delay: {{ $index * 150 }}ms">
                    {{-- Content Side --}}
                    <div class="services-zigzag-content">
                        <div class="services-zigzag-number">{{ str_pad($index + 1, 2, '0', STR_PAD_LEFT) }}</div>
                        <h3 class="services-zigzag-item-title">{{ $item['title'] ?? '' }}</h3>
                        <p class="services-zigzag-desc">{{ $item['description'] ?? '' }}</p>

                        @if (!empty($item['features']))
                            <div class="services-zigzag-features">
                                @foreach ($item['features'] as $feature)
                                    <div class="services-zigzag-feature">
                                        <x-icon icon="lucide:check-circle-2" class="w-5 h-5" />
                                        <span>{{ is_array($feature) ? ($feature['text'] ?? '') : $feature }}</span>
                                    </div>
                                @endforeach
                            </div>
                        @endif

                        <div class="services-zigzag-footer">
                            @if (!empty($item['price']))
                                <div class="services-zigzag-price">{{ $item['price'] }}</div>
                            @endif
                            @if (!empty($item['button_text']) && !empty($item['button_url']))
                                <a href="{{ $item['button_url'] }}" class="services-zigzag-btn">
                                    <span>{{ $item['button_text'] }}</span>
                                    <x-icon icon="{{ $item['button_icon'] ?? 'lucide:arrow-right' }}" class="w-4 h-4" />
                                </a>
                            @endif
                        </div>
                    </div>

                    {{-- Icon Side --}}
                    <div class="services-zigzag-visual">
                        <div class="services-zigzag-icon-wrapper">
                            <div class="services-zigzag-icon-bg"></div>
                            <div class="services-zigzag-icon">
                                <x-icon icon="{{ $item['icon'] ?? 'heroicons:sparkles' }}" class="w-12 h-12" />
                            </div>
                            <div class="services-zigzag-icon-ring"></div>
                            <div class="services-zigzag-icon-dots">
                                <span></span><span></span><span></span>
                            </div>
                        </div>
                    </div>

                    {{-- Connector Line --}}
                    @if (!$loop->last)
                        <div class="services-zigzag-connector"></div>
                    @endif
                </div>
            @endforeach
        </div>
    </div>
</section>


</div>