<?php
use Livewire\Component;
?>

<div>
<section id="services" class="services-timeline-section {{ $isWhiteBackground ? 'services-timeline-white' : 'services-timeline-gray' }}" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    {{-- Background Elements --}}
    <div class="services-timeline-bg">
        <div class="services-timeline-shape services-timeline-shape-1"></div>
        <div class="services-timeline-shape services-timeline-shape-2"></div>
        <div class="services-timeline-shape services-timeline-shape-3"></div>
    </div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative">
        {{-- Section Header --}}
        <div class="services-timeline-header">
            <div class="services-timeline-badge">
                <span class="services-timeline-badge-dot"></span>
                {{ $section['badge'] }}
            </div>
            <h2 class="services-timeline-title">{{ $section['title'] }}</h2>
            <p class="services-timeline-subtitle">{{ $section['subtitle'] }}</p>
        </div>

        {{-- Timeline Container --}}
        <div class="services-timeline-container">
            {{-- Central Line --}}
            <div class="services-timeline-line">
                <div class="services-timeline-line-progress"></div>
            </div>

            {{-- Timeline Items --}}
            @foreach ($items as $index => $item)
                <div class="services-timeline-item scroll-animate {{ $index % 2 === 0 ? 'services-timeline-item-left' : 'services-timeline-item-right' }}" style="animation-delay: {{ $index * 150 }}ms">
                    {{-- Timeline Node --}}
                    <div class="services-timeline-node">
                        <div class="services-timeline-node-outer">
                            <div class="services-timeline-node-inner">
                                <span>{{ str_pad($index + 1, 2, '0', STR_PAD_LEFT) }}</span>
                            </div>
                        </div>
                        <div class="services-timeline-node-pulse"></div>
                    </div>

                    {{-- Card --}}
                    <div class="services-timeline-card">
                        <div class="services-timeline-card-arrow"></div>
                        <div class="services-timeline-card-inner">
                            {{-- Icon --}}
                            <div class="services-timeline-icon">
                                <x-icon icon="{{ $item['icon'] ?? 'heroicons:sparkles' }}" class="w-6 h-6" />
                            </div>

                            {{-- Content --}}
                            <div class="services-timeline-content">
                                <div class="services-timeline-content-header">
                                    <h3 class="services-timeline-card-title">{{ $item['title'] ?? '' }}</h3>
                                    @if (!empty($item['price']))
                                        <div class="services-timeline-price">{{ $item['price'] }}</div>
                                    @endif
                                </div>
                                <p class="services-timeline-desc">{{ $item['description'] ?? '' }}</p>

                                {{-- Features --}}
                                @if (!empty($item['features']))
                                    <div class="services-timeline-features">
                                        @foreach ($item['features'] as $feature)
                                            <span class="services-timeline-feature">
                                                <x-icon icon="lucide:check" class="w-3.5 h-3.5" />
                                                {{ is_array($feature) ? ($feature['text'] ?? '') : $feature }}
                                            </span>
                                        @endforeach
                                    </div>
                                @endif

                                {{-- Button --}}
                                @if (!empty($item['button_text']) && !empty($item['button_url']))
                                    <a href="{{ $item['button_url'] }}" class="services-timeline-btn">
                                        {{ $item['button_text'] }}
                                        <x-icon icon="{{ $item['button_icon'] ?? 'lucide:chevron-right' }}" class="w-4 h-4" />
                                    </a>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>


</div>