<?php
use Livewire\Component;
?>

<div>
<section id="services" class="services-icons-section {{ $isWhiteBackground ? 'services-icons-white' : 'services-icons-gray' }}" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    {{-- Background Elements --}}
    <div class="services-icons-bg">
        <div class="services-icons-hex services-icons-hex-1"></div>
        <div class="services-icons-hex services-icons-hex-2"></div>
        <div class="services-icons-hex services-icons-hex-3"></div>
    </div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative">
        {{-- Section Header --}}
        <div class="services-icons-header">
            <span class="services-icons-badge">
                <x-icon icon="lucide:sparkles" class="w-4 h-4" />
                {{ $section['badge'] }}
            </span>
            <h2 class="services-icons-title">{{ $section['title'] }}</h2>
            <p class="services-icons-subtitle">{{ $section['subtitle'] }}</p>
        </div>

        {{-- Services Grid --}}
        <div class="services-icons-grid">
            @foreach ($items as $index => $item)
                <div class="services-icons-item scroll-animate" style="animation-delay: {{ $index * 100 }}ms">
                    {{-- Large Icon --}}
                    <div class="services-icons-icon-wrap">
                        <div class="services-icons-icon">
                            <x-icon icon="{{ $item['icon'] ?? 'heroicons:sparkles' }}" class="w-10 h-10" />
                        </div>
                        <div class="services-icons-icon-ring"></div>
                        <div class="services-icons-icon-dots"></div>
                    </div>

                    {{-- Content --}}
                    <div class="services-icons-content">
                        <h3 class="services-icons-item-title">{{ $item['title'] ?? '' }}</h3>
                        <p class="services-icons-desc">{{ $item['description'] ?? '' }}</p>

                        {{-- Price --}}
                        @if (!empty($item['price']))
                            <div class="services-icons-price">
                                <x-icon icon="lucide:tag" class="w-4 h-4" />
                                <span>{{ $item['price'] }}</span>
                            </div>
                        @endif

                        {{-- Features --}}
                        @if (!empty($item['features']))
                            <div class="services-icons-features">
                                @foreach ($item['features'] as $feature)
                                    <div class="services-icons-feature">
                                        <span class="services-icons-feature-dot"></span>
                                        <span>{{ is_array($feature) ? ($feature['text'] ?? '') : $feature }}</span>
                                    </div>
                                @endforeach
                            </div>
                        @endif

                        {{-- Button --}}
                        @if (!empty($item['button_text']) && !empty($item['button_url']))
                            <a href="{{ $item['button_url'] }}" class="services-icons-btn">
                                {{ $item['button_text'] }}
                                <x-icon icon="{{ $item['button_icon'] ?? 'lucide:arrow-up-right' }}" class="w-4 h-4" />
                            </a>
                        @endif
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>


</div>