<?php
use Livewire\Component;
?>

<div>
<section class="features-overlap-section {{ $isWhiteBackground ? 'features-overlap-white' : 'features-overlap-gray' }}" @if($this->getPaddingStyle()) style="{{ $this->getPaddingStyle() }}" @endif>
    {{-- Background Waves --}}
    <div class="features-overlap-waves">
        <svg class="features-overlap-wave" viewBox="0 0 1200 120" preserveAspectRatio="none">
            <path d="M321.39,56.44c58-10.79,114.16-30.13,172-41.86,82.39-16.72,168.19-17.73,250.45-.39C823.78,31,906.67,72,985.66,92.83c70.05,18.48,146.53,26.09,214.34,3V0H0V27.35A600.21,600.21,0,0,0,321.39,56.44Z"></path>
        </svg>
    </div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative">
        <div class="features-overlap-container">
            @foreach ($items as $index => $feature)
                <div class="features-overlap-item scroll-animate" style="animation-delay: {{ $index * 100 }}ms; --overlap-index: {{ $index }}">
                    <div class="features-overlap-card">
                        {{-- Gradient Bar --}}
                        <div class="features-overlap-bar"></div>

                        {{-- Icon Badge --}}
                        <div class="features-overlap-badge">
                            <div class="features-overlap-icon">
                                <x-icon icon="{{ $feature['icon'] ?? 'heroicons:heart' }}" class="w-5 h-5" />
                            </div>
                        </div>

                        {{-- Content --}}
                        <div class="features-overlap-content">
                            <h3 class="features-overlap-title">{{ $feature['title'] }}</h3>
                            <p class="features-overlap-desc">{{ $feature['description'] }}</p>
                        </div>

                        {{-- Decorative Circle --}}
                        <div class="features-overlap-circle"></div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>


</div>